/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Liquids;

import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.BarrelPump;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Boiler;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidSilo;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidUtil;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pipe;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pump;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.OilRefinery;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class PipeLine {
    public static HashSet<PipeLine> allPipeLines = new HashSet();
    public HashSet<Pipe> pipes = new HashSet();
    private HashMap<Device.LiquidType, Integer> liquidsInPipes = new HashMap();

    public PipeLine(Block source) {
        allPipeLines.add(this);
        for (Block block : this.getPipeLineBlocks(source)) {
            if (Pipe.isPipe(block)) continue;
            Pipe pipe = new Pipe(block.getLocation());
            this.addPipe(pipe);
        }
    }

    public boolean addLocationPipe(Location loc) {
        if (loc.getBlock().hasMetadata("MT-Pipe")) {
            return false;
        }
        this.addPipe(new Pipe(loc));
        return true;
    }

    public void addPipe(Pipe pipe) {
        this.pipes.add(pipe);
        pipe.setLine(this);
    }

    public void removePipeLine() {
        for (Pipe pipe : this.pipes) {
            pipe.removePipe();
        }
        this.pipes.clear();
    }

    public void addLiquidType(Device.LiquidType type) {
        this.liquidsInPipes.put(type, 5);
        this.tickLiquids();
    }

    public void decorTickPipeLine() {
        for (Pipe pipe : this.pipes) {
            pipe.decorTick();
        }
    }

    public static void tickLiquidsInPipes() {
        for (PipeLine line : allPipeLines) {
            line.tickLiquids();
        }
    }

    public void tickLiquids() {
        block5: {
            block4: {
                Iterator<Map.Entry<Device.LiquidType, Integer>> iterator = this.liquidsInPipes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Device.LiquidType, Integer> entry = iterator.next();
                    int newTimer = entry.getValue() - 1;
                    if (newTimer > 0) {
                        entry.setValue(newTimer);
                        continue;
                    }
                    iterator.remove();
                }
                if (this.liquidsInPipes.isEmpty()) break block4;
                int index = ThreadLocalRandom.current().nextInt(this.liquidsInPipes.size());
                Device.LiquidType randomType = this.liquidsInPipes.keySet().stream().skip(index).findFirst().orElse(null);
                if (randomType == null) break block5;
                for (Pipe pipe : this.pipes) {
                    pipe.setType(randomType);
                }
                break block5;
            }
            for (Pipe pipe : this.pipes) {
                pipe.removeLiquidDisplay();
            }
        }
    }

    public HashSet<Block> getPipeLineBlocks(Block source) {
        ArrayList<BlockFace> faces = new ArrayList<BlockFace>();
        faces.add(BlockFace.UP);
        faces.add(BlockFace.DOWN);
        faces.add(BlockFace.EAST);
        faces.add(BlockFace.WEST);
        faces.add(BlockFace.NORTH);
        faces.add(BlockFace.SOUTH);
        HashMap scannedOrder = new HashMap();
        HashSet<Block> scannedPiping = new HashSet<Block>();
        ArrayList<Block> unscannedPiping = new ArrayList<Block>();
        int order = 0;
        scannedOrder.putIfAbsent(0, new HashSet());
        scannedOrder.putIfAbsent(1, new HashSet());
        scannedOrder.put(order, new HashSet());
        block0: for (BlockFace face : faces) {
            order = 0;
            Block sourceBlock = source.getRelative(face);
            if (!LiquidUtil.isPipeBlock(sourceBlock)) continue;
            Material wallMat = sourceBlock.getType();
            Material junctionMat = LiquidUtil.getJunctionMaterial(wallMat);
            unscannedPiping.add(sourceBlock);
            order = 1;
            ((HashSet)scannedOrder.get(order)).add(sourceBlock);
            int maxScans = 200;
            while (unscannedPiping.size() > 0) {
                scannedOrder.putIfAbsent(++order, new HashSet());
                for (Block block : new ArrayList(unscannedPiping)) {
                    scannedPiping.add(block);
                    ((HashSet)scannedOrder.get(order)).add(block);
                    unscannedPiping.remove(block);
                    PipeLine.addCardinalPipes(block, unscannedPiping, scannedPiping, wallMat, junctionMat);
                    --maxScans;
                }
                if (maxScans <= 0) continue block0;
            }
        }
        return scannedPiping;
    }

    private static void addCardinalPipes(Block block, ArrayList<Block> unscannedPiping, HashSet<Block> scannedPiping, Material wallMat, Material junction) {
        PipeLine.checkFace(block, unscannedPiping, BlockFace.UP, scannedPiping, wallMat, junction);
        PipeLine.checkFace(block, unscannedPiping, BlockFace.DOWN, scannedPiping, wallMat, junction);
        PipeLine.checkFace(block, unscannedPiping, BlockFace.EAST, scannedPiping, wallMat, junction);
        PipeLine.checkFace(block, unscannedPiping, BlockFace.WEST, scannedPiping, wallMat, junction);
        PipeLine.checkFace(block, unscannedPiping, BlockFace.NORTH, scannedPiping, wallMat, junction);
        PipeLine.checkFace(block, unscannedPiping, BlockFace.SOUTH, scannedPiping, wallMat, junction);
    }

    private static void checkFace(Block block, ArrayList<Block> unscannedPiping, BlockFace face, HashSet<Block> scannedPiping, Material wallMat, Material junctionType) {
        Block scanTarget = block.getRelative(face);
        Material scanType = scanTarget.getType();
        if ((scanType.equals((Object)wallMat) || scanType.equals((Object)junctionType)) && !scannedPiping.contains(scanTarget)) {
            unscannedPiping.add(scanTarget);
        }
    }

    public static void pipeLineCheck(Block firstPipe) {
        if (!MineMain.prettyPipes) {
            return;
        }
        if (!Pipe.isPipe(firstPipe) && MinetorioListener.isPlayerNearby2DOPT(firstPipe.getLocation(), MineMain.chunkViewDistance) && (LiquidUtil.isPipeBlock(firstPipe) || firstPipe.getType().toString().contains("POLISHED"))) {
            new PipeLine(firstPipe);
        }
    }

    public static boolean isPipeLineSpawner(Device device) {
        if (device instanceof Pump || device instanceof OilRefinery) {
            return true;
        }
        if (device instanceof LiquidSilo || device instanceof Boiler) {
            return true;
        }
        return device instanceof BarrelPump;
    }
}

