/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CrudeAssembler
extends Device {
    private static String classSpacedNamed = "Crude Assembler";
    private static final long serialVersionUID = 7571974070728037992L;
    private String selectedRecipeID;
    public MTRecipe.RecipeType aseemblerType;
    private transient HashMap<ItemStack, Integer> lastIngredients = new HashMap();
    private transient HashMap<ItemStack, Integer> lastStored = new HashMap();
    private transient HashMap<NamespacedKey, Integer> lastIngredients2 = new HashMap();
    private transient HashMap<NamespacedKey, Integer> lastStored2 = new HashMap();
    public transient ItemStack lastResult;

    public CrudeAssembler(Location loc) {
        super(loc);
        this.setMaterial("CRAFTING_TABLE");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(5);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(0);
        this.setActionPower(0);
        ArrayList<Integer> inputSlots = new ArrayList<Integer>();
        int i = 0;
        while (i <= 2) {
            inputSlots.add(i);
            inputSlots.add(i + 9);
            inputSlots.add(i + 18);
            ++i;
        }
        this.setInputSlots(inputSlots);
        this.setNeedsPower(false);
        ArrayList<Integer> outputSlots = new ArrayList<Integer>();
        outputSlots.add(15);
        outputSlots.add(16);
        outputSlots.add(17);
        this.setOutputSlots(outputSlots);
        ArrayList<Integer> allSlots = new ArrayList<Integer>();
        allSlots.addAll(inputSlots);
        allSlots.addAll(outputSlots);
        this.setClickableSlots(allSlots);
        this.setPollutionGen(10);
        this.updateDeviceHeadItem();
        this.displayRotationOffset = 180;
        this.aseemblerType = MTRecipe.RecipeType.CRUDE;
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    @Override
    public ArrayList<String> stackDescription() {
        return new ArrayList<String>();
    }

    @Override
    public void updateUI() {
        Inventory inv = null;
        if (this.inv == null) {
            this.inv = TUInventory.createInventory(ChatColor.GOLD + ChatColor.BOLD + "Crafter", 3, "Crafter");
        }
        inv = this.inv;
        ItemStack pane = MainMenu.createWhitePane();
        inv.setItem(3, pane);
        inv.setItem(5, pane);
        inv.setItem(12, pane);
        inv.setItem(13, pane);
        inv.setItem(14, pane);
        inv.setItem(21, pane);
        inv.setItem(23, pane);
        pane = MainMenu.createYellowPane();
        inv.setItem(6, pane);
        inv.setItem(7, pane);
        inv.setItem(8, pane);
        inv.setItem(24, pane);
        inv.setItem(25, pane);
        inv.setItem(26, pane);
        ItemStack targetCraft = TUItems.createItem(Material.BARRIER, String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No Recipe Selected", TUItems.basicLore(MineUtil.colon(" Click", "Change Recipe")));
        MTRecipe recipe = null;
        if (this.getSelectedRecipeID() != null) {
            recipe = RecipeUtils.getRecipe(this.getSelectedRecipeID());
            if (recipe != null) {
                targetCraft = recipe.getResult();
                TUItems.addLore(targetCraft, String.valueOf(ChatColor.GOLD) + " Click: " + String.valueOf(ChatColor.WHITE) + "Change Recipe");
            }
        } else {
            TUItems.setModelData(targetCraft, 9522);
        }
        inv.setItem(22, targetCraft);
        ItemStack infoStack = TUItems.createItem(Material.CRAFTING_TABLE, String.valueOf(MineItems.whiteBold()) + "Device Information", new ArrayList<String>());
        infoStack = TUItems.setModelData(infoStack, 9525);
        if (recipe != null) {
            TUItems.addLore(infoStack, CrudeAssembler.crafterLore(this, recipe.getResult(), this.lastIngredients, this.lastStored, recipe, this.lastIngredients2, this.lastStored2));
        } else {
            TUItems.addLore(infoStack, String.valueOf(ChatColor.RED) + " No Recipe Selected");
        }
        inv.setItem(4, infoStack);
    }

    @Override
    public void noGridTick() {
        if (this.deviceName.equals("Crude Assembler")) {
            this.tickDeviceAction();
        }
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        this.lastResult = null;
        MTRecipe recipe = RecipeUtils.getRecipe(this.selectedRecipeID);
        if (recipe != null) {
            this.lastResult = recipe.getResult();
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdateAssembler(nearbyPlayer, this.lastResult);
    }

    @Override
    public void action() {
        if (this.getIdlePower() != 0 && (this.getGrid() == null || this.getGrid() != null && !this.getGrid().hasPower(this.getActionPower()))) {
            this.setFailReason("Need Power");
            return;
        }
        if (this.deviceName.equals("Crude Assembler")) {
            if (this.getGrid() != null && this.getGrid().hasPower(3)) {
                this.setActionTimer(5);
                this.setIdlePower(1);
                this.setActionPower(3);
            } else {
                this.setActionTimer(15);
                this.setIdlePower(0);
                this.setActionPower(0);
            }
        }
        if (this.getOutputSlot() == -1) {
            this.setFailReason("Output Full");
            return;
        }
        this.produceCraft();
    }

    public void produceCraft() {
        int amount;
        if (this.getSelectedRecipeID() == null) {
            this.setFailReason("No Recipe Selected");
            return;
        }
        MTRecipe recipe = RecipeUtils.getRecipe(this.selectedRecipeID);
        if (recipe == null) {
            this.setFailReason("Invalid Recipe Selected");
            return;
        }
        ArrayList<ItemStack> ings = recipe.getIngredientsRemoveLiquids();
        if (recipe.getRecipeLiquid() != null && !this.hasLiquid(recipe.getRecipeLiquid(), recipe.getLiquidAmount())) {
            return;
        }
        this.updateCraftingMaterialChoices(ings);
        HashMap<ItemStack, Integer> recipeItems = CrudeAssembler.getTotaledStacks(ings);
        HashMap<NamespacedKey, Integer> recipeItems2 = CrudeAssembler.extractMTPDCItems(recipeItems);
        HashMap<ItemStack, Integer> storedItems = CrudeAssembler.getTotaledStacks(this.getInputItemsAsClones());
        HashMap<NamespacedKey, Integer> storedItems2 = CrudeAssembler.extractMTPDCItems(storedItems);
        this.lastIngredients = recipeItems;
        this.lastIngredients2 = recipeItems2;
        this.lastStored = storedItems;
        this.lastStored2 = storedItems2;
        this.lastResult = recipe.getResult();
        for (ItemStack itemStack : new ArrayList<ItemStack>(recipeItems.keySet())) {
            if (storedItems.getOrDefault(itemStack, 0) >= recipeItems.get(itemStack)) continue;
            return;
        }
        for (NamespacedKey namespacedKey : new ArrayList<NamespacedKey>(recipeItems2.keySet())) {
            if (storedItems2.getOrDefault(namespacedKey, 0) >= recipeItems2.get(namespacedKey)) continue;
            return;
        }
        if (recipe.getBucketIngredientCount() > 0 && this.openSlotCount() <= 1) {
            this.setFailReason("No ouput space for buckets");
            return;
        }
        for (ItemStack itemStack : new ArrayList<ItemStack>(recipeItems.keySet())) {
            amount = recipeItems.get(itemStack);
            TUMaths.removeStackAmount(this.getInventory(), itemStack, amount);
            if (this.getGrid() == null) continue;
            this.getGrid().logItem(itemStack, -amount);
        }
        for (NamespacedKey namespacedKey : new ArrayList<NamespacedKey>(recipeItems2.keySet())) {
            amount = recipeItems2.get(namespacedKey);
            this.removePDCItem(namespacedKey, amount);
        }
        if (recipe.getRecipeLiquid() != null) {
            this.removeLiquid(recipe.getRecipeLiquid(), recipe.getLiquidAmount());
            this.getGrid().logLiquid(recipe.getRecipeLiquid(), -recipe.getLiquidAmount());
        }
        this.getInventory().setItem(this.getOutputSlot(), recipe.getResult());
        if (this.getGrid() != null) {
            this.getGrid().logItem(recipe.getResult(), 1);
        }
        if (MinetorioListener.isPlayerNearby1DOPT(this.getLocationREADONLY(), 16.0)) {
            this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ENTITY_SHEEP_SHEAR, 0.2f, 1.0f);
        }
        if (recipe.getBucketIngredientCount() > 0) {
            this.getInventory().setItem(this.getOutputSlot(), new ItemStack(Material.BUCKET, recipe.getBucketIngredientCount()));
            if (this.getGrid() != null) {
                this.getGrid().logItem(recipe.getResult(), recipe.getBucketIngredientCount());
            }
        }
        if (this.deviceName.equals("Crude Assembler")) {
            if (this.getActionPower() != 0 && this.getGrid() != null) {
                this.setConsumingPower(true);
                this.getGrid().consumePower(this, this.getActionPower());
            }
        } else {
            this.setConsumingPower(true);
            this.getGrid().consumePower(this, this.getActionPower());
        }
    }

    public static HashMap<NamespacedKey, Integer> extractMTPDCItems(HashMap<ItemStack, Integer> items) {
        HashMap<NamespacedKey, Integer> extracted = new HashMap<NamespacedKey, Integer>();
        for (ItemStack item : new ArrayList<ItemStack>(items.keySet())) {
            if (!MineItems.isMinetorioItem(item)) continue;
            for (NamespacedKey key : item.getItemMeta().getPersistentDataContainer().getKeys()) {
                String stringKey;
                if (MineItems.isMinetorioItemKey.equals((Object)key) || Device.isDeviceItemKey.equals((Object)key) || !(stringKey = key.getKey()).contains("mt_")) continue;
                extracted.put(key, extracted.getOrDefault(key, 0) + items.get(item));
                items.remove(item);
            }
        }
        return extracted;
    }

    private void removePDCItem(NamespacedKey key, int amount) {
        int remaining = amount;
        ItemStack removedStack = null;
        for (ItemStack stack : this.getInputItems()) {
            if (!stack.hasItemMeta() || !stack.getItemMeta().getPersistentDataContainer().has(key)) continue;
            int removeAmount = 0;
            removeAmount = stack.getAmount() < remaining ? stack.getAmount() : remaining;
            remaining -= removeAmount;
            if (removedStack == null) {
                removedStack = stack.clone();
            }
            stack.setAmount(stack.getAmount() - removeAmount);
            if (remaining > 0) continue;
            return;
        }
        if (removedStack != null && this.getGrid() != null) {
            this.getGrid().logItem(removedStack, -amount);
        }
    }

    public static int getPDCItemCount(Inventory inv, NamespacedKey key) {
        int stored = 0;
        for (ItemStack stack : inv) {
            if (stack == null || !stack.hasItemMeta() || !stack.getItemMeta().getPersistentDataContainer().has(key)) continue;
            stored += stack.getAmount();
        }
        return stored;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player;
        if (event.getSlot() == 22) {
            player = (Player)event.getWhoClicked();
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            RecipeUtils.openRecipeSelector(player, this, this.aseemblerType);
        }
        player = (Player)event.getWhoClicked();
        if (event.getSlot() == 4) {
            int needed;
            int stored;
            int amount;
            if (this.getSelectedRecipeID() == null) {
                return;
            }
            MTRecipe recipe = RecipeUtils.getRecipe(this.selectedRecipeID);
            if (recipe == null) {
                return;
            }
            ArrayList<ItemStack> ings = recipe.getIngredientsRemoveLiquids();
            this.updateCraftingMaterialChoices(ings);
            this.updateLastIngredients();
            PlayerData pd = PlayerData.getPlayerData(event.getWhoClicked().getUniqueId().toString());
            HashMap<ItemStack, Integer> recipeItems = CrudeAssembler.getTotaledStacks(ings);
            HashMap<NamespacedKey, Integer> recipeItems2 = CrudeAssembler.extractMTPDCItems(recipeItems);
            HashMap<ItemStack, Integer> storedItems = CrudeAssembler.getTotaledStacks(this.getInputItemsAsClones());
            HashMap<NamespacedKey, Integer> storedItems2 = CrudeAssembler.extractMTPDCItems(storedItems);
            ArrayList<ItemStack> newIngs = new ArrayList<ItemStack>();
            for (ItemStack stack : new ArrayList<ItemStack>(recipeItems.keySet())) {
                ItemStack addStack = stack.clone();
                amount = recipeItems.get(stack);
                needed = amount - (stored = storedItems.getOrDefault(stack, 0).intValue());
                if (needed <= 0) continue;
                addStack.setAmount(needed);
                newIngs.add(addStack);
            }
            HashMap<NamespacedKey, Integer> neededPDCS = new HashMap<NamespacedKey, Integer>();
            for (NamespacedKey key : new ArrayList<NamespacedKey>(recipeItems2.keySet())) {
                amount = recipeItems2.get(key);
                needed = amount - (stored = storedItems2.getOrDefault(key, 0).intValue());
                if (needed <= 0) continue;
                neededPDCS.put(key, needed);
            }
            pd.setGroceryList(newIngs, neededPDCS, recipe.getResult(), this.deviceName);
            if (ings.size() == 0 && this.lastIngredients2.size() == 0) {
                MineUtil.sendMessage(player, LocaleUtil.messageText("Assembler_Has_Ingredients"));
            }
            player.playSound((Entity)player, Sound.ITEM_BOOK_PAGE_TURN, 0.5f, 1.0f);
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, CrudeAssembler.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.MANUFACTORING, new CrudeAssembler(null).getDeviceStack(), true);
    }

    public String getSelectedRecipeID() {
        return this.selectedRecipeID;
    }

    public void setSelectedRecipeID(String selectedRecipeID) {
        this.selectedRecipeID = selectedRecipeID;
    }

    public void updateLastIngredients() {
        if (this.getSelectedRecipeID() == null) {
            return;
        }
        MTRecipe recipe = RecipeUtils.getRecipe(this.selectedRecipeID);
        if (recipe == null) {
            return;
        }
        ArrayList<ItemStack> ings = recipe.getIngredientsRemoveLiquids();
        this.updateCraftingMaterialChoices(ings);
        HashMap<ItemStack, Integer> recipeItems = CrudeAssembler.getTotaledStacks(ings);
        HashMap<NamespacedKey, Integer> recipeItems2 = CrudeAssembler.extractMTPDCItems(recipeItems);
        HashMap<ItemStack, Integer> storedItems = CrudeAssembler.getTotaledStacks(this.getInputItemsAsClones());
        HashMap<NamespacedKey, Integer> storedItems2 = CrudeAssembler.extractMTPDCItems(storedItems);
        this.lastIngredients = recipeItems;
        this.lastIngredients2 = recipeItems2;
        this.lastStored = storedItems;
        this.lastStored2 = storedItems2;
        this.lastResult = recipe.getResult();
    }
}

