/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Generators.CombustionGenerator;
import com.MT.xxxtrigger50xxx.Devices.Generators.PetroleumEngine;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Boiler;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.Devices.MoverInput;
import com.MT.xxxtrigger50xxx.Devices.MoverOutput;
import com.MT.xxxtrigger50xxx.Devices.Transport.RocketSilo;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlastFurnace;
import org.bukkit.block.Furnace;
import org.bukkit.inventory.ItemStack;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsAPI;

public class MoverIOCenter {
    public static DeviceIOType determineIOType(Location loc) {
        Material material = loc.getBlock().getType();
        if (!material.equals((Object)Material.AIR)) {
            Device device = Device.getDevice(loc);
            if (device != null) {
                if (device instanceof RocketSilo) {
                    return DeviceIOType.ROCKET_SILO;
                }
                if (device.chainingMoverBehavior) {
                    return DeviceIOType.CHAIN;
                }
                if (device.standardMoverBehavior) {
                    return DeviceIOType.STANDARD;
                }
                if (device.deviceName.contains("Crafter")) {
                    return DeviceIOType.CRAFTER;
                }
                if (device.deviceName.contains("Item Forge")) {
                    return DeviceIOType.CRAFTER;
                }
                if (device.deviceName.contains("Auto") || device.isUsingAutoUI()) {
                    return DeviceIOType.AUTODEVICE;
                }
                if (device.deviceName.contains("Basic Assembler") || device.deviceName.contains("Advanced Assembler") || device.deviceName.contains("Crude Assembler")) {
                    return DeviceIOType.ASSEMBLER;
                }
                if (device.deviceName.contains("Train Station")) {
                    return DeviceIOType.TRAIN_STATION;
                }
            }
            if (material.equals((Object)Material.FURNACE)) {
                return DeviceIOType.FURNACE;
            }
            if (material.equals((Object)Material.BLAST_FURNACE)) {
                return DeviceIOType.BLAST_FURNACE;
            }
            if (material.equals((Object)Material.SMOKER)) {
                return DeviceIOType.SMOKER;
            }
            if (material.equals((Object)Material.CHEST) || !MineMain.is1218AndBelow && material.equals((Object)Material.COPPER_CHEST)) {
                if (MineMain.usingAdvancedChests && AdvancedChestsAPI.getChestManager().getAdvancedChest(loc) != null) {
                    return DeviceIOType.ADVANCED_CHEST;
                }
                return DeviceIOType.CHEST;
            }
            if (material.equals((Object)Material.TRAPPED_CHEST)) {
                return DeviceIOType.TRAPPED_CHEST;
            }
            if (material.equals((Object)Material.BARREL)) {
                return DeviceIOType.BARREL;
            }
            if (material.equals((Object)Material.HOPPER)) {
                return DeviceIOType.HOPPER;
            }
            if (material.equals((Object)Material.DISPENSER) || material.equals((Object)Material.DROPPER)) {
                return DeviceIOType.DISPENSER;
            }
            if (material.toString().contains("CARPET")) {
                return DeviceIOType.BELT;
            }
            if (material.toString().contains("RAIL")) {
                return DeviceIOType.STORAGE_CART;
            }
            if (material.toString().contains("FENCE")) {
                return DeviceIOType.LIFT;
            }
        } else {
            return DeviceIOType.AIR;
        }
        return null;
    }

    public static HashSet<Integer> getInSlots(MoverInput mi) {
        if (mi.getCachedInputSlots() != null) {
            return mi.getCachedInputSlots();
        }
        HashSet<Integer> slots = new HashSet<Integer>();
        if (mi.getType().equals((Object)DeviceIOType.ADVANCED_CHEST)) {
            return slots;
        }
        if (mi.getType().equals((Object)DeviceIOType.CHEST) || mi.getType().equals((Object)DeviceIOType.DOUBLE_CHEST) || mi.getType().equals((Object)DeviceIOType.TRAPPED_CHEST) || mi.getType().equals((Object)DeviceIOType.BARREL) || mi.getType().equals((Object)DeviceIOType.HOPPER) || mi.getType().equals((Object)DeviceIOType.STORAGE_CART)) {
            int containerSize = mi.getInventorySize();
            int i = 0;
            while (i <= containerSize - 1) {
                slots.add(i);
                ++i;
            }
        }
        if (mi.getType().equals((Object)DeviceIOType.TRAIN_STATION)) {
            int i = 18;
            while (i <= 53) {
                slots.add(i);
                ++i;
            }
        }
        if (mi.getType().equals((Object)DeviceIOType.CHAIN)) {
            Device device = Device.getDevice(mi.getMover().getInputLocation());
            slots.addAll(device.getInSlots());
        }
        if (mi.getType().equals((Object)DeviceIOType.STANDARD)) {
            Device device = Device.getDevice(mi.getMover().getInputLocation());
            slots.addAll(device.getOutSlots());
        }
        if (mi.getType().equals((Object)DeviceIOType.FURNACE)) {
            boolean useDefault = true;
            Device device = Device.getDevice(mi.getMover().getInputLocation());
            if (device != null) {
                if (device instanceof CombustionGenerator) {
                    slots.add(1);
                    useDefault = false;
                } else if (device instanceof Boiler) {
                    slots.add(1);
                    useDefault = false;
                }
            }
            if (useDefault && mi.isLoaded()) {
                if (mi.getType().equals((Object)mi.getMover().outType)) {
                    slots.add(0);
                    slots.add(1);
                    slots.add(2);
                    return slots;
                }
                slots.add(2);
                Furnace furnace = (Furnace)mi.getMover().getInputLocation().getBlock().getState();
                if (TUItems.isValid(furnace.getInventory().getItem(1)) && furnace.getInventory().getItem(1).getType().equals((Object)Material.BUCKET)) {
                    slots.add(1);
                }
            }
        }
        if (mi.getType().equals((Object)DeviceIOType.BLAST_FURNACE)) {
            Device device = Device.getDevice(mi.getMover().getInputLocation());
            if (device != null && device instanceof PetroleumEngine) {
                return slots;
            }
            if (mi.isLoaded()) {
                if (mi.getType().equals((Object)mi.getMover().outType)) {
                    slots.add(0);
                    slots.add(1);
                    slots.add(2);
                    return slots;
                }
                BlastFurnace furnace = (BlastFurnace)mi.getMover().getInputLocation().getBlock().getState();
                if (TUItems.isValid(furnace.getInventory().getItem(1)) && furnace.getInventory().getItem(1).getType().equals((Object)Material.BUCKET)) {
                    slots.add(1);
                }
            }
        }
        if (mi.getType().equals((Object)DeviceIOType.SMOKER) || mi.getType().equals((Object)DeviceIOType.BLAST_FURNACE)) {
            if (mi.getType().equals((Object)mi.getMover().outType)) {
                slots.add(0);
                slots.add(1);
                slots.add(2);
                return slots;
            }
            slots.add(2);
        }
        if (mi.getType().equals((Object)DeviceIOType.CRAFTER) || mi.getType().equals((Object)DeviceIOType.ASSEMBLER)) {
            slots.add(15);
            slots.add(16);
            slots.add(17);
        }
        if (mi.getType().equals((Object)DeviceIOType.AUTODEVICE)) {
            int i = 18;
            while (i <= 26) {
                slots.add(i);
                ++i;
            }
        }
        if (mi.getType().equals((Object)DeviceIOType.DISPENSER)) {
            int i = 0;
            while (i < 9) {
                slots.add(i);
                ++i;
            }
        }
        mi.setCachedDynamicSlot(slots);
        return slots;
    }

    public static ArrayList<Integer> getDynamicSlots(ItemStack itemToAdd, MoverOutput mo, Mover.OutDirection out) {
        int i;
        if (!(mo.getCachedDynamicSlots() == null || mo.getType().equals((Object)DeviceIOType.FURNACE) || mo.getType().equals((Object)DeviceIOType.BLAST_FURNACE) || mo.getType().equals((Object)DeviceIOType.SMOKER))) {
            return mo.getCachedDynamicSlots();
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        if (mo.getType().equals((Object)DeviceIOType.BLAST_FURNACE)) {
            if (TUItems.isFuelSource(itemToAdd)) {
                slots.add(1);
            }
            if (TUItems.isSmeltable(itemToAdd)) {
                slots.add(0);
            }
        }
        if (mo.getType().equals((Object)DeviceIOType.FURNACE)) {
            if (TUItems.isFuelSource(itemToAdd)) {
                slots.add(1);
            }
            if (TUItems.isCookable(itemToAdd) || TUItems.isRaw(itemToAdd.getType()) || TUItems.isFurnaceSpecific(itemToAdd)) {
                slots.add(0);
            }
        }
        if (mo.getType().equals((Object)DeviceIOType.SMOKER)) {
            if (TUItems.isFuelSource(itemToAdd)) {
                slots.add(1);
            }
            if (TUItems.isRaw(itemToAdd.getType())) {
                slots.add(0);
            }
        }
        if ((mo.getType().equals((Object)DeviceIOType.CHEST) || mo.getType().equals((Object)DeviceIOType.DOUBLE_CHEST) || mo.getType().equals((Object)DeviceIOType.TRAPPED_CHEST) || mo.getType().equals((Object)DeviceIOType.BARREL) || mo.getType().equals((Object)DeviceIOType.HOPPER) || mo.getType().equals((Object)DeviceIOType.STORAGE_CART)) && mo.getInventory() != null) {
            int invSize = mo.getInventory().getSize();
            int i2 = 0;
            while (i2 < invSize) {
                slots.add(i2);
                ++i2;
            }
        }
        if (mo.getType().equals((Object)DeviceIOType.CRAFTER) || mo.getType().equals((Object)DeviceIOType.ASSEMBLER)) {
            slots.add(0);
            slots.add(1);
            slots.add(2);
            slots.add(9);
            slots.add(10);
            slots.add(11);
            slots.add(18);
            slots.add(19);
            slots.add(20);
        }
        if (mo.getType().equals((Object)DeviceIOType.AUTODEVICE) || mo.getType().equals((Object)DeviceIOType.ROCKET_SILO)) {
            i = 0;
            while (i <= 8) {
                slots.add(i);
                ++i;
            }
        }
        if (mo.getType().equals((Object)DeviceIOType.TRAIN_STATION)) {
            i = 18;
            while (i <= 53) {
                slots.add(i);
                ++i;
            }
        }
        if (mo.getType().equals((Object)DeviceIOType.CHAIN)) {
            Device device = Device.getDevice(mo.getMover().getOutputLocation(out));
            slots.addAll(device.getInSlots());
        }
        if (mo.getType().equals((Object)DeviceIOType.STANDARD)) {
            Device device = Device.getDevice(mo.getMover().getOutputLocation(out));
            slots.addAll(device.getInSlots());
        }
        if (mo.getType().equals((Object)DeviceIOType.DISPENSER)) {
            int i3 = 0;
            while (i3 <= 8) {
                slots.add(i3);
                ++i3;
            }
        }
        mo.setCachedDynamicSlot(slots);
        return mo.getCachedDynamicSlots();
    }

    public static boolean isContainer(DeviceIOType type) {
        return type.equals((Object)DeviceIOType.CHEST) || type.equals((Object)DeviceIOType.DOUBLE_CHEST);
    }

    public static boolean isBlockHolderIOType(DeviceIOType type) {
        if (type.equals((Object)DeviceIOType.CHEST) || type.equals((Object)DeviceIOType.DOUBLE_CHEST) || type.equals((Object)DeviceIOType.TRAPPED_CHEST)) {
            return true;
        }
        if (type.equals((Object)DeviceIOType.FURNACE) || type.equals((Object)DeviceIOType.BLAST_FURNACE) || type.equals((Object)DeviceIOType.SMOKER)) {
            return true;
        }
        return type.equals((Object)DeviceIOType.BARREL) || type.equals((Object)DeviceIOType.HOPPER) || type.equals((Object)DeviceIOType.DISPENSER);
    }

    public static enum DeviceIOType {
        BELT("BELT", 0),
        CHEST("CHEST", 1),
        FURNACE("FURNACE", 2),
        CRAFTER("CRAFTER", 3),
        DOUBLE_CHEST("DOUBLE_CHEST", 4),
        TRAPPED_CHEST("TRAPPED_CHEST", 5),
        AUTODEVICE("AUTODEVICE", 6),
        ASSEMBLER("ASSEMBLER", 7),
        DISPENSER("DISPENSER", 8),
        BARREL("BARREL", 9),
        SMOKER("SMOKER", 10),
        BLAST_FURNACE("BLAST_FURNACE", 11),
        HOPPER("HOPPER", 12),
        TRAIN_STATION("TRAIN_STATION", 13),
        STORAGE_CART("STORAGE_CART", 14),
        COMPOSTER("COMPOSTER", 15),
        CHAIN("STANDARD", 16),
        LIFT("LIFT", 17),
        AIR("AIR", 18),
        ADVANCED_CHEST("ADVANCED_CHEST", 19),
        STANDARD("STANDARD", 20),
        ROCKET_SILO("ROCKET_SILO", 21),
        COPPER_CHEST("COPPER_CHEST", 21);


        private DeviceIOType(String name, int ordinal) {
        }
    }
}

