/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class AutoBreeder
extends Device {
    private static final long serialVersionUID = 7571974070728037017L;
    private transient Item item = null;
    private transient HashSet<String> needs = new HashSet();

    public AutoBreeder(Location loc) {
        super(loc);
        this.setMaterial("CHERRY_SLAB");
        this.deviceName = "Auto Breeder";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        this.setPollutionGen(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will feed nearby animals food for them to breed.");
        lore.add("- This requires a wheat or seeds in the input slots to operate.");
        lore.add("- This only works while animals are loaded nearby.");
        lore.add("- Range is limited to a 10x10x10 area.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        if (this.needs != null && this.needs.size() > 0) {
            ItemStack stack = this.createInfoIcon();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(" ");
            for (String str : this.needs) {
                lore.add(" " + String.valueOf(ChatColor.YELLOW) + str);
            }
            TUItems.addLore(stack, lore);
            this.getInventory().setItem(13, stack);
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.WHEAT, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance);
            boolean playerVeryNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance);
            if (!playerNear) {
                return;
            }
            boolean hasAnimals = false;
            boolean fedAnything = false;
            ArrayList<ItemStack> feedItems = this.getInputItems();
            HashSet<CallSite> couldntFeed = new HashSet<CallSite>();
            boolean hadCooldownAnimal = false;
            for (final Entity entity : MineUtil.getEntitiesInCubeRange(this.getLocation(), 5.0)) {
                if (!this.getGrid().hasPower(this.getActionPower())) break;
                if (!(entity instanceof Ageable)) continue;
                hasAnimals = true;
                Ageable ageable = (Ageable)entity;
                if (!ageable.isAdult() || !(entity instanceof Animals)) continue;
                Animals animal = (Animals)entity;
                if (entity.hasMetadata("Fed Tag")) {
                    hadCooldownAnimal = true;
                    continue;
                }
                boolean fed = false;
                for (ItemStack feedStack : feedItems) {
                    if (!animal.isBreedItem(feedStack)) continue;
                    fed = true;
                    entity.setMetadata("Fed Tag", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)"Fed Tag"));
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            if (entity != null && !entity.isDead()) {
                                entity.removeMetadata("Fed Tag", MineMain.getPlugin());
                            }
                        }
                    }, 6000L);
                    if (playerVeryNear) {
                        MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), animal.getEyeLocation(), MineMain.version.getDrippingLavaParticle(), 1, 0.5);
                        playSound = true;
                    }
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    this.logItem(feedStack, -feedStack.getAmount());
                    TUMaths.removeStackAmount(this.getInventory(), feedStack, 1);
                    feedStack.setAmount(feedStack.getAmount() - 1);
                    animal.setLoveModeTicks(600);
                    fedAnything = true;
                    break;
                }
                if (fed) continue;
                couldntFeed.add((CallSite)((Object)("Missing " + TUMaths.capitalize(entity.getType().toString().toLowerCase()) + " food!")));
            }
            this.needs = couldntFeed;
            if (playSound && playerVeryNear) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            }
            if (!hasAnimals) {
                this.setFailReason("No Animals Nearby");
                this.spawnInactiveParticles();
            } else if (!fedAnything && hadCooldownAnimal) {
                this.setFailReason("Animals on feed cooldown");
                this.spawnInactiveParticles();
            }
        }
    }
}

