/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.LiquidUtil;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pipe;
import com.MT.xxxtrigger50xxx.Devices.Liquids.PipeLine;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.ResourceZone;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class DeepDrill
extends Device {
    private static final long serialVersionUID = 7571974070728037023L;
    private transient Item item = null;
    public static int neededLiquid = 5;
    public static int oilProduce = 500;
    private transient ResourceZone rz = null;
    private String setRZ = null;

    public DeepDrill(Location loc) {
        super(loc);
        this.setMaterial("ANDESITE_SLAB");
        this.deviceName = "Deep Drill";
        this.setActionTimer(3);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        this.addLiquidType(Device.LiquidType.SULFURIC_ACID, 100);
        this.addLiquidType(Device.LiquidType.LUBRICANT, 100);
        this.addLiquidType(Device.LiquidType.OIL, oilProduce);
        this.setUsingAutoUI(true);
        this.setPollutionGen(60);
        this.displayLockedHorizontal = true;
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This requires iron pickaxe or better to be in the input slots to operate.");
        lore.add("- Requires a lubricant liquid connection to operate.");
        lore.add("- Each resource collected is placed into its own output slot.");
        lore.add("- Resource collected is base on the resource zone.");
        lore.add("- Resource zones are found by using seismic charges.");
        return lore;
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GOLDEN_PICKAXE, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered() && this.getGrid().hasPower(this.getActionPower())) {
            this.moveOil();
            if (MineMain.disableDeepDrillsUnloaded && !MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 128.0)) {
                return;
            }
            if (this.rz != null && !this.rz.isSave()) {
                this.rz = null;
                this.setRZ = null;
            }
            if (this.rz == null) {
                if (this.setRZ != null) {
                    for (ResourceZone nearby : ResourceZone.getAllResourceZones()) {
                        if (!nearby.getFileName().equals(this.setRZ)) continue;
                        this.rz = nearby;
                        break;
                    }
                    if (this.rz == null) {
                        this.setRZ = null;
                    }
                }
                if (this.rz == null) {
                    this.rz = ResourceZone.getNearResourceZone(this.getLocation());
                    if (this.rz != null) {
                        this.setRZ = this.rz.getFileName();
                    }
                }
            }
            if (this.rz != null) {
                Device.LiquidType requiredType = Device.LiquidType.LUBRICANT;
                if (this.rz.getResourceType().toLowerCase().contains("uranium")) {
                    requiredType = Device.LiquidType.SULFURIC_ACID;
                }
                if (this.getStoredLiquid(requiredType) < neededLiquid) {
                    this.setFailReason("Need 5 " + String.valueOf((Object)requiredType));
                    return;
                }
                if (this.rz.getStoredResource() > 0) {
                    ArrayList<ItemStack> picks = this.getPicks();
                    if (picks.size() > 0) {
                        boolean oil = this.rz.getResourceType().equals("OIL");
                        if (!oil) {
                            if (this.getOutputSlot() != -1) {
                                this.rz.extractResource(1);
                                ItemStack drillStack = this.rz.getResourceStack(1);
                                this.getInventory().setItem(this.getOutputSlot(), drillStack);
                                this.logItem(drillStack);
                                this.getGrid().consumePower(this, this.getActionPower());
                                this.setConsumingPower(true);
                                this.removeLiquid(requiredType, neededLiquid);
                                this.getGrid().logLiquid(requiredType, -neededLiquid);
                                MineUtil.damageItemStack(picks.get(0), this.getLocation(), this.getInventory());
                                if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                                    this.getLocation().getBlock().getWorld().playSound(this.getLocation(), Sound.BLOCK_CALCITE_BREAK, 0.5f, 0.8f);
                                }
                            } else {
                                this.setFailReason("No output slot");
                            }
                        } else {
                            int needed = this.getMaxLiquid(Device.LiquidType.OIL) - this.getStoredLiquid(Device.LiquidType.OIL);
                            if (needed > 0) {
                                this.rz.extractResource(needed);
                                this.addLiquid(Device.LiquidType.OIL, needed);
                                this.getGrid().consumePower(this, this.getActionPower());
                                this.setConsumingPower(true);
                                this.removeLiquid(requiredType, 10);
                                MineUtil.damageItemStack(picks.get(0), this.getLocation(), this.getInventory());
                                if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                                    this.getLocation().getBlock().getWorld().playSound(this.getLocation(), Sound.BLOCK_CALCITE_BREAK, 0.5f, 0.8f);
                                }
                            } else {
                                this.setFailReason("No space for liquid output");
                            }
                        }
                    } else {
                        this.setFailReason("Iron Pickaxe or better missing");
                    }
                } else {
                    this.setFailReason("Resource zone is empty.");
                }
            } else {
                this.setFailReason("No resource vein found.");
            }
        }
    }

    private void moveOil() {
        if (this.getStoredLiquid(Device.LiquidType.OIL) > 0) {
            for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
                PipeLine.pipeLineCheck(block);
            }
            if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
                boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), 8.0);
                HashSet<Device> connectedDevice = LiquidUtil.getConnectedDevices(this.getLocation().getBlock(), Device.LiquidType.OIL);
                this.moveLiquids(connectedDevice, Device.LiquidType.OIL, playerNear);
                if (playerNear) {
                    this.updateUI();
                }
            }
        }
    }

    private ArrayList<ItemStack> getPicks() {
        ArrayList<ItemStack> picks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getInputItems()) {
            if (!TUItems.isValid(stack) || !stack.getType().equals((Object)Material.IRON_PICKAXE) && !stack.getType().equals((Object)Material.DIAMOND_PICKAXE) && !stack.getType().equals((Object)Material.NETHERITE_PICKAXE)) continue;
            picks.add(stack);
        }
        return picks;
    }

    public static ArrayList<Location> generateLocationsInArea(Location corner1, Location corner2) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int minY = Math.min(corner1.getBlockY(), corner2.getBlockY());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int maxY = Math.max(corner1.getBlockY(), corner2.getBlockY());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    locations.add(new Location(corner1.getWorld(), (double)x, (double)y, (double)z));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return locations;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 13) {
            if (this.rz != null) {
                boolean next = false;
                ArrayList<ResourceZone> zones = ResourceZone.getNearResourceZones(this.getLocation());
                for (ResourceZone nearby : zones) {
                    if (next) {
                        this.rz = nearby;
                        this.setRZ = nearby.getFileName();
                        next = false;
                        break;
                    }
                    if (!nearby.equals(this.rz)) continue;
                    next = true;
                }
                if (next && zones.size() > 0) {
                    this.rz = zones.get(0);
                    this.setRZ = zones.get(0).getFileName();
                }
            } else {
                ArrayList<ResourceZone> zones = ResourceZone.getNearResourceZones(this.getLocation());
                if (zones.size() != 0) {
                    this.rz = zones.get(0);
                }
            }
            Player player = (Player)event.getWhoClicked();
            player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.updateUI();
        }
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.rz != null) {
            if (!this.rz.getResourceType().toLowerCase().contains("uranium")) {
                lore.add(MineUtil.colon(" Lubricant", "" + this.getStoredLiquid(Device.LiquidType.LUBRICANT)));
                if (this.rz.getResourceType().equals("OIL")) {
                    lore.add(MineUtil.colon(" Oil", this.getStoredLiquid(Device.LiquidType.OIL) + "/" + this.getMaxLiquid(Device.LiquidType.OIL)));
                }
            } else {
                lore.add(MineUtil.colon(" Sulfric Acid", "" + this.getStoredLiquid(Device.LiquidType.SULFURIC_ACID)));
            }
            lore.add(" ");
            lore.add(MineItems.whiteBold() + " Mineable Resource Zones");
            ArrayList<ResourceZone> zones = ResourceZone.getNearResourceZones(this.getLocation());
            for (ResourceZone rz : zones) {
                if (this.rz.equals(rz)) {
                    lore.add(String.valueOf(ChatColor.WHITE) + "  > " + TUMaths.simplifyNumber(rz.getStoredResource()) + " " + rz.getResourceType());
                    continue;
                }
                lore.add(String.valueOf(ChatColor.WHITE) + "    " + TUMaths.simplifyNumber(rz.getStoredResource()) + " " + rz.getResourceType());
            }
            if (zones.size() > 1) {
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.YELLOW) + "  -> Click to cycle target resource zone");
            }
        }
        return lore;
    }

    private void moveLiquids(HashSet<Device> devices, Device.LiquidType liquidType, boolean playerNear) {
        if (devices.size() > 0) {
            boolean liquidGiven = false;
            int baseLiquidEach = this.getStoredLiquid(liquidType) / devices.size();
            if (baseLiquidEach == 0) {
                return;
            }
            for (Device device2 : devices) {
                if (device2.getStoredLiquid(liquidType) >= device2.getMaxLiquid(liquidType)) continue;
                liquidGiven = true;
                int liquidNeeded = device2.getMaxLiquid(liquidType) - device2.getStoredLiquid(liquidType);
                if (liquidNeeded > baseLiquidEach) {
                    device2.addLiquid(liquidType, baseLiquidEach);
                    this.removeLiquid(liquidType, baseLiquidEach);
                    continue;
                }
                device2.addLiquid(liquidType, liquidNeeded);
                this.removeLiquid(liquidType, liquidNeeded);
            }
            if (playerNear && liquidGiven) {
                this.getLocation().getBlock().getWorld().playSound(this.getLocation(), Sound.ITEM_BOTTLE_FILL, 0.5f, 0.8f);
            }
            if (liquidGiven) {
                for (Block block : TUMaths.getNearbyBlocks6Sided(this.getLocation().getBlock())) {
                    if (!Pipe.isPipe(block)) continue;
                    Pipe pipe = (Pipe)((MetadataValue)block.getMetadata("MT-Pipe").get(0)).value();
                    pipe.getLine().addLiquidType(Device.LiquidType.STEAM);
                    pipe.getLine().decorTickPipeLine();
                }
            }
        }
    }
}

