/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ProductionMonitor
extends Device {
    private static final long serialVersionUID = -3339401797254451315L;

    public ProductionMonitor(Location loc) {
        super(loc);
        this.setMaterial("OBSERVER");
        this.deviceName = "Production Monitor";
        this.setActionTimer(1);
        this.setActionPower(0);
        this.setIdlePower(3);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setStoreForm(false);
        this.updateDeviceHeadItem();
    }

    @Override
    public void recreateInv() {
        this.inv = TUInventory.createInventory(ChatColor.GOLD + ChatColor.BOLD + this.deviceName, 6, this.deviceName);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device can display production stats!");
        lore.add("- Stat are from all devices on the power grid!");
        return lore;
    }

    @Override
    public void updateUI() {
        int i = 45;
        while (i < 54) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        this.getInventory().setItem(49, this.createInfoIcon());
        ItemStack air = new ItemStack(Material.AIR);
        int i2 = 0;
        while (i2 < 45) {
            this.inv.setItem(i2, air);
            ++i2;
        }
        int slot = 0;
        if (this.getGrid() != null) {
            HashMap<String, Integer> minLogPos = this.getGrid().getMinuteLogTypeNEW(true);
            HashMap<String, Integer> minLogNeg = this.getGrid().getMinuteLogTypeNEW(false);
            ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(minLogPos.entrySet());
            entryList.sort(Map.Entry.comparingByKey());
            LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
            for (Map.Entry entry : entryList) {
                sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
            }
            for (String string : sortedMap.keySet()) {
                int negAmount = minLogNeg.getOrDefault(string, 0);
                double minuteRate = minLogPos.get(string) + negAmount;
                double secondRate = TUMaths.roundDouble(minuteRate / 60.0, 2);
                double hourlyRate = TUMaths.roundDouble(minuteRate * 60.0, 2);
                ArrayList<String> lore = new ArrayList<String>();
                String symbol = String.valueOf(ChatColor.GREEN) + "\u2191";
                if (minuteRate < 0.0) {
                    symbol = String.valueOf(ChatColor.RED) + "\u2193";
                }
                lore.add(" ");
                lore.add(MineItems.whiteBold() + "Production Rate");
                lore.add(MineItems.whiteBold() + "----------------");
                lore.add(symbol + " " + secondRate + "/s");
                lore.add(symbol + " " + minuteRate + "/m");
                lore.add(symbol + " " + hourlyRate + "/h");
                lore.add(" ");
                lore.add(MineItems.whiteBold() + "Production Amount");
                lore.add(MineItems.whiteBold() + "----------------");
                if (minLogPos.containsKey(string)) {
                    lore.add(String.valueOf(ChatColor.GREEN) + "\u2191 " + minLogPos.get(string) * 12 + "/m");
                }
                if (minLogNeg.containsKey(string)) {
                    lore.add(String.valueOf(ChatColor.RED) + "\u2193 " + minLogNeg.get(string) * 12 + "/m");
                }
                Material mat = Material.PAPER;
                String name = string;
                boolean liquid = false;
                Device.LiquidType[] liquidTypeArray = Device.LiquidType.values();
                int n = liquidTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Device.LiquidType type = liquidTypeArray[n2];
                    if (type.toString().equals(name)) {
                        liquid = true;
                        switch (type) {
                            case HEAVYOIL: {
                                mat = Material.ORANGE_CONCRETE;
                                break;
                            }
                            case LIGHTOIL: {
                                mat = Material.YELLOW_CONCRETE;
                                break;
                            }
                            case LUBRICANT: {
                                mat = Material.GREEN_CONCRETE;
                                break;
                            }
                            case OIL: {
                                mat = Material.BLACK_CONCRETE;
                                break;
                            }
                            case PETROL: {
                                mat = Material.GRAY_CONCRETE;
                                break;
                            }
                            case STEAM: {
                                mat = Material.WHITE_CONCRETE;
                                break;
                            }
                            case SULFURIC_ACID: {
                                mat = Material.RED_CONCRETE;
                                break;
                            }
                            case WATER: {
                                mat = Material.BLUE_CONCRETE;
                                break;
                            }
                            default: {
                                mat = Material.PURPLE_CONCRETE;
                                break;
                            }
                        }
                        break;
                    }
                    ++n2;
                }
                if (!liquid) {
                    if (name.equals("Pollution")) {
                        mat = Material.BROWN_DYE;
                    } else if (Material.matchMaterial((String)string) != null) {
                        mat = Material.matchMaterial((String)string);
                        name = MineUtil.formatMaterialName(mat);
                    } else {
                        ItemStack comp = MineItems.getIndustrialItem(string);
                        if (comp != null) {
                            mat = comp.getType();
                        }
                    }
                }
                ItemStack stack = TUItems.createItem(mat, MineItems.goldBold() + name, lore);
                this.inv.setItem(slot, stack);
                if (++slot < 45) continue;
                return;
            }
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        this.updateUI();
        player.playSound((Entity)player, Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
    }

    @Override
    public void action() {
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GOLD_INGOT, 1.0);
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.COMPARATOR));
        ings.add(new ItemStack(Material.REDSTONE_BLOCK));
        ings.add(new ItemStack(Material.SMOOTH_STONE, 7));
        RecipeUtils.addDefaultRecipe(new ProductionMonitor(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

