/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Utility;

import com.MT.triggersUtility.RightClickBlockInput;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Powerable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RedstoneEmitter
extends Device {
    private static final long serialVersionUID = -3929409111254171315L;
    private int lastPower = 0;
    private static String classSpacedNamed = "Redstone Emitter";
    private HashSet<String> connectedLocations = new HashSet();
    private transient HashSet<Location> bakedLocations = new HashSet();
    private transient HashSet<Player> showConnections = new HashSet();

    public RedstoneEmitter(Location loc) {
        super(loc);
        this.setMaterial("REDSTONE_LAMP");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(false);
        this.setIdlePower(0);
        this.setActionPower(1);
        this.setUseUI(true);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device is linked to redstone.");
        lore.add("- Powers redstone if the device is powered.");
        lore.add("- Device power depends on distance to connected redstone.");
        lore.add("- Can have multiple connections.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = new ArrayList<String>();
        int connections = 0;
        if (this.bakedLocations != null) {
            connections = this.bakedLocations.size();
        }
        lore.add(MineUtil.colon(" Power Needed", "" + this.lastPower));
        lore.add(MineUtil.colon(" Connections", "" + connections));
        if (this.getFailReason() != null && !this.getFailReason().equals("None")) {
            lore.add(" ");
            lore.add(" " + String.valueOf(ChatColor.RED) + this.getFailReason());
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Power Usage", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        if (connections != 0) {
            lore = TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Clear Connections"));
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.WHITE) + " Connections");
            int count = 0;
            int over = 0;
            for (Location location : this.bakedLocations) {
                lore.add(String.valueOf(ChatColor.GRAY) + "  > " + location.getBlock().getType().toString() + " @ " + TUMaths.locationStringBasic(location));
                if (++count <= 10) continue;
                ++over;
            }
            if (over > 0) {
                lore.add(String.valueOf(ChatColor.GRAY) + " > " + over + " more connections..");
            }
        } else {
            lore = TUItems.basicLore(String.valueOf(ChatColor.GRAY) + " No active connections");
        }
        ItemStack connectionsStack = TUItems.createItem(Material.GRAY_CONCRETE, String.valueOf(MineItems.goldBold()) + "Redstone Connections", lore);
        inv.setItem(11, connectionsStack);
        lore.clear();
        lore = TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Add/Remove redstone connection"));
        lore.add(" ");
        for (String str : MineUtil.wrapText("Can also be used to remove a connection, by selecting a connection that is already established. Active connections show up as yellow concrete! Once this is clicked!", 45)) {
            lore.add(" " + String.valueOf(ChatColor.GRAY) + str);
        }
        ItemStack newConnectionStack = TUItems.createItem(Material.GREEN_CONCRETE, String.valueOf(MineItems.goldBold()) + "Change Redstone Connection", lore);
        inv.setItem(15, newConnectionStack);
        ItemStack itemStack = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13 && i != 11 && i != 15) {
                inv.setItem(i, itemStack);
            }
            ++i;
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.REDSTONE_BLOCK, 1.0);
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            if (this.showConnections == null) {
                this.showConnections = new HashSet();
            }
            if (this.bakedLocations != null && this.connectedLocations.size() != this.bakedLocations.size()) {
                this.loseConnections();
                this.bakedLocations = null;
            }
            if (this.bakedLocations == null) {
                this.bakedLocations = new HashSet();
                for (String strLoc : this.connectedLocations) {
                    this.bakedLocations.add(TUMaths.getStringLocation(strLoc));
                }
            }
            this.showConnections();
            if (this.showConnections.size() > 0) {
                for (Player player : new HashSet<Player>(this.showConnections)) {
                    if (TUMaths.isPlayerNearby(player.getLocation(), MineMain.distantDistance)) continue;
                    this.hideConnections(player);
                }
            }
            if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance)) {
                this.setConsumingPower(false);
                if (this.getGrid().hasPower(this.getPowerNeeded())) {
                    this.getGrid().consumePower(this, this.getPowerNeeded());
                    this.setConsumingPower(true);
                    for (Location loc : this.bakedLocations) {
                        BlockData bd = loc.getBlock().getBlockData();
                        if (bd instanceof Openable) {
                            Openable openable = (Openable)bd;
                            if (!openable.isOpen()) {
                                loc.getWorld().playSound(loc, Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 1.0f);
                            }
                            openable.setOpen(true);
                            loc.getBlock().setBlockData((BlockData)openable);
                            continue;
                        }
                        if (bd instanceof Lightable) {
                            Lightable lightable = (Lightable)bd;
                            lightable.setLit(true);
                            loc.getBlock().setBlockData((BlockData)lightable);
                            continue;
                        }
                        if (bd instanceof Powerable) {
                            Powerable power = (Powerable)bd;
                            power.setPowered(true);
                            loc.getBlock().setBlockData((BlockData)power);
                            continue;
                        }
                        if (!loc.getBlock().getType().equals((Object)Material.REDSTONE_WIRE)) continue;
                        AnaloguePowerable ap = (AnaloguePowerable)bd;
                        ap.setPower(15);
                        loc.getBlock().setBlockData((BlockData)ap);
                    }
                } else {
                    this.setFailReason("Not enough power");
                    this.loseConnections();
                }
            }
        }
    }

    private void showConnections() {
        BlockData tagged = Bukkit.createBlockData((Material)Material.YELLOW_CONCRETE);
        for (Player player : new HashSet<Player>(this.showConnections)) {
            if (player != null && player.isOnline()) {
                for (Location loc : this.bakedLocations) {
                    player.sendBlockChange(loc, tagged);
                }
                continue;
            }
            this.showConnections.remove(player);
        }
    }

    private void hideConnections(Player player) {
        for (Location loc : this.bakedLocations) {
            player.sendBlockChange(loc, loc.getBlock().getBlockData());
        }
        this.showConnections.remove(player);
    }

    private int getPowerNeeded() {
        int power = 0;
        for (Location loc : this.bakedLocations) {
            power += 1 + TUMaths.get2DManhattanDistance(loc, this.getLocation()) / 10;
        }
        this.lastPower = power;
        this.setActionPower(power);
        return power;
    }

    @Override
    public void onDeviceRemove() {
        this.loseConnections();
    }

    private void loseConnections() {
        for (Location loc : this.bakedLocations) {
            this.loseConnection(loc);
        }
    }

    private void loseConnection(Location loc) {
        BlockData bd = loc.getBlock().getBlockData();
        if (bd instanceof Openable) {
            Openable openable = (Openable)bd;
            if (openable.isOpen()) {
                loc.getWorld().playSound(loc, Sound.BLOCK_IRON_DOOR_CLOSE, 1.0f, 1.0f);
            }
            openable.setOpen(false);
            loc.getBlock().setBlockData((BlockData)openable);
        }
        if (bd instanceof Lightable) {
            Lightable light = (Lightable)bd;
            light.setLit(false);
            loc.getBlock().setBlockData((BlockData)light);
        }
        if (bd instanceof Powerable) {
            Powerable powerable = (Powerable)bd;
            powerable.setPowered(false);
            loc.getBlock().setBlockData((BlockData)powerable);
        }
        if (loc.getBlock().getType().equals((Object)Material.REDSTONE_WIRE)) {
            AnaloguePowerable ap = (AnaloguePowerable)bd;
            ap.setPower(0);
            loc.getBlock().setBlockData((BlockData)ap);
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Sound sound = null;
        if (event.getSlot() == 11) {
            sound = Sound.BLOCK_FIRE_EXTINGUISH;
            this.loseConnections();
            this.connectedLocations.clear();
            this.updateUI();
            MineUtil.sendMessage((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("RE_Cleared"));
            this.lastPower = 0;
        }
        if (event.getSlot() == 15) {
            Player player = (Player)event.getWhoClicked();
            if (this.showConnections.contains(player)) {
                player.closeInventory();
                return;
            }
            player.closeInventory();
            this.showConnections.add(player);
            class BlockInput
            extends RightClickBlockInput {
                private final /* synthetic */ Player val$player;

                public BlockInput(String startMessage, Player player) {
                    this.val$player = player;
                    super(startMessage);
                }

                @Override
                public void inputAction(Block block) {
                    String strLoc = TUMaths.locationString(block);
                    if (!RedstoneEmitter.this.connectedLocations.contains(strLoc)) {
                        boolean valid = false;
                        BlockData bd = block.getBlockData();
                        if (bd instanceof Lightable || bd instanceof Powerable || bd instanceof Openable || block.getType().equals((Object)Material.REDSTONE_WIRE)) {
                            valid = true;
                        }
                        if (valid) {
                            RedstoneEmitter.this.connectedLocations.add(strLoc);
                            MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("RE_Added"));
                        } else {
                            MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("RE_Aborted"));
                        }
                    } else {
                        MineUtil.sendWarning(this.val$player, LocaleUtil.messageText("RE_Removed"));
                        RedstoneEmitter.this.loseConnection(block.getLocation());
                    }
                    RedstoneEmitter.this.hideConnections(this.val$player);
                }
            }
            BlockInput input = new BlockInput(String.valueOf(ChatColor.GREEN) + LocaleUtil.messageText("RE_Right_Click"), player);
            input.start(player);
        }
        if (sound != null) {
            ((Player)event.getWhoClicked()).playSound((Entity)((Player)event.getWhoClicked()), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, RedstoneEmitter.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new RedstoneEmitter(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.SMOOTH_STONE, 3));
        ings.add(new ItemStack(Material.QUARTZ, 4));
        ings.add(new ItemStack(Material.REDSTONE_BLOCK, 2));
        RecipeUtils.addDefaultRecipe(new RedstoneEmitter(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

