/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Guide;

import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterface;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.ConfigEditor;
import com.MT.xxxtrigger50xxx.Guide.GuideMenu;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.TablesMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.PlayerData;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import com.MT.xxxtrigger50xxx.Technology.ResearchLab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class MainMenu {
    public static HashMap<UUID, String> lastMenu = new HashMap();

    public static void openGuideMenu(Player player, String menu) {
        if (menu != null && menu.equals("Last") && lastMenu.containsKey(player.getUniqueId())) {
            String target = lastMenu.get(player.getUniqueId());
            if (target.equals("Research")) {
                ResearchLab.openResearchSelect(player, null);
            }
            if (target.equals("Guide")) {
                GuideMenu.openGuideMenu(player, true);
            }
            if (target.equals("Recipes")) {
                RecipeUtils.openRecipeViewer(player, MTRecipe.RecipeType.NONE, "Main Menu", null, false);
            }
            if (target.equals("Items")) {
                ItemMenu.openItemMenu(player);
            }
            if (target.equals("Sharing")) {
                PlayerData.openFactorySharing(player);
            }
            if (!target.equals("Main")) {
                return;
            }
        }
        lastMenu.put(player.getUniqueId(), "Main");
        TUInterface guideInterface = new TUInterface(MineItems.uiTitle() + LocaleUtil.uiText("MM_Title"), 4);
        MainMenu.fillRowWithGoldPanes(guideInterface, 0);
        MainMenu.fillRowWithGoldPanes(guideInterface, 27);
        guideInterface.addComponent(MainMenu.createComponentForSlot(9, MainMenu.createGoldPane()));
        guideInterface.addComponent(MainMenu.createComponentForSlot(18, MainMenu.createGoldPane()));
        guideInterface.addComponent(MainMenu.createResearchComponent());
        guideInterface.addComponent(MainMenu.createHelpComponent());
        guideInterface.addComponent(MainMenu.createItemsComponent());
        guideInterface.addComponent(MainMenu.createRecipeComponent());
        if (MineMain.isFree && player.isOp()) {
            guideInterface.addComponent(MainMenu.createFreeComponent());
        }
        guideInterface.addComponent(MainMenu.createComponentForSlot(17, MainMenu.createGoldPane()));
        guideInterface.addComponent(MainMenu.createComponentForSlot(26, MainMenu.createGoldPane()));
        if (player.isOp()) {
            guideInterface.addComponent(MainMenu.createConfigComponent());
        }
        guideInterface.addComponent(MainMenu.createSharingComp());
        guideInterface.addComponent(MainMenu.infoComp());
        guideInterface.openInterface(player);
    }

    public static ItemStack createGoldPane() {
        ItemStack stack = TUItems.createItem(Material.ORANGE_STAINED_GLASS_PANE, " ");
        ItemMeta meta = stack.getItemMeta();
        CustomModelDataComponent cmdc = meta.getCustomModelDataComponent();
        ArrayList<Float> floats = new ArrayList<Float>();
        floats.add(Float.valueOf(9500.0f));
        cmdc.setFloats(floats);
        meta.setCustomModelDataComponent(cmdc);
        stack.setItemMeta(meta);
        return stack;
    }

    public static ItemStack createWhitePane() {
        ItemStack stack = TUItems.createItem(Material.WHITE_STAINED_GLASS_PANE, " ");
        ItemMeta meta = stack.getItemMeta();
        CustomModelDataComponent cmdc = meta.getCustomModelDataComponent();
        ArrayList<Float> floats = new ArrayList<Float>();
        floats.add(Float.valueOf(9501.0f));
        cmdc.setFloats(floats);
        meta.setCustomModelDataComponent(cmdc);
        stack.setItemMeta(meta);
        return stack;
    }

    public static ItemStack createYellowPane() {
        ItemStack stack = TUItems.createItem(Material.YELLOW_STAINED_GLASS_PANE, " ");
        ItemMeta meta = stack.getItemMeta();
        CustomModelDataComponent cmdc = meta.getCustomModelDataComponent();
        ArrayList<Float> floats = new ArrayList<Float>();
        floats.add(Float.valueOf(9521.0f));
        cmdc.setFloats(floats);
        meta.setCustomModelDataComponent(cmdc);
        stack.setItemMeta(meta);
        return stack;
    }

    public static ItemStack createReturnArrow() {
        return TUItems.setModelData(TUItems.createItem(Material.SPECTRAL_ARROW, ChatColor.GOLD + ChatColor.BOLD + "Return", null), 9511);
    }

    public static void fillRowWithGoldPanes(TUInterface tuInterface, int rowStartSlot) {
        int i = rowStartSlot;
        while (i < rowStartSlot + 9) {
            tuInterface.addComponent(new TUIComponent(i, MainMenu.createGoldPane()));
            ++i;
        }
    }

    private static TUIComponent createComponentForSlot(int slot, ItemStack itemStack) {
        return new TUIComponent(slot, itemStack);
    }

    private static TUIComponent infoComp() {
        ItemStack itemStack = TUItems.createItem(Material.BELL, MineItems.greenBold() + LocaleUtil.uiText("General_Info"));
        ArrayList<String> lore = new ArrayList<String>();
        for (String str : MineUtil.wrapText(LocaleUtil.uiText("MM_Info_Desc"), 45, ChatColor.WHITE, 1)) {
            lore.add(String.valueOf(ChatColor.WHITE) + str);
        }
        TUItems.addLore(itemStack, lore);
        return new TUIComponent(31, TUItems.setModelData(itemStack, 9502)){

            @Override
            public void onLeftClick(Player player) {
                MineUtil.sendMessage(player, "https://minetorio.gitbook.io/minetorio-or-wiki");
            }
        };
    }

    private static TUIComponent createSharingComp() {
        ItemStack itemStack = TUItems.createItem(Material.PLAYER_HEAD, MineItems.buttonTitle() + LocaleUtil.uiText("MM_Button_Sharing"));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), LocaleUtil.uiText("General_Open")));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Command"), LocaleUtil.uiText("MM_Sharing_Command")));
        itemStack = TUItems.setModelData(itemStack, 9560);
        return new TUIComponent(22, itemStack){

            @Override
            public void onLeftClick(Player player) {
                PlayerData.openFactorySharing(player);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
    }

    private static TUIComponent createFreeComponent() {
        ItemStack itemStack = TUItems.createItem(Material.GOLD_BLOCK, MineItems.goldBold() + "Whats Premium?");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineItems.whiteBold() + LocaleUtil.uiText("General_Admin_Visible"));
        lore.add(" ");
        lore.add(MineItems.whiteBold() + "--Whats In Premium?--");
        lore.add(String.valueOf(ChatColor.WHITE) + "- Over 55 more devices and items!");
        lore.add(String.valueOf(ChatColor.WHITE) + "- Over 30+ more config options");
        lore.add(" ");
        lore.add(MineItems.whiteBold() + "--Popular Premium Features--");
        lore.add(String.valueOf(ChatColor.WHITE) + "- Electric Furnaces");
        lore.add(String.valueOf(ChatColor.WHITE) + "- Autominers & Deep Drills");
        lore.add(String.valueOf(ChatColor.WHITE) + "- Teleporters & Elevators");
        lore.add(String.valueOf(ChatColor.WHITE) + "- Item Teleporter / Locomotives");
        lore.add(String.valueOf(ChatColor.WHITE) + "- Research & Technology");
        itemStack = TUMaths.addGlow(itemStack);
        TUItems.addLore(itemStack, lore);
        itemStack = TUItems.setModelData(itemStack, 9510);
        return new TUIComponent(8, itemStack){};
    }

    private static TUIComponent createResearchComponent() {
        ItemStack itemStack = TUItems.createItem(Material.BREWING_STAND, MineItems.buttonTitle() + LocaleUtil.uiText("MM_Button_Research"));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), LocaleUtil.uiText("General_Open")));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Command"), LocaleUtil.uiText("MM_Research_Command")));
        itemStack = TUItems.setModelData(itemStack, 9505);
        return new TUIComponent(20, itemStack){

            @Override
            public void onLeftClick(Player player) {
                ResearchLab.openResearchSelect(player, null);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
    }

    private static TUIComponent createHelpComponent() {
        ItemStack itemStack = TUItems.createItem(Material.KNOWLEDGE_BOOK, MineItems.buttonTitle() + LocaleUtil.uiText("MM_Button_Guide"));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), LocaleUtil.uiText("General_Open")));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Command"), LocaleUtil.uiText("MM_Guide_Command")));
        itemStack = TUItems.setModelData(itemStack, 9506);
        return new TUIComponent(12, itemStack){

            @Override
            public void onLeftClick(Player player) {
                GuideMenu.openGuideMenu(player, false);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
    }

    private static TUIComponent createRecipeComponent() {
        ItemStack itemStack = TUItems.createItem(Material.ENCHANTED_BOOK, MineItems.buttonTitle() + LocaleUtil.uiText("MM_Button_Recipes"));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), LocaleUtil.uiText("General_Open")));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Command"), LocaleUtil.uiText("MM_Recipes_Command")));
        itemStack = TUItems.setModelData(itemStack, 9507);
        return new TUIComponent(14, itemStack){

            @Override
            public void onLeftClick(Player player) {
                RecipeUtils.openRecipeViewer(player, MTRecipe.RecipeType.NONE, "Main Menu", null, false);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
    }

    private static TUIComponent createItemsComponent() {
        ItemStack itemStack = TUItems.createItem(Material.PAPER, MineItems.buttonTitle() + LocaleUtil.uiText("MM_Button_Items"));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), LocaleUtil.uiText("General_Open")));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Command"), LocaleUtil.uiText("MM_Items_Command")));
        itemStack = TUItems.setModelData(itemStack, 9508);
        return new TUIComponent(24, itemStack){

            @Override
            public void onLeftClick(Player player) {
                ItemMenu.openItemMenu(player);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
    }

    private static TUIComponent createConfigComponent() {
        ItemStack itemStack = TUItems.createItem(Material.REDSTONE_BLOCK, MineItems.buttonTitle() + LocaleUtil.uiText("MM_Button_Config"));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), LocaleUtil.uiText("MM_Button_Config_Left")));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), LocaleUtil.uiText("MM_Button_Config_Right")));
        TUItems.addLore(itemStack, MineUtil.colon(" " + LocaleUtil.uiText("General_Command"), LocaleUtil.uiText("MM_Config_Command")));
        TUItems.addLore(itemStack, " ");
        TUItems.addLore(itemStack, MineItems.whiteBold() + " Only visible to admins");
        itemStack = TUItems.setModelData(itemStack, 9509);
        return new TUIComponent(4, itemStack){

            @Override
            public void onLeftClick(Player player) {
                ConfigEditor.openConfigEditor(player);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }

            @Override
            public void onRightClick(Player player) {
                TablesMenu.openTablesMenu(player);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        };
    }
}

