/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx;

import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.MinetorioTables;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ResourceZone
extends Saveable {
    private static final long serialVersionUID = -6912964258331840557L;
    private static HashSet<ResourceZone> zones = new HashSet();
    private String storedLocation = null;
    private String resourceType = null;
    private String stackString = null;
    private int storedResource = 0;
    private int maxResource;
    private int zoneSize = 0;
    private Device.LiquidType storedLiquid;
    private transient Location cached;
    private static NamespacedKey scannedChunk = new NamespacedKey(MineMain.getPlugin(), "MT-SCAN");

    public ResourceZone(Location loc, ItemStack stack) {
        super("Resource Zones", TUMaths.locationString(loc, "UTILITY").replace("/", "=="));
        this.stackString = TUItems.createStackString(stack);
        this.storedLocation = TUMaths.locationString(loc);
        double size = 1.0;
        if (TUMaths.rollRange(0, 99) <= 50) {
            size += 0.25;
        }
        if (TUMaths.rollRange(0, 99) <= 25) {
            size += 0.25;
        }
        if (TUMaths.rollRange(0, 99) <= 10) {
            size += 0.25;
        }
        if (TUMaths.rollRange(0, 99) <= 5) {
            size += 0.25;
        }
        this.zoneSize = (int)((double)TUMaths.rollRange(16, 32) * size);
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (!zones.contains(this)) {
            zones.add(this);
        }
        if (MineMain.deleteRZonEmpty) {
            if (this.storedResource <= 0) {
                zones.remove(this);
                this.setSave(false);
                this.delete();
            }
        } else if (this.storedResource > this.maxResource) {
            this.maxResource = this.storedResource;
        }
    }

    public Location getLocation() {
        if (this.cached == null) {
            this.cached = TUMaths.getStringLocation(this.storedLocation);
        }
        return this.cached;
    }

    public String getResourceType() {
        if (this.storedLiquid != null) {
            return this.storedLiquid.toString();
        }
        ItemStack stack = this.getResourceStack(1);
        if (stack != null) {
            if (stack.getType().equals((Object)Material.AIR)) {
                return "AIR";
            }
            if (stack.getItemMeta().hasDisplayName()) {
                return ChatColor.stripColor((String)stack.getItemMeta().getDisplayName());
            }
            return stack.getType().toString();
        }
        return null;
    }

    public int getStoredResource() {
        return this.storedResource;
    }

    public void setStoredResource(int storedResource) {
        this.storedResource = storedResource;
        this.maxResource = storedResource;
    }

    public boolean inResourceZone(Location loc) {
        if (loc == null || this.getLocation() == null) {
            return false;
        }
        return TUMaths.get2DManhattanDistance(loc, this.getLocation()) <= this.zoneSize;
    }

    public static HashSet<ResourceZone> getAllResourceZones() {
        return new HashSet<ResourceZone>(zones);
    }

    public static boolean isScannedChunk(Chunk chunk) {
        return chunk.getPersistentDataContainer().has(scannedChunk);
    }

    public static ResourceZone scanChunk(Location loc) {
        Chunk chunk = loc.getChunk();
        PersistentDataContainer pdc = chunk.getPersistentDataContainer();
        ResourceZone rz = null;
        if (!pdc.has(scannedChunk)) {
            pdc.set(scannedChunk, PersistentDataType.STRING, (Object)"MT-SCAN");
            rz = MinetorioTables.generateResourceZone(loc);
        }
        return rz;
    }

    public static boolean hasNearResourceZone(Location loc) {
        for (ResourceZone rc : ResourceZone.getAllResourceZones()) {
            if (TUMaths.get2DManhattanDistance(loc, rc.getLocation()) > MineMain.rzSpacing) continue;
            return true;
        }
        return false;
    }

    public static ResourceZone getNearResourceZone(Location loc) {
        for (ResourceZone rc : ResourceZone.getAllResourceZones()) {
            if (!rc.inResourceZone(loc)) continue;
            return rc;
        }
        return null;
    }

    public static ArrayList<ResourceZone> getNearResourceZones(Location loc) {
        ArrayList<ResourceZone> zones = new ArrayList<ResourceZone>();
        for (ResourceZone rc : ResourceZone.getAllResourceZones()) {
            if (!rc.inResourceZone(loc)) continue;
            zones.add(rc);
        }
        return zones;
    }

    public int getZoneSize() {
        return this.zoneSize;
    }

    public void changeZoneSize(int newSize) {
        this.zoneSize = newSize;
    }

    public void regenResource() {
        int amount;
        if (this.storedResource > this.maxResource) {
            this.maxResource = this.storedResource;
        }
        if ((amount = (int)((double)this.maxResource * MineMain.regenZoneAmount)) <= 0) {
            amount = 1;
        }
        this.storedResource += amount;
        if (this.storedResource > this.maxResource) {
            this.storedResource = this.maxResource;
        }
    }

    public void extractResource(int amount) {
        this.storedResource -= amount;
        if (amount <= 0) {
            this.storedResource = 0;
            if (MineMain.deleteRZonEmpty) {
                this.removeResourceZone();
            }
        }
    }

    public void removeResourceZone() {
        zones.remove(this);
        this.setSave(false);
        this.delete();
    }

    public ItemStack getResourceStack(int amount) {
        Material potential;
        if (this.resourceType != null && (potential = Material.matchMaterial((String)this.resourceType)) != null) {
            this.stackString = potential.toString().contains("LIME_DYE") ? TUItems.createStackString(MineItems.getIndustrialItem("Uranium Ore")) : TUItems.createStackString(new ItemStack(potential));
            this.resourceType = null;
        }
        if (this.stackString == null) {
            this.removeResourceZone();
            return new ItemStack(Material.AIR);
        }
        ItemStack stack = TUItems.createStackFromString(this.stackString);
        stack.setAmount(amount);
        return stack;
    }

    public Device.LiquidType getStoredLiquid() {
        return this.storedLiquid;
    }

    public void setStoredLiquid(Device.LiquidType storedLiquid) {
        this.storedLiquid = storedLiquid;
    }
}

