/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import com.MT.triggersUtility.TUMaths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class AStarPathing {
    public static boolean canReach(Location start, Location target, int range) {
        World world = start.getWorld();
        PriorityQueue<PathNode> openList = new PriorityQueue<PathNode>(Comparator.comparingDouble(PathNode::getFCost));
        HashSet<PathNode> closedList = new HashSet<PathNode>();
        PathNode startNode = new PathNode(start, null, 0.0, AStarPathing.getHeuristic(start, target));
        openList.add(startNode);
        while (!openList.isEmpty()) {
            PathNode currentNode = openList.poll();
            closedList.add(currentNode);
            if (currentNode.getLocation().getBlock().getLocation().equals((Object)target.getBlock().getLocation())) {
                return true;
            }
            block1: for (Location neighborLocation : AStarPathing.getNeighbors(currentNode.getLocation(), world)) {
                PathNode neighborNode = new PathNode(neighborLocation, currentNode, currentNode.getGCost() + 1.0, AStarPathing.getHeuristic(neighborLocation, target));
                if (TUMaths.getManhattanDistance(start, neighborLocation) > range || closedList.contains(neighborNode) || !AStarPathing.isPassable(world, neighborLocation)) continue;
                if (!openList.contains(neighborNode)) {
                    openList.add(neighborNode);
                    continue;
                }
                for (PathNode node : openList) {
                    if (!node.equals(neighborNode) || !(node.getGCost() > neighborNode.getGCost())) continue;
                    openList.remove(node);
                    openList.add(neighborNode);
                    continue block1;
                }
            }
        }
        return false;
    }

    private static double getHeuristic(Location from, Location to) {
        return from.distance(to);
    }

    private static List<Location> getNeighbors(Location location, World world) {
        int[][] directions;
        ArrayList<Location> neighbors = new ArrayList<Location>();
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        int[][] nArrayArray2 = directions = nArrayArray;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            int[] direction = nArrayArray2[n2];
            Location neighborLocation = location.clone().add((double)direction[0], (double)direction[1], (double)direction[2]);
            neighbors.add(neighborLocation);
            ++n2;
        }
        return neighbors;
    }

    private static boolean isPassable(World world, Location location) {
        Material material = world.getBlockAt(location).getType();
        return material.isSolid() && world.getBlockAt(location.clone().add(0.0, 1.0, 0.0)).getType().isAir() && world.getBlockAt(location.clone().add(0.0, 2.0, 0.0)).getType().isAir();
    }

    private static class PathNode {
        private Location location;
        private PathNode parent;
        private double gCost;
        private double hCost;
        private double fCost;

        public PathNode(Location location, PathNode parent, double gCost, double hCost) {
            this.location = location;
            this.parent = parent;
            this.gCost = gCost;
            this.hCost = hCost;
            this.fCost = gCost + hCost;
        }

        public Location getLocation() {
            return this.location;
        }

        public PathNode getParent() {
            return this.parent;
        }

        public double getGCost() {
            return this.gCost;
        }

        public double getHCost() {
            return this.hCost;
        }

        public double getFCost() {
            return this.fCost;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PathNode pathNode = (PathNode)obj;
            return this.location.equals((Object)pathNode.location);
        }

        public int hashCode() {
            return this.location.hashCode();
        }
    }
}

