/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.PluginManager;

public class ChatInput
implements Listener {
    private String startMessage;
    private String numberMessage = String.valueOf(ChatColor.RED) + LocaleUtil.messageText("Chat_Input_Numbers_Only");
    private Player player;
    private boolean numbersonly = false;
    private boolean ignorePeriod = false;

    public ChatInput(String startMessage, boolean numbersonly) {
        this.startMessage = startMessage;
        PluginManager pm = MineMain.getPlugin().getServer().getPluginManager();
        pm.registerEvents((Listener)this, MineMain.getPlugin());
        this.numbersonly = numbersonly;
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isNumbersonly() {
        return this.numbersonly;
    }

    public void setNumbersonly(boolean numbersonly) {
        this.numbersonly = numbersonly;
    }

    public void start(final Player player) {
        player.closeInventory();
        if (this.startMessage != null) {
            player.sendMessage(this.startMessage);
        }
        this.setPlayer(player);
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (ChatInput.this.getPlayer() != null) {
                    MineUtil.sendWarning(player, LocaleUtil.messageText("Chat_Input_Timeout"));
                    ChatInput.this.setPlayer(null);
                    return;
                }
            }
        }, 400L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(final AsyncPlayerChatEvent event) {
        if (this.getPlayer() != null && this.getPlayer().equals(event.getPlayer())) {
            event.setCancelled(true);
            final String message2 = event.getMessage();
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    String message = message2;
                    if (!ChatInput.this.isIgnorePeriod()) {
                        message = message.replace(".", "");
                    }
                    if (ChatInput.this.isNumbersonly()) {
                        if (TUMaths.containsOnlyNumber(message)) {
                            ChatInput.this.inputAction(message);
                        } else {
                            event.getPlayer().sendMessage(ChatInput.this.numberMessage);
                        }
                    } else {
                        ChatInput.this.inputAction(message);
                    }
                    ChatInput.this.setPlayer(null);
                }
            }, 1L);
        }
    }

    public String getNumberMessage() {
        return this.numberMessage;
    }

    public void setNumberMessage(String numberMessage) {
        this.numberMessage = numberMessage;
    }

    public void inputAction(String message) {
    }

    public boolean isIgnorePeriod() {
        return this.ignorePeriod;
    }

    public void setIgnorePeriod(boolean ignorePeriod) {
        this.ignorePeriod = ignorePeriod;
    }
}

