/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class RightClickEntityInput
implements Listener {
    private String startMessage;
    private Player player;
    private UUID uuid;
    private EntityType type;
    private static HashMap<UUID, RightClickEntityInput> inputtingPlayers = new HashMap();

    public RightClickEntityInput(Player player, String startMessage, Plugin plugin, EntityType type) {
        if (inputtingPlayers.containsKey(player.getUniqueId())) {
            inputtingPlayers.get(player.getUniqueId()).remove();
        }
        this.startMessage = startMessage;
        this.player = player;
        this.uuid = player.getUniqueId();
        this.type = type;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        inputtingPlayers.put(this.uuid, this);
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    public void start() {
        if (this.player != null) {
            this.player.closeInventory();
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            if (this.startMessage != null) {
                this.player.sendMessage(this.startMessage);
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent event) {
        if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        if (this.player != null) {
            if (this.type == null) {
                if (this.player.equals(event.getPlayer())) {
                    event.setCancelled(true);
                    this.inputAction(event.getRightClicked());
                    this.remove();
                }
            } else if (this.type.equals((Object)event.getRightClicked().getType()) && this.player.equals(event.getPlayer())) {
                event.setCancelled(true);
                this.inputAction(event.getRightClicked());
                this.remove();
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        event.getPlayer().equals(this.player);
    }

    public void inputAction(Entity entity) {
    }

    public void remove() {
        inputtingPlayers.remove(this.uuid);
        this.player = null;
        HandlerList.unregisterAll((Listener)this);
    }

    public static boolean isInputting(Player player) {
        return inputtingPlayers.containsKey(player.getUniqueId());
    }
}

