/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility.TUInterface;

import com.MT.triggersUtility.TUInterface.TUIComponent;
import com.MT.triggersUtility.TUInterface.TUInterface;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TUInterfaceScrolling
extends TUInterface {
    private ArrayList<Integer> scrollingSlots;
    private int page = 0;
    private int pageSize = 0;
    private TUIComponent leftComp;
    private TUIComponent rightComp;
    private TUIComponent leftRightComp;

    public TUInterfaceScrolling(String name, int rows) {
        super(name, rows);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        if (page < 0) {
            page = 0;
        }
        if (this.canScroll(page)) {
            this.page = page;
        }
    }

    public ArrayList<Integer> getScrollingSlots() {
        return this.scrollingSlots;
    }

    public void setScrollingSlots(ArrayList<Integer> scrollingSlots) {
        this.scrollingSlots = scrollingSlots;
        this.pageSize = scrollingSlots.size();
    }

    public ItemStack defineScrolling(int slot) {
        return null;
    }

    public void scrollingActionClick(Player player, ItemStack item, InventoryClickEvent event) {
    }

    public void scrollingMenuClick(Player player, ItemStack item, InventoryClickEvent event) {
    }

    public void updateScrolling() {
        Inventory inv = this.getInv();
        int pageOffset = this.page * this.pageSize;
        Integer i = 0;
        while (i < this.scrollingSlots.size()) {
            ItemStack stack = this.defineScrolling(i + pageOffset);
            if (stack != null) {
                inv.setItem(this.scrollingSlots.get(i).intValue(), stack);
            } else {
                inv.setItem(this.scrollingSlots.get(i).intValue(), new ItemStack(Material.AIR));
            }
            i = i + 1;
        }
        for (TUIComponent comp : this.getComponents()) {
            comp.onUpdate();
        }
    }

    public boolean canScroll(int pageTest) {
        int pageOffset = pageTest * this.pageSize;
        int setItems = 0;
        Integer i = 0;
        while (i < this.scrollingSlots.size()) {
            ItemStack stack = this.defineScrolling(i + pageOffset);
            if (stack != null) {
                ++setItems;
            }
            i = i + 1;
        }
        return setItems > 0;
    }

    public void scrollLeft() {
        this.setPage(this.getPage() - 1);
        this.updateScrolling();
    }

    public void scrollRight() {
        this.setPage(this.getPage() + 1);
        this.updateScrolling();
    }

    public TUIComponent getLeftComp() {
        return this.leftComp;
    }

    public void setLeftComp(TUIComponent leftComp) {
        this.leftComp = leftComp;
    }

    public TUIComponent getRightComp() {
        return this.rightComp;
    }

    public void setRightComp(TUIComponent rightComp) {
        this.rightComp = rightComp;
    }

    public TUIComponent getLeftRightComp() {
        return this.leftRightComp;
    }

    public void setLeftRightComp(TUIComponent leftRightComp) {
        this.leftRightComp = leftRightComp;
    }
}

