/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import com.MT.triggersUtility.Saveable;
import com.MT.triggersUtility.TUItemActions;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class TUItem
extends Saveable
implements Listener {
    private static final long serialVersionUID = -2911293192365072247L;
    public static ArrayList<TUItem> allItems = new ArrayList();
    private String stackString;
    private transient ItemStack stack;
    private String nameID;
    private String[] recipeShape;
    private HashMap<Character, String> shapedIng = new HashMap();
    private String recipeType = null;
    private ArrayList<String> shapelessIngs = new ArrayList();
    private boolean placeable = false;
    private boolean unlockable = false;
    private boolean dropBlock = false;
    private transient TUItemActions actions = null;
    private String placeableType;
    private ArrayList<String> placedLocations = new ArrayList();
    private transient Recipe recipe = null;

    public TUItemActions getActions() {
        return this.actions;
    }

    public void setActions(TUItemActions actions) {
        this.actions = actions;
        for (Location loc : this.getAllPlacedLocation()) {
            actions.startTicker(loc);
        }
    }

    public boolean isDropBlock() {
        return this.dropBlock;
    }

    public void setDropBlock(boolean dropBlock) {
        this.dropBlock = dropBlock;
    }

    public void addPlacedLocation(Location loc) {
        String strLoc = TUMaths.locationString(loc);
        if (!this.placedLocations.contains(strLoc)) {
            this.placedLocations.add(strLoc);
        }
    }

    public void removePlacedLocation(Location loc) {
        String strLoc = TUMaths.locationString(loc);
        if (this.placedLocations.contains(strLoc)) {
            this.placedLocations.remove(strLoc);
        }
    }

    public ArrayList<Location> getAllPlacedLocation() {
        ArrayList<Location> locs = new ArrayList<Location>();
        for (String strLoc : new ArrayList<String>(this.placedLocations)) {
            locs.add(TUMaths.getStringLocation(strLoc));
        }
        return locs;
    }

    public ArrayList<Location> getNearby(Location loc, double distance) {
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Location placed : this.getAllPlacedLocation()) {
            if (!((double)TUMaths.getManhattanDistance(loc, placed) <= distance)) continue;
            locs.add(placed);
        }
        return locs;
    }

    public boolean isPlacedLocation(Location loc) {
        String strLoc = TUMaths.locationString(loc);
        return this.placedLocations.contains(strLoc);
    }

    public String getPlaceableType() {
        return this.placeableType;
    }

    public void setPlaceableType(String placeableType) {
        this.placeableType = placeableType;
    }

    public boolean isUnlockable() {
        return this.unlockable;
    }

    public void setUnlockable(boolean unlockable) {
        this.unlockable = unlockable;
    }

    public boolean isPlaceable() {
        return this.placeable;
    }

    public void setPlaceable(boolean placeable) {
        this.placeable = placeable;
    }

    public TUItem(ItemStack stack, String nameID) {
        super("TUItems", UUID.randomUUID().toString());
        this.stackString = TUItems.createStackString(stack);
        this.stack = TUItems.createStackFromString(this.stackString);
        this.setNameID(nameID);
        allItems.add(this);
    }

    public TUItem() {
        super("TUItems", "Listener");
        this.setNameID("Listener");
    }

    @Override
    public void onCreate(boolean isFirstTime) {
        if (this.getFileName() == null || this.getFileName().equals("Listener")) {
            return;
        }
        this.stack = TUItems.createStackFromString(this.stackString);
        if (!allItems.contains(this)) {
            allItems.add(this);
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                TUItem.this.addRecipe();
            }
        }, 20L);
    }

    private ItemStack getStack() {
        return this.stack;
    }

    public ItemStack getItem(int amount) {
        ItemStack stack = this.getStack().clone();
        stack.setAmount(amount);
        return stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean isItem(ItemStack stack) {
        return TUItems.hasName(stack, this.getStack().getItemMeta().getDisplayName(), true, true);
    }

    public String getNameID() {
        return this.nameID;
    }

    public void setNameID(String nameID) {
        this.nameID = nameID;
    }

    public static TUItem getTUItem(String nameID) {
        for (TUItem titem : new ArrayList<TUItem>(allItems)) {
            if (!titem.getNameID().equals(nameID)) continue;
            return titem;
        }
        return null;
    }

    public static TUItem getTUItem(ItemStack stack) {
        for (TUItem titem : new ArrayList<TUItem>(allItems)) {
            if (!titem.isItem(stack)) continue;
            return titem;
        }
        return null;
    }

    public static ArrayList<TUItem> getAllTUItems() {
        return new ArrayList<TUItem>(allItems);
    }

    public static void addItem(String nameID, ItemStack stack) {
        if (TUItem.getTUItem(nameID) == null) {
            new TUItem(stack, nameID);
        }
    }

    public void setRecipe(ArrayList<ItemStack> ingredients) {
        this.shapelessIngs.clear();
        this.recipeType = "SHAPELESS";
        for (ItemStack ing : ingredients) {
            this.shapelessIngs.add(TUItems.createStackString(ing));
        }
    }

    public void setRecipe(HashMap<Character, ItemStack> ings, String[] shape) {
        this.recipeShape = shape;
        this.recipeType = "SHAPED";
        HashMap<Character, String> newIngs = new HashMap<Character, String>();
        for (Character cha : ings.keySet()) {
            ItemStack ing = ings.get(cha);
            newIngs.put(cha, TUItems.createStackString(ing));
        }
        this.shapedIng = newIngs;
    }

    public void addRecipe() {
        ShapedRecipe sRecipe;
        String nameID;
        if (this.recipeType == null) {
            return;
        }
        if (this.recipeType.equals("SHAPED")) {
            nameID = this.getNameID().replace(" ", "").replace("&", "");
            sRecipe = new ShapedRecipe(new NamespacedKey(plugin, nameID), this.getItem(1));
            sRecipe.shape(this.recipeShape);
            for (Character cha : new ArrayList<Character>(this.shapedIng.keySet())) {
                ItemStack ing = TUItems.createStackFromString(this.shapedIng.get(cha));
                sRecipe.setIngredient(cha.charValue(), (RecipeChoice)new RecipeChoice.ExactChoice(ing));
            }
            Bukkit.getServer().addRecipe((Recipe)sRecipe);
            this.recipe = sRecipe;
        }
        if (this.recipeType.equals("SHAPELESS")) {
            nameID = this.getNameID().replace(" ", "").replace("&", "");
            sRecipe = new ShapelessRecipe(new NamespacedKey(plugin, nameID), this.getItem(1));
            for (String stackString : new ArrayList<String>(this.shapelessIngs)) {
                sRecipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(TUItems.createStackFromString(stackString)));
            }
            Bukkit.getServer().addRecipe((Recipe)sRecipe);
            this.recipe = sRecipe;
        }
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    @EventHandler
    public void onSmelt(FurnaceSmeltEvent event) {
        if (TUItem.getTUItem(event.getSource()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        TUItem item = TUItem.getTUItem(event.getItemInHand());
        if (item != null && !item.isPlaceable()) {
            event.setCancelled(true);
        }
    }
}

