/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class TUMaths {
    private static ArrayList<UUID> frameCooldowns = new ArrayList();
    private static int frameRange = 160;
    private static Material lastMat = null;

    public static double roundDouble(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static int chance(int high) {
        int chanceRoll = (int)Math.ceil(Math.random() * (double)high);
        return chanceRoll;
    }

    public static int rollRange(int lowestNumber, int highestNumber) {
        return new Random().nextInt(highestNumber + 1 - lowestNumber) + lowestNumber;
    }

    public static double rollRange(double lowestNumber, double highestNumber) {
        Random r = new Random();
        return lowestNumber + (highestNumber - lowestNumber) * r.nextDouble();
    }

    public static boolean chanceRoll(int high, int succeed) {
        boolean success = false;
        int chanceRoll = (int)Math.ceil(Math.random() * (double)high);
        success = chanceRoll <= succeed;
        return success;
    }

    public static int choose(int[] args) {
        if (args.length > 0) {
            int chosen = TUMaths.rollRange(0, args.length - 1);
            return args[chosen];
        }
        return 0;
    }

    public static boolean isMultipleOf(int intToCheck, int multipleOf) {
        if (intToCheck != 0) {
            if (multipleOf != 0) {
                if (intToCheck % multipleOf == 0) {
                    return intToCheck != 0;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static boolean containsOnlyNumber(String stringToCheck) {
        return stringToCheck.matches("[0-9]+");
    }

    public static boolean containsOnlyLetters(String stringToCheck) {
        return stringToCheck.matches("[a-zA-Z]+");
    }

    public static int numberDifference(int number1, int number2) {
        int answer = number1 - number2;
        return Math.abs(answer);
    }

    public static String getPlayerDirection(Player player) {
        double rot = (player.getLocation().getYaw() - 90.0f) % 360.0f;
        if (rot < 0.0) {
            rot += 360.0;
        }
        return TUMaths.getDirection(rot);
    }

    public static String getDirection(double rot) {
        if (0.0 <= rot && rot < 22.5) {
            return "North";
        }
        if (22.5 <= rot && rot < 67.5) {
            return "Northeast";
        }
        if (67.5 <= rot && rot < 112.5) {
            return "East";
        }
        if (112.5 <= rot && rot < 157.5) {
            return "Southeast";
        }
        if (157.5 <= rot && rot < 202.5) {
            return "South";
        }
        if (202.5 <= rot && rot < 247.5) {
            return "Southwest";
        }
        if (247.5 <= rot && rot < 292.5) {
            return "West";
        }
        if (292.5 <= rot && rot < 337.5) {
            return "Northwest";
        }
        if (337.5 <= rot && rot < 360.0) {
            return "North";
        }
        return null;
    }

    public static BlockFace getBlockFaceDirection(double rot) {
        if (0.0 <= rot && rot < 22.5) {
            return BlockFace.NORTH;
        }
        if (22.5 <= rot && rot < 67.5) {
            return BlockFace.NORTH_EAST;
        }
        if (67.5 <= rot && rot < 112.5) {
            return BlockFace.EAST;
        }
        if (112.5 <= rot && rot < 157.5) {
            return BlockFace.SOUTH_EAST;
        }
        if (157.5 <= rot && rot < 202.5) {
            return BlockFace.SOUTH;
        }
        if (202.5 <= rot && rot < 247.5) {
            return BlockFace.SOUTH_WEST;
        }
        if (247.5 <= rot && rot < 292.5) {
            return BlockFace.WEST;
        }
        if (292.5 <= rot && rot < 337.5) {
            return BlockFace.NORTH_WEST;
        }
        if (337.5 <= rot && rot < 360.0) {
            return BlockFace.NORTH;
        }
        return null;
    }

    public static BlockFace rotateBlockFace(BlockFace face, int rotate) {
        if (face.equals((Object)BlockFace.NORTH)) {
            if (rotate == 90) {
                return BlockFace.EAST;
            }
            if (rotate == 180) {
                return BlockFace.SOUTH;
            }
            if (rotate == 270) {
                return BlockFace.WEST;
            }
        }
        if (face.equals((Object)BlockFace.EAST)) {
            if (rotate == 90) {
                return BlockFace.SOUTH;
            }
            if (rotate == 180) {
                return BlockFace.WEST;
            }
            if (rotate == 270) {
                return BlockFace.NORTH;
            }
        }
        if (face.equals((Object)BlockFace.SOUTH)) {
            if (rotate == 90) {
                return BlockFace.WEST;
            }
            if (rotate == 180) {
                return BlockFace.NORTH;
            }
            if (rotate == 270) {
                return BlockFace.EAST;
            }
        }
        if (face.equals((Object)BlockFace.WEST)) {
            if (rotate == 90) {
                return BlockFace.NORTH;
            }
            if (rotate == 180) {
                return BlockFace.EAST;
            }
            if (rotate == 270) {
                return BlockFace.SOUTH;
            }
        }
        return face;
    }

    public static void setLore(ItemStack item, List<String> itemLore) {
        if (item != null) {
            ItemMeta meta = item.getItemMeta();
            meta.setLore(itemLore);
            item.setItemMeta(meta);
        }
    }

    public static String locationString(Location location, String defString) {
        if (location == null) {
            return defString;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        float yaw = location.getYaw();
        String world = location.getWorld().getName();
        return String.valueOf(world) + "/" + x + "/" + y + "/" + z + "/" + yaw;
    }

    public static String locationString(Location location) {
        if (location == null) {
            return null;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        float yaw = location.getYaw();
        String world = location.getWorld().getName();
        return world + "/" + x + "/" + y + "/" + z + "/" + yaw;
    }

    public static String locationStringBasic(Location location) {
        if (location == null) {
            return null;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return x + "/" + y + "/" + z;
    }

    public static String locationString(Block block) {
        Location location = block.getLocation();
        if (location == null) {
            return null;
        }
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        float yaw = location.getYaw();
        String world = location.getWorld().getName();
        return world + "/" + x + "/" + y + "/" + z + "/" + yaw;
    }

    public static Location getStringLocation(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("null")) {
            return null;
        }
        String[] parts = string.split("/");
        if (parts.length < 4) {
            return null;
        }
        if (!(TUMaths.containsOnlyNumber(parts[1].replace("-", "")) && TUMaths.containsOnlyNumber(parts[2].replace("-", "")) && TUMaths.containsOnlyNumber(parts[3].replace("-", "")))) {
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            return null;
        }
        int x = Integer.valueOf(parts[1]);
        int y = Integer.valueOf(parts[2]);
        int z = Integer.valueOf(parts[3]);
        Location location = new Location(world, (double)x, (double)y, (double)z);
        Float yaw = Float.valueOf(0.0f);
        if (parts.length == 5) {
            yaw = Float.valueOf(parts[4]);
        }
        location.setYaw(yaw.floatValue());
        return location;
    }

    public static String getWorldNameFromLOCString(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("null")) {
            return null;
        }
        String[] parts = string.split("/");
        if (parts.length < 4) {
            return null;
        }
        if (!(TUMaths.containsOnlyNumber(parts[1].replace("-", "")) && TUMaths.containsOnlyNumber(parts[2].replace("-", "")) && TUMaths.containsOnlyNumber(parts[3].replace("-", "")))) {
            return null;
        }
        return parts[0];
    }

    public static boolean hasItemNameAmount(Player player, String name, int amount, boolean strict) {
        int amountFound = 0;
        PlayerInventory playerInv = player.getInventory();
        int i = 0;
        while (i < playerInv.getSize()) {
            ItemMeta meta;
            ItemStack invItem = playerInv.getItem(i);
            if (invItem != null && invItem.getType() != Material.AIR && invItem.hasItemMeta() && (meta = invItem.getItemMeta()).hasDisplayName() && (strict ? meta.getDisplayName().equals(name) && (amountFound += invItem.getAmount()) >= amount : meta.getDisplayName().contains(name) && (amountFound += invItem.getAmount()) >= amount)) {
                return true;
            }
            ++i;
        }
        return amountFound >= amount;
    }

    public static boolean hasStackAmount(Inventory inventory, ItemStack item, int amount) {
        ItemStack copiedItem = new ItemStack(item.clone());
        copiedItem.setAmount(1);
        int amountFound = 0;
        int i = 0;
        while (i < inventory.getSize()) {
            ItemStack invItem = inventory.getItem(i);
            if (invItem != null && invItem.getType() != Material.AIR) {
                ItemStack copiedInvItem = new ItemStack(invItem.clone());
                copiedInvItem.setAmount(1);
                if (copiedItem.equals((Object)copiedInvItem) && (amountFound += invItem.getAmount()) >= amount) {
                    return true;
                }
            }
            ++i;
        }
        return amountFound >= amount;
    }

    public static boolean removeItemNameAmount(Player player, String name, int amount) {
        int removeAmount = amount;
        PlayerInventory playerInv = player.getInventory();
        int i = 0;
        while (i < playerInv.getSize()) {
            if (removeAmount > 0) {
                ItemStack targetItem = playerInv.getItem(i);
                if (targetItem != null && !targetItem.getType().equals((Object)Material.AIR) && targetItem.hasItemMeta() && targetItem.getItemMeta().hasDisplayName() && targetItem.getItemMeta().getDisplayName().contains(name)) {
                    int targetItemAmount = targetItem.getAmount();
                    int i2 = 0;
                    while (i2 < targetItemAmount) {
                        if (removeAmount > 0) {
                            if (targetItem.getAmount() == 1) {
                                playerInv.setItem(i, new ItemStack(Material.AIR));
                            } else {
                                targetItem.setAmount(targetItem.getAmount() - 1);
                            }
                            --removeAmount;
                        } else {
                            i2 = targetItemAmount;
                        }
                        ++i2;
                    }
                }
            } else {
                i = playerInv.getSize();
            }
            ++i;
        }
        return false;
    }

    public static boolean hasItemAmount(Player player, Material type, int amount) {
        int amountFound = 0;
        PlayerInventory playerInv = player.getInventory();
        int i = 0;
        while (i < playerInv.getSize()) {
            ItemStack invItem = playerInv.getItem(i);
            if (invItem != null && invItem.getType() != Material.AIR && invItem.getType().equals((Object)type)) {
                amountFound += invItem.getAmount();
            }
            ++i;
        }
        return amountFound >= amount;
    }

    public static boolean removeItemAmount(Player player, Material type, int amount) {
        int removeAmount = amount;
        PlayerInventory playerInv = player.getInventory();
        int i = 0;
        while (i < playerInv.getSize()) {
            if (removeAmount > 0) {
                ItemStack targetItem = playerInv.getItem(i);
                if (targetItem != null && !targetItem.getType().equals((Object)Material.AIR) && targetItem.getType().equals((Object)type)) {
                    int targetItemAmount = targetItem.getAmount();
                    int i2 = 0;
                    while (i2 < targetItemAmount) {
                        if (removeAmount > 0) {
                            if (targetItem.getAmount() == 1) {
                                playerInv.setItem(i, new ItemStack(Material.AIR));
                            } else {
                                targetItem.setAmount(targetItem.getAmount() - 1);
                            }
                            --removeAmount;
                        } else {
                            i2 = targetItemAmount;
                        }
                        ++i2;
                    }
                }
            } else {
                i = playerInv.getSize();
            }
            ++i;
        }
        return false;
    }

    public static int inventoryGetStackAmount(Inventory inventory, ItemStack item) {
        int amount = 0;
        int i = 0;
        while (i < inventory.getSize()) {
            if (inventory.getItem(i) != null && !inventory.getItem(i).getType().equals((Object)Material.AIR)) {
                ItemStack comparingItem = new ItemStack(inventory.getItem(i));
                comparingItem.setAmount(1);
                if (comparingItem.equals((Object)item)) {
                    amount += inventory.getItem(i).getAmount();
                }
            }
            ++i;
        }
        return amount;
    }

    public static boolean hasStorageSpace(Inventory inv, ItemStack itemToAdd) {
        int freeSpace = 0;
        int requiredSpace = itemToAdd.getAmount();
        ItemStack[] itemStackArray = inv.getStorageContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (i == null ? (freeSpace += itemToAdd.getType().getMaxStackSize()) >= requiredSpace : i.getType().equals((Object)itemToAdd.getType()) && (freeSpace += i.getType().getMaxStackSize() - i.getAmount()) >= requiredSpace) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasSpace(Inventory inv, ItemStack itemToAdd) {
        int freeSpace = 0;
        int requiredSpace = itemToAdd.getAmount();
        for (ItemStack i : inv) {
            if (!(i == null ? (freeSpace += itemToAdd.getType().getMaxStackSize()) >= requiredSpace : i.getType().equals((Object)itemToAdd.getType()) && (freeSpace += i.getType().getMaxStackSize() - i.getAmount()) >= requiredSpace)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSpace(Inventory inv, ItemStack itemToAdd, int requiredSpace) {
        int freeSpace = 0;
        int i2 = 0;
        while (i2 < inv.getSize()) {
            ItemStack i = inv.getItem(i2);
            if (i == null ? (freeSpace += itemToAdd.getType().getMaxStackSize()) >= requiredSpace : i.getType().equals((Object)itemToAdd.getType()) && (freeSpace += i.getType().getMaxStackSize() - i.getAmount()) >= requiredSpace) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static int getFreeSpace(Inventory inv, ItemStack itemToAdd) {
        int freeSpace = 0;
        int i2 = 0;
        while (i2 < inv.getSize()) {
            if (i2 <= 35) {
                ItemStack i = inv.getItem(i2);
                if (i == null) {
                    freeSpace += itemToAdd.getType().getMaxStackSize();
                } else if (i.getType().equals((Object)itemToAdd.getType())) {
                    freeSpace += i.getType().getMaxStackSize() - i.getAmount();
                }
            }
            ++i2;
        }
        return freeSpace;
    }

    public static boolean hasStackSpace(Inventory inv, ItemStack itemToAdd) {
        int freeSpace = 0;
        int requiredSpace = itemToAdd.getAmount();
        for (ItemStack i : inv) {
            ItemStack copyStack;
            if (!(i != null ? (!i.getType().equals((Object)Material.AIR) ? ((copyStack = i.clone()) == null ? (freeSpace += itemToAdd.getType().getMaxStackSize()) >= requiredSpace : copyStack.equals((Object)itemToAdd) && (freeSpace += copyStack.getType().getMaxStackSize() - copyStack.getAmount()) >= requiredSpace) : (freeSpace += itemToAdd.getType().getMaxStackSize() - itemToAdd.getAmount()) >= requiredSpace) : (freeSpace += itemToAdd.getType().getMaxStackSize() - itemToAdd.getAmount()) >= requiredSpace)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasSpace(Inventory inv, ArrayList<ItemStack> itemsToAdd) {
        void var4_5;
        if (itemsToAdd == null) {
            itemsToAdd = new ArrayList();
        }
        boolean hasSpace = true;
        Inventory dupInventory = Bukkit.createInventory(null, (int)inv.getSize());
        boolean bl = false;
        while (var4_5 < inv.getSize()) {
            dupInventory.setItem((int)var4_5, inv.getItem((int)var4_5));
            ++var4_5;
        }
        for (ItemStack itemStack : itemsToAdd) {
            if (TUMaths.hasSpace(dupInventory, itemStack)) {
                dupInventory.addItem(new ItemStack[]{itemStack});
                continue;
            }
            hasSpace = false;
            break;
        }
        return hasSpace;
    }

    public static void removeStackAmount(Inventory inventory, ItemStack item, int amount) {
        ItemStack removeItem = item.clone();
        removeItem.setAmount(1);
        int i = 0;
        while (i < inventory.getSize()) {
            if (amount <= 0) break;
            if (inventory.getItem(i) != null && !inventory.getItem(i).getType().equals((Object)Material.AIR)) {
                ItemStack comparingItem = inventory.getItem(i).clone();
                comparingItem.setAmount(1);
                if (comparingItem.equals((Object)removeItem)) {
                    int amountInStack = inventory.getItem(i).getAmount();
                    if (amountInStack > amount) {
                        ItemStack newItem = inventory.getItem(i);
                        newItem.setAmount(amountInStack - amount);
                        inventory.setItem(i, newItem);
                        amount = 0;
                    } else {
                        amount -= amountInStack;
                        inventory.setItem(i, new ItemStack(Material.AIR));
                    }
                }
            }
            ++i;
        }
    }

    public static void removeStackAmountAsString(Inventory inventory, ItemStack item, int amount) {
        ItemStack removeItem = item.clone();
        removeItem.setAmount(1);
        int i = 0;
        while (i < inventory.getSize()) {
            if (amount <= 0) break;
            if (inventory.getItem(i) != null && !inventory.getItem(i).getType().equals((Object)Material.AIR)) {
                ItemStack comparingItem = inventory.getItem(i).clone();
                comparingItem.setAmount(1);
                if (comparingItem.toString().equals(removeItem.toString())) {
                    int amountInStack = inventory.getItem(i).getAmount();
                    if (amountInStack > amount) {
                        ItemStack newItem = inventory.getItem(i);
                        newItem.setAmount(amountInStack - amount);
                        inventory.setItem(i, newItem);
                        amount = 0;
                    } else {
                        amount -= amountInStack;
                        inventory.setItem(i, new ItemStack(Material.AIR));
                    }
                }
            }
            ++i;
        }
    }

    public static int getInventoryItemSlot(Player player, Material type, String name, int slotAt) {
        PlayerInventory inv = player.getInventory();
        int slotFoundAt = -1;
        int i = 0;
        while (i < inv.getSize()) {
            ItemStack item = inv.getItem(i);
            if (item != null && !item.getType().equals((Object)Material.AIR) && item.getType().equals((Object)type)) {
                if (name != "None") {
                    if (item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().contains(name)) {
                        if (slotAt == 1) {
                            slotFoundAt = i;
                            break;
                        }
                        --slotAt;
                    }
                } else {
                    if (slotAt == 1) {
                        slotFoundAt = i;
                        break;
                    }
                    --slotAt;
                }
            }
            ++i;
        }
        return slotFoundAt;
    }

    public static ItemStack hideEnchants(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(itemMeta);
        return item;
    }

    public static ItemStack hideAttributes(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(itemMeta);
        return item;
    }

    public static ItemStack hideUnbreakable(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        item.setItemMeta(itemMeta);
        return item;
    }

    public static ItemStack addGlow(ItemStack item) {
        item.addUnsafeEnchantment(Enchantment.KNOCKBACK, 5);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(itemMeta);
        return item;
    }

    public static void inventoryAddItems(Inventory inv, ItemStack item) {
        int addAmount = item.getAmount();
        int i = 0;
        while (i < inv.getSize()) {
            if (addAmount <= 0) break;
            ItemStack invItem = inv.getItem(i);
            if (invItem != null && !invItem.getType().equals((Object)Material.AIR) && invItem.getType().equals((Object)item.getType()) && invItem.getAmount() < invItem.getMaxStackSize()) {
                int spaceLeft = invItem.getMaxStackSize() - invItem.getAmount();
                if (addAmount > spaceLeft) {
                    invItem.setAmount(invItem.getMaxStackSize());
                    addAmount -= spaceLeft;
                } else {
                    invItem.setAmount(invItem.getAmount() + addAmount);
                    addAmount = 0;
                }
            }
            ++i;
        }
        if (addAmount > 0 && inv.firstEmpty() != -1) {
            item.setAmount(addAmount);
            inv.setItem(inv.firstEmpty(), item);
        }
    }

    public static Block getNeighbor(Block block, Material type) {
        if (block.getRelative(BlockFace.NORTH).getType().equals((Object)type)) {
            return block.getRelative(BlockFace.NORTH);
        }
        if (block.getRelative(BlockFace.SOUTH).getType().equals((Object)type)) {
            return block.getRelative(BlockFace.SOUTH);
        }
        if (block.getRelative(BlockFace.EAST).getType().equals((Object)type)) {
            return block.getRelative(BlockFace.EAST);
        }
        if (block.getRelative(BlockFace.WEST).getType().equals((Object)type)) {
            return block.getRelative(BlockFace.WEST);
        }
        return null;
    }

    public static Block getNeighbor(Block block, Material type, int directionInt) {
        if (directionInt == 0 && block.getRelative(BlockFace.NORTH).getType().equals((Object)type)) {
            return block.getRelative(BlockFace.NORTH);
        }
        if (directionInt == 1 && block.getRelative(BlockFace.EAST).getType().equals((Object)type)) {
            return block.getRelative(BlockFace.EAST);
        }
        if (directionInt == 2 && block.getRelative(BlockFace.SOUTH).getType().equals((Object)type)) {
            return block.getRelative(BlockFace.SOUTH);
        }
        if (directionInt == 3 && block.getRelative(BlockFace.WEST).getType().equals((Object)type)) {
            return block.getRelative(BlockFace.WEST);
        }
        return null;
    }

    public static int distanceNoY(Location location1, Location location2) {
        int x1 = location1.getBlockX();
        int x2 = location2.getBlockX();
        int z1 = location1.getBlockZ();
        int z2 = location2.getBlockZ();
        int distance = 0;
        distance += Math.abs(x1 - x2);
        return distance += Math.abs(z1 - z2);
    }

    public static boolean inArea(Location l1, Location l2, Location loc) {
        if (l1 == null || l2 == null) {
            return false;
        }
        if (!l1.getWorld().equals(l2.getWorld())) {
            return false;
        }
        if (l1 != null && l2 != null && loc != null) {
            int x1 = Math.min(l1.getBlockX(), l2.getBlockX());
            int z1 = Math.min(l1.getBlockZ(), l2.getBlockZ());
            int x2 = Math.max(l1.getBlockX(), l2.getBlockX());
            int z2 = Math.max(l1.getBlockZ(), l2.getBlockZ());
            int y1 = Math.min(l1.getBlockY(), l2.getBlockY());
            int y2 = Math.max(l1.getBlockY(), l2.getBlockY());
            return loc.getBlockX() >= x1 && loc.getBlockX() <= x2 && loc.getBlockZ() >= z1 && loc.getBlockZ() <= z2 && loc.getBlockY() >= y1 && loc.getBlockY() <= y2;
        }
        return false;
    }

    public static Location getCenteredLocation(Location l1, Location l2) {
        int x1 = Math.min(l1.getBlockX(), l2.getBlockX());
        int z1 = Math.min(l1.getBlockZ(), l2.getBlockZ());
        int x2 = Math.max(l1.getBlockX(), l2.getBlockX());
        int z2 = Math.max(l1.getBlockZ(), l2.getBlockZ());
        int y1 = Math.min(l1.getBlockY(), l2.getBlockY());
        int y2 = Math.max(l1.getBlockY(), l2.getBlockY());
        int x3 = x2 - TUMaths.numberDifference(x2, x1) / 2;
        int y3 = y2 - TUMaths.numberDifference(y2, y1) / 2;
        int z3 = z2 - TUMaths.numberDifference(z2, z1) / 2;
        return new Location(l1.getWorld(), (double)x3, (double)y3, (double)z3);
    }

    public static Location centerLocation(Location location, Double verticalAmount) {
        Location returnLocation = location.clone();
        returnLocation.setX(returnLocation.getX() + 0.5);
        returnLocation.setZ(returnLocation.getZ() + 0.5);
        if (verticalAmount > 0.0) {
            returnLocation.setY(returnLocation.getY() + verticalAmount);
        }
        return returnLocation;
    }

    public static boolean hasName(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName();
    }

    public static boolean hasName(ItemStack item, String name) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().contains(name);
    }

    public static Firework spawnFireWork(Location location, int power, Color color, FireworkEffect.Type type) {
        Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
        FireworkMeta data = firework.getFireworkMeta();
        data.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(color).with(type).build()});
        data.setPower(power);
        firework.setFireworkMeta(data);
        return firework;
    }

    public static Firework spawnRandomFireWork(Location location, int power, FireworkEffect.Type type) {
        Color color = Color.GREEN;
        Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
        FireworkMeta data = firework.getFireworkMeta();
        int seedNumber = TUMaths.rollRange(0, 5) + TUMaths.rollRange(0, 5);
        if (seedNumber == 0) {
            color = Color.GREEN;
        }
        if (seedNumber == 1) {
            color = Color.AQUA;
        }
        if (seedNumber == 2) {
            color = Color.BLUE;
        }
        if (seedNumber == 3) {
            color = Color.MAROON;
        }
        if (seedNumber == 4) {
            color = Color.LIME;
        }
        if (seedNumber == 5) {
            color = Color.ORANGE;
        }
        if (seedNumber == 6) {
            color = Color.PURPLE;
        }
        if (seedNumber == 7) {
            color = Color.RED;
        }
        if (seedNumber == 8) {
            color = Color.TEAL;
        }
        if (seedNumber == 9) {
            color = Color.YELLOW;
        }
        if (type == null) {
            if (seedNumber >= 0 && seedNumber <= 2) {
                type = FireworkEffect.Type.BALL;
            }
            if (seedNumber >= 3 && seedNumber <= 4) {
                type = FireworkEffect.Type.BALL_LARGE;
            }
            if (seedNumber >= 5 && seedNumber <= 6) {
                type = FireworkEffect.Type.BURST;
            }
            if (seedNumber >= 7 && seedNumber <= 8) {
                type = FireworkEffect.Type.CREEPER;
            }
            if (seedNumber >= 9 && seedNumber <= 10) {
                type = FireworkEffect.Type.STAR;
            }
        }
        data.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(color).with(type).build()});
        data.setPower(power);
        firework.setFireworkMeta(data);
        return firework;
    }

    public static float getAngleDifference(Location targetLocation, Location sourceLocation) {
        float angle = (float)Math.toDegrees(Math.atan2(targetLocation.getZ() - sourceLocation.getZ(), targetLocation.getX() - sourceLocation.getX()));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static boolean isDoor(Material material) {
        if (material.equals((Object)Material.IRON_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.BIRCH_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.BIRCH_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.ACACIA_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.ACACIA_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.DARK_OAK_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.DARK_OAK_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.JUNGLE_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.JUNGLE_DOOR)) {
            return true;
        }
        if (material.equals((Object)Material.SPRUCE_DOOR)) {
            return true;
        }
        return material.equals((Object)Material.SPRUCE_DOOR);
    }

    @Deprecated
    public static Entity getEntityByUniqueId(UUID uuid, boolean isLiving) {
        for (World world : Bukkit.getWorlds()) {
            if (!isLiving) {
                for (Entity entity : world.getEntities()) {
                    if (!entity.getUniqueId().equals(uuid)) continue;
                    return entity;
                }
                continue;
            }
            for (Entity entity : world.getLivingEntities()) {
                if (!entity.getUniqueId().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }

    public static ArrayList<Block> getNearbyBlocks(Block source, Material checkMaterial, int radius) {
        if (radius <= 0) {
            radius = 1;
        }
        if (radius > 2) {
            radius = 2;
        }
        ArrayList<Block> nearbyBlocks = new ArrayList<Block>();
        if (source.getRelative(BlockFace.NORTH).getType().equals((Object)checkMaterial)) {
            nearbyBlocks.add(source.getRelative(BlockFace.NORTH));
        }
        if (source.getRelative(BlockFace.SOUTH).getType().equals((Object)checkMaterial)) {
            nearbyBlocks.add(source.getRelative(BlockFace.SOUTH));
        }
        if (source.getRelative(BlockFace.EAST).getType().equals((Object)checkMaterial)) {
            nearbyBlocks.add(source.getRelative(BlockFace.EAST));
        }
        if (source.getRelative(BlockFace.WEST).getType().equals((Object)checkMaterial)) {
            nearbyBlocks.add(source.getRelative(BlockFace.WEST));
        }
        if (source.getRelative(BlockFace.NORTH_EAST).getType().equals((Object)checkMaterial)) {
            nearbyBlocks.add(source.getRelative(BlockFace.NORTH_EAST));
        }
        if (source.getRelative(BlockFace.NORTH_WEST).getType().equals((Object)checkMaterial)) {
            nearbyBlocks.add(source.getRelative(BlockFace.NORTH_WEST));
        }
        if (source.getRelative(BlockFace.SOUTH_EAST).getType().equals((Object)checkMaterial)) {
            nearbyBlocks.add(source.getRelative(BlockFace.SOUTH_EAST));
        }
        if (source.getRelative(BlockFace.SOUTH_WEST).getType().equals((Object)checkMaterial)) {
            nearbyBlocks.add(source.getRelative(BlockFace.SOUTH_WEST));
        }
        if (radius == 2) {
            Block west2Block;
            Block east2Block;
            Block south2Block;
            Block north2Block = source.getRelative(BlockFace.NORTH).getRelative(BlockFace.NORTH);
            if (north2Block.getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(north2Block);
            }
            if (north2Block.getRelative(BlockFace.EAST).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(north2Block.getRelative(BlockFace.EAST));
            }
            if (north2Block.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(north2Block.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST));
            }
            if (north2Block.getRelative(BlockFace.WEST).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(north2Block.getRelative(BlockFace.WEST));
            }
            if (north2Block.getRelative(BlockFace.WEST).getRelative(BlockFace.WEST).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(north2Block.getRelative(BlockFace.WEST).getRelative(BlockFace.WEST));
            }
            if ((south2Block = source.getRelative(BlockFace.SOUTH).getRelative(BlockFace.SOUTH)).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(south2Block);
            }
            if (south2Block.getRelative(BlockFace.EAST).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(south2Block.getRelative(BlockFace.EAST));
            }
            if (south2Block.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(south2Block.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST));
            }
            if (south2Block.getRelative(BlockFace.WEST).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(south2Block.getRelative(BlockFace.WEST));
            }
            if (south2Block.getRelative(BlockFace.WEST).getRelative(BlockFace.WEST).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(south2Block.getRelative(BlockFace.WEST).getRelative(BlockFace.WEST));
            }
            if ((east2Block = source.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST)).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(east2Block);
            }
            if (east2Block.getRelative(BlockFace.NORTH).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(east2Block.getRelative(BlockFace.NORTH));
            }
            if (east2Block.getRelative(BlockFace.SOUTH).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(east2Block.getRelative(BlockFace.SOUTH));
            }
            if ((west2Block = source.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST)).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(west2Block);
            }
            if (west2Block.getRelative(BlockFace.NORTH).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(west2Block.getRelative(BlockFace.NORTH));
            }
            if (west2Block.getRelative(BlockFace.SOUTH).getType().equals((Object)checkMaterial)) {
                nearbyBlocks.add(west2Block.getRelative(BlockFace.SOUTH));
            }
        }
        return nearbyBlocks;
    }

    public static ArrayList<Block> getNearbyBlocks(Block source, int radius) {
        if (radius <= 0) {
            radius = 1;
        }
        if (radius > 2) {
            radius = 2;
        }
        ArrayList<Block> nearbyBlocks = new ArrayList<Block>();
        nearbyBlocks.add(source.getRelative(BlockFace.NORTH));
        nearbyBlocks.add(source.getRelative(BlockFace.SOUTH));
        nearbyBlocks.add(source.getRelative(BlockFace.EAST));
        nearbyBlocks.add(source.getRelative(BlockFace.WEST));
        nearbyBlocks.add(source.getRelative(BlockFace.NORTH_EAST));
        nearbyBlocks.add(source.getRelative(BlockFace.NORTH_WEST));
        nearbyBlocks.add(source.getRelative(BlockFace.SOUTH_EAST));
        nearbyBlocks.add(source.getRelative(BlockFace.SOUTH_WEST));
        if (radius == 2) {
            Block north2Block = source.getRelative(BlockFace.NORTH).getRelative(BlockFace.NORTH);
            nearbyBlocks.add(north2Block);
            nearbyBlocks.add(north2Block.getRelative(BlockFace.EAST));
            nearbyBlocks.add(north2Block.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST));
            nearbyBlocks.add(north2Block.getRelative(BlockFace.WEST));
            nearbyBlocks.add(north2Block.getRelative(BlockFace.WEST).getRelative(BlockFace.WEST));
            Block south2Block = source.getRelative(BlockFace.SOUTH).getRelative(BlockFace.SOUTH);
            nearbyBlocks.add(south2Block);
            nearbyBlocks.add(south2Block.getRelative(BlockFace.EAST));
            nearbyBlocks.add(south2Block.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST));
            nearbyBlocks.add(south2Block.getRelative(BlockFace.WEST));
            nearbyBlocks.add(south2Block.getRelative(BlockFace.WEST).getRelative(BlockFace.WEST));
            Block east2Block = source.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST);
            nearbyBlocks.add(east2Block);
            nearbyBlocks.add(east2Block.getRelative(BlockFace.NORTH));
            nearbyBlocks.add(east2Block.getRelative(BlockFace.SOUTH));
            Block west2Block = source.getRelative(BlockFace.EAST).getRelative(BlockFace.EAST);
            nearbyBlocks.add(west2Block);
            nearbyBlocks.add(west2Block.getRelative(BlockFace.NORTH));
            nearbyBlocks.add(west2Block.getRelative(BlockFace.SOUTH));
        }
        return nearbyBlocks;
    }

    public static ArrayList<Block> getNearbyBlocksCardinal(Block source) {
        ArrayList<Block> nearbyBlocks = new ArrayList<Block>();
        nearbyBlocks.add(source.getRelative(BlockFace.NORTH));
        nearbyBlocks.add(source.getRelative(BlockFace.SOUTH));
        nearbyBlocks.add(source.getRelative(BlockFace.EAST));
        nearbyBlocks.add(source.getRelative(BlockFace.WEST));
        return nearbyBlocks;
    }

    public static ArrayList<Block> getNearbyBlocks6Sided(Block source) {
        ArrayList<Block> nearbyBlocks = new ArrayList<Block>();
        nearbyBlocks.add(source.getRelative(BlockFace.NORTH));
        nearbyBlocks.add(source.getRelative(BlockFace.SOUTH));
        nearbyBlocks.add(source.getRelative(BlockFace.EAST));
        nearbyBlocks.add(source.getRelative(BlockFace.WEST));
        nearbyBlocks.add(source.getRelative(BlockFace.UP));
        nearbyBlocks.add(source.getRelative(BlockFace.DOWN));
        return nearbyBlocks;
    }

    public static double get360Direction(Entity entity, int offset) {
        double rot = (entity.getLocation().getYaw() + (float)offset) % 360.0f;
        if (rot < 0.0) {
            rot += 360.0;
        }
        return TUMaths.roundDouble(rot, 2);
    }

    public static BlockFace get360FaceDirection(Entity entity, int offset) {
        double rot = TUMaths.get360Direction(entity, offset);
        if (rot >= 0.0 && rot < 90.0) {
            return BlockFace.WEST;
        }
        if (rot >= 90.0 && rot < 180.0) {
            return BlockFace.NORTH;
        }
        if (rot >= 180.0 && rot < 270.0) {
            return BlockFace.EAST;
        }
        if (rot >= 270.0 && rot < 360.0) {
            return BlockFace.SOUTH;
        }
        return null;
    }

    public static BlockFace getOppostieFace(BlockFace face) {
        if (face.equals((Object)BlockFace.NORTH)) {
            return BlockFace.SOUTH;
        }
        if (face.equals((Object)BlockFace.SOUTH)) {
            return BlockFace.NORTH;
        }
        if (face.equals((Object)BlockFace.EAST)) {
            return BlockFace.WEST;
        }
        if (face.equals((Object)BlockFace.WEST)) {
            return BlockFace.EAST;
        }
        if (face.equals((Object)BlockFace.NORTH_EAST)) {
            return BlockFace.SOUTH_WEST;
        }
        if (face.equals((Object)BlockFace.SOUTH_WEST)) {
            return BlockFace.NORTH_EAST;
        }
        if (face.equals((Object)BlockFace.SOUTH_EAST)) {
            return BlockFace.NORTH_WEST;
        }
        if (face.equals((Object)BlockFace.NORTH_WEST)) {
            return BlockFace.SOUTH_EAST;
        }
        if (face.equals((Object)BlockFace.UP)) {
            return BlockFace.DOWN;
        }
        if (face.equals((Object)BlockFace.DOWN)) {
            return BlockFace.UP;
        }
        return null;
    }

    public static String highLightText(String string, String highLightWord, ChatColor highLightColor) {
        String normalColor = ChatColor.getLastColors((String)string);
        return string.replace(highLightWord, String.valueOf(highLightColor) + highLightWord + normalColor);
    }

    public static int getfreeSlotCount(Inventory inv) {
        int amountFree = 0;
        int i = 0;
        while (i < inv.getSize()) {
            if (inv.getItem(i) == null) {
                ++amountFree;
            }
            ++i;
        }
        return amountFree;
    }

    public static ArrayList<Integer> getfreeSlots(Inventory inv) {
        ArrayList<Integer> freeSlots = new ArrayList<Integer>();
        int i = 0;
        while (i < inv.getSize()) {
            if (inv.getItem(i) == null) {
                freeSlots.add(i);
            }
            ++i;
        }
        return freeSlots;
    }

    public static int dayDifference(Date newestDate, Date oldestDate) {
        return (int)((newestDate.getTime() - oldestDate.getTime()) / 86400000L);
    }

    public static Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static boolean toBool(String string) {
        return string.equals("true");
    }

    public static boolean isDay(World world) {
        long time = world.getTime();
        return time < 12300L || time > 23850L;
    }

    public static boolean isFullMoon(World world) {
        int days = (int)(world.getFullTime() / 24000L);
        int phase = days % 8;
        return phase == 0;
    }

    public static Location getRandomLocationFromArea(Location l1, Location l2, int shift) {
        if (l1 != null && l2 != null) {
            int x1 = Math.min(l1.getBlockX(), l2.getBlockX()) + shift;
            int z1 = Math.min(l1.getBlockZ(), l2.getBlockZ()) + shift;
            int x2 = Math.max(l1.getBlockX(), l2.getBlockX()) - shift;
            int z2 = Math.max(l1.getBlockZ(), l2.getBlockZ()) - shift;
            int y1 = Math.min(l1.getBlockY(), l2.getBlockY());
            int y2 = Math.max(l1.getBlockY(), l2.getBlockY());
            return new Location(l1.getWorld(), (double)TUMaths.rollRange(x1, x2), (double)TUMaths.rollRange(y1, y2), (double)TUMaths.rollRange(z1, z2));
        }
        return null;
    }

    public static boolean canSee(LivingEntity looker, LivingEntity target, double angle) {
        if (looker.hasLineOfSight((Entity)target)) {
            Location eye = looker.getLocation();
            Vector toEntity = target.getLocation().toVector().subtract(eye.toVector());
            double dot = toEntity.normalize().dot(eye.getDirection());
            return dot > angle;
        }
        return false;
    }

    public static boolean canSee(LivingEntity looker, Location target, double angle) {
        Location eye = looker.getLocation();
        Vector toEntity = target.toVector().subtract(eye.toVector());
        double dot = toEntity.normalize().dot(eye.getDirection());
        return dot > angle;
    }

    public static boolean canSee(Location eye, Location target, double angle) {
        Vector toEntity = target.toVector().subtract(eye.toVector());
        double dot = toEntity.normalize().dot(eye.getDirection());
        return dot > angle;
    }

    public static double generateAreaChunks(final Location l1, Location l2) {
        if (l1 == null || l2 == null) {
            return -1.0;
        }
        int xmin = Math.min(l1.getBlockX(), l2.getBlockX());
        int zmin = Math.min(l1.getBlockZ(), l2.getBlockZ());
        int xmax = Math.max(l1.getBlockX(), l2.getBlockX());
        int zmax = Math.max(l1.getBlockZ(), l2.getBlockZ());
        int chunks = 0;
        int x = xmin - 16;
        while (x <= xmax + 16) {
            int z = zmin - 16;
            while (z <= zmax + 16) {
                final int chunkX = x >> 4;
                final int chunkZ = z >> 4;
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        l1.getWorld().getChunkAt(chunkX, chunkZ, true);
                    }
                }, 1L + (long)(++chunks));
                z += 16;
            }
            x += 16;
        }
        double seconds = 1 * chunks / 20;
        TUMaths.dm(String.valueOf(ChatColor.GOLD) + "Generating " + chunks + " chunks over " + TUMaths.roundDouble(seconds / 60.0, 2) + " minutes");
        return seconds;
    }

    public static ArrayList<Chunk> getAreaChunks(Location l1, Location l2) {
        if (l1 == null || l2 == null) {
            return new ArrayList<Chunk>();
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int xmin = Math.min(l1.getBlockX(), l2.getBlockX());
        int zmin = Math.min(l1.getBlockZ(), l2.getBlockZ());
        int xmax = Math.max(l1.getBlockX(), l2.getBlockX());
        int zmax = Math.max(l1.getBlockZ(), l2.getBlockZ());
        int x = xmin - 16;
        while (x <= xmax + 16) {
            int z = zmin - 16;
            while (z <= zmax + 16) {
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                Chunk chunk = l1.getWorld().getChunkAt(chunkX, chunkZ, true);
                chunks.add(chunk);
                z += 16;
            }
            x += 16;
        }
        return chunks;
    }

    public static int getArea(Location l1, Location l2) {
        int xmin = Math.min(l1.getBlockX(), l2.getBlockX());
        int zmin = Math.min(l1.getBlockZ(), l2.getBlockZ());
        int xmax = Math.max(l1.getBlockX(), l2.getBlockX());
        int zmax = Math.max(l1.getBlockZ(), l2.getBlockZ());
        int ymin = Math.min(l1.getBlockY(), l2.getBlockY());
        int ymax = Math.max(l1.getBlockY(), l2.getBlockY());
        int length = xmax - xmin;
        int width = zmax - zmin;
        int height = ymax - ymin;
        return length * width * height;
    }

    public static boolean onlyTransparentAbove(Location location) {
        Location clone = location.clone();
        clone.setY(clone.getY() + 1.0);
        int y = location.getWorld().getHighestBlockYAt(location);
        while (y > location.getBlock().getY()) {
            clone.setY(clone.getY() - 1.0);
            Material mat = clone.getBlock().getType();
            if (!mat.equals((Object)Material.AIR) && !mat.toString().contains("GLASS")) {
                return false;
            }
            --y;
        }
        return true;
    }

    public static void dm(String message) {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + message);
    }

    public static void dm(String message, ChatColor color) {
        if (color == null) {
            TUMaths.dm(message);
            return;
        }
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        sender.sendMessage(String.valueOf(color) + message);
    }

    public static String getClockHour(World world) {
        float time = world.getTime();
        if (time >= 0.0f && time < 1000.0f) {
            return "6AM";
        }
        if (time >= 1000.0f && time < 2000.0f) {
            return "7AM";
        }
        if (time >= 2000.0f && time < 3000.0f) {
            return "8AM";
        }
        if (time >= 3000.0f && time < 4000.0f) {
            return "9AM";
        }
        if (time >= 4000.0f && time < 5000.0f) {
            return "10AM";
        }
        if (time >= 5000.0f && time < 6000.0f) {
            return "11AM";
        }
        if (time >= 6000.0f && time < 7000.0f) {
            return "12PM";
        }
        if (time >= 7000.0f && time < 8000.0f) {
            return "1PM";
        }
        if (time >= 8000.0f && time < 9000.0f) {
            return "2PM";
        }
        if (time >= 9000.0f && time < 10000.0f) {
            return "3PM";
        }
        if (time >= 10000.0f && time < 11000.0f) {
            return "4PM";
        }
        if (time >= 11000.0f && time < 12000.0f) {
            return "5PM";
        }
        if (time >= 12000.0f && time < 13000.0f) {
            return "6PM";
        }
        if (time >= 13000.0f && time < 14000.0f) {
            return "7PM";
        }
        if (time >= 14000.0f && time < 15000.0f) {
            return "8PM";
        }
        if (time >= 15000.0f && time < 16000.0f) {
            return "9PM";
        }
        if (time >= 16000.0f && time < 17000.0f) {
            return "10PM";
        }
        if (time >= 17000.0f && time < 18000.0f) {
            return "11PM";
        }
        if (time >= 18000.0f && time < 19000.0f) {
            return "12AM";
        }
        if (time >= 19000.0f && time < 20000.0f) {
            return "1AM";
        }
        if (time >= 20000.0f && time < 21000.0f) {
            return "2AM";
        }
        if (time >= 21000.0f && time < 22000.0f) {
            return "3AM";
        }
        if (time >= 22000.0f && time < 23000.0f) {
            return "4AM";
        }
        if (time >= 23000.0f && time < 24000.0f) {
            return "5AM";
        }
        return "6AM";
    }

    public static int getClockHourMilitary(World world) {
        float time = world.getTime();
        if (time >= 0.0f && time < 1000.0f) {
            return 6;
        }
        if (time >= 1000.0f && time < 2000.0f) {
            return 7;
        }
        if (time >= 2000.0f && time < 3000.0f) {
            return 8;
        }
        if (time >= 3000.0f && time < 4000.0f) {
            return 9;
        }
        if (time >= 4000.0f && time < 5000.0f) {
            return 10;
        }
        if (time >= 5000.0f && time < 6000.0f) {
            return 11;
        }
        if (time >= 6000.0f && time < 7000.0f) {
            return 12;
        }
        if (time >= 7000.0f && time < 8000.0f) {
            return 13;
        }
        if (time >= 8000.0f && time < 9000.0f) {
            return 14;
        }
        if (time >= 9000.0f && time < 10000.0f) {
            return 15;
        }
        if (time >= 10000.0f && time < 11000.0f) {
            return 16;
        }
        if (time >= 11000.0f && time < 12000.0f) {
            return 17;
        }
        if (time >= 12000.0f && time < 13000.0f) {
            return 18;
        }
        if (time >= 13000.0f && time < 14000.0f) {
            return 19;
        }
        if (time >= 14000.0f && time < 15000.0f) {
            return 20;
        }
        if (time >= 15000.0f && time < 16000.0f) {
            return 21;
        }
        if (time >= 16000.0f && time < 17000.0f) {
            return 22;
        }
        if (time >= 17000.0f && time < 18000.0f) {
            return 23;
        }
        if (time >= 18000.0f && time < 19000.0f) {
            return 0;
        }
        if (time >= 19000.0f && time < 20000.0f) {
            return 1;
        }
        if (time >= 20000.0f && time < 21000.0f) {
            return 2;
        }
        if (time >= 21000.0f && time < 22000.0f) {
            return 3;
        }
        if (time >= 22000.0f && time < 23000.0f) {
            return 4;
        }
        if (time >= 23000.0f && time < 24000.0f) {
            return 5;
        }
        return 0;
    }

    public static boolean isLocationNearby(Location targetLoc, Location loc, double range) {
        if (targetLoc != null && loc != null && targetLoc.getWorld().equals(loc.getWorld())) {
            return targetLoc.distanceSquared(loc) <= range;
        }
        return false;
    }

    public static boolean isPlayerNearby(Location targetLoc, double range) {
        World world = targetLoc.getWorld();
        if (world != null) {
            for (Player player : world.getPlayers()) {
                if (!player.getWorld().equals(targetLoc.getWorld()) || !((double)TUMaths.getManhattanDistance(player.getLocation(), targetLoc) <= range)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerNearby2D(Location targetLoc, double range) {
        for (Player player : targetLoc.getWorld().getPlayers()) {
            if (!player.getWorld().equals(targetLoc.getWorld()) || !((double)TUMaths.get2DManhattanDistance(player.getLocation(), targetLoc) <= range)) continue;
            return true;
        }
        return false;
    }

    public static int getManhattanDistance(Location loc1, Location loc2) {
        if (!loc1.getWorld().equals(loc2.getWorld())) {
            return 999999999;
        }
        int distance = 0;
        distance = (int)((double)distance + (Math.max(loc1.getX(), loc2.getX()) - Math.min(loc1.getX(), loc2.getX())));
        distance = (int)((double)distance + (Math.max(loc1.getY(), loc2.getY()) - Math.min(loc1.getY(), loc2.getY())));
        distance = (int)((double)distance + (Math.max(loc1.getZ(), loc2.getZ()) - Math.min(loc1.getZ(), loc2.getZ())));
        return distance;
    }

    public static int get2DManhattanDistance(Location loc1, Location loc2) {
        int distance = 0;
        distance = (int)((double)distance + (Math.max(loc1.getX(), loc2.getX()) - Math.min(loc1.getX(), loc2.getX())));
        distance = (int)((double)distance + (Math.max(loc1.getZ(), loc2.getZ()) - Math.min(loc1.getZ(), loc2.getZ())));
        return distance;
    }

    public static ArrayList<Location> getCircle(Location center, double radius, int amount) {
        World world = center.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < amount) {
            double angle = (double)i * increment;
            double x = center.getX() + radius * Math.cos(angle);
            double z = center.getZ() + radius * Math.sin(angle);
            locations.add(new Location(world, x, center.getY(), z));
            ++i;
        }
        return locations;
    }

    public static int clamp(int x, int min, int max) {
        if (x < min) {
            x = min;
        }
        if (x > max) {
            x = max;
        }
        return x;
    }

    public static Location getRandomLocationAroundPlayer(Player player, double range) {
        Location playerLocation = player.getLocation();
        Random random = new Random();
        double xOffset = random.nextDouble() * range * 2.0 - range;
        double zOffset = random.nextDouble() * range * 2.0 - range;
        double newX = playerLocation.getX() + xOffset;
        double newZ = playerLocation.getZ() + zOffset;
        double newY = playerLocation.getY();
        return new Location(playerLocation.getWorld(), newX, newY, newZ);
    }

    public static Location getRandomLocationAroundLocation(Location loc, double range) {
        Random random = new Random();
        double xOffset = random.nextDouble() * range * 2.0 - range;
        double zOffset = random.nextDouble() * range * 2.0 - range;
        double newX = loc.getX() + xOffset;
        double newZ = loc.getZ() + zOffset;
        double newY = loc.getY();
        return new Location(loc.getWorld(), newX, newY, newZ);
    }

    public static ArrayList<Location> getEdgeLocations(Location corner1, Location corner2, int spacing, boolean includeColumns) {
        double z;
        ArrayList<Location> edgeLocations = new ArrayList<Location>();
        if (!corner1.getWorld().equals(corner2.getWorld())) {
            return edgeLocations;
        }
        double x1 = corner1.getX();
        double y1 = corner1.getY();
        double z1 = corner1.getZ();
        double x2 = corner2.getX();
        double y2 = corner2.getY();
        double z2 = corner2.getZ();
        double minX = Math.min(x1, x2);
        double minY = Math.min(y1, y2);
        double minZ = Math.min(z1, z2);
        double maxX = Math.max(x1, x2);
        double maxY = Math.max(y1, y2);
        double maxZ = Math.max(z1, z2);
        double x = minX;
        while (x <= maxX) {
            edgeLocations.add(new Location(corner1.getWorld(), x, minY, minZ));
            edgeLocations.add(new Location(corner1.getWorld(), x, minY, maxZ));
            if (includeColumns) {
                z = minZ + (double)spacing;
                while (z < maxZ) {
                    edgeLocations.add(new Location(corner1.getWorld(), x, minY, z));
                    z += (double)spacing;
                }
            }
            x += 1.0;
        }
        x = minX;
        while (x <= maxX) {
            edgeLocations.add(new Location(corner1.getWorld(), x, maxY, minZ));
            edgeLocations.add(new Location(corner1.getWorld(), x, maxY, maxZ));
            if (includeColumns) {
                z = minZ + (double)spacing;
                while (z < maxZ) {
                    edgeLocations.add(new Location(corner1.getWorld(), x, maxY, z));
                    z += (double)spacing;
                }
            }
            x += 1.0;
        }
        double z3 = minZ;
        while (z3 <= maxZ) {
            edgeLocations.add(new Location(corner1.getWorld(), minX, minY, z3));
            edgeLocations.add(new Location(corner1.getWorld(), maxX, minY, z3));
            edgeLocations.add(new Location(corner1.getWorld(), minX, maxY, z3));
            edgeLocations.add(new Location(corner1.getWorld(), maxX, maxY, z3));
            z3 += 1.0;
        }
        double y = minY;
        while (y <= maxY) {
            edgeLocations.add(new Location(corner1.getWorld(), minX, y, minZ));
            edgeLocations.add(new Location(corner1.getWorld(), maxX, y, minZ));
            edgeLocations.add(new Location(corner1.getWorld(), minX, y, maxZ));
            edgeLocations.add(new Location(corner1.getWorld(), maxX, y, maxZ));
            if (includeColumns) {
                double x3 = minX + (double)spacing;
                while (x3 < maxX) {
                    edgeLocations.add(new Location(corner1.getWorld(), x3, y, minZ));
                    edgeLocations.add(new Location(corner1.getWorld(), x3, y, maxZ));
                    x3 += (double)spacing;
                }
                z = minZ + (double)spacing;
                while (z < maxZ) {
                    edgeLocations.add(new Location(corner1.getWorld(), minX, y, z));
                    edgeLocations.add(new Location(corner1.getWorld(), maxX, y, z));
                    z += (double)spacing;
                }
            }
            y += 1.0;
        }
        return edgeLocations;
    }

    public static void showAreaFrame(final Player player, final Location corner1, final Location corner2, final int spacing, final int clearSeconds, final boolean loopInArea, final boolean includeColumns) {
        if (frameCooldowns.contains(player.getUniqueId())) {
            return;
        }
        frameCooldowns.add(player.getUniqueId());
        final ArrayList<Location> locs = TUMaths.getEdgeLocations(corner1, corner2, spacing, includeColumns);
        for (Location loc : new ArrayList()) {
            if (TUMaths.isLocationNearby(player.getLocation(), loc, frameRange)) continue;
            locs.remove(loc);
        }
        long delay = 0L;
        int count = 20;
        final Material useMat = lastMat = TUMaths.getNextFrameMaterial();
        for (final Location loc : locs) {
            if (--count == 0) {
                ++delay;
            }
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    player.sendBlockChange(loc, useMat.createBlockData());
                }
            }, delay);
        }
        if (clearSeconds > 0) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    frameCooldowns.remove(player.getUniqueId());
                    if (loopInArea && TUMaths.inArea(corner1, corner2, player.getLocation())) {
                        for (Location loc : locs) {
                            if (TUMaths.isLocationNearby(player.getLocation(), loc, frameRange)) continue;
                            player.sendBlockChange(loc, loc.getBlock().getState().getBlockData());
                        }
                        TUMaths.showAreaFrame(player, corner1, corner2, spacing, clearSeconds, loopInArea, includeColumns);
                    } else {
                        for (Location loc : locs) {
                            player.sendBlockChange(loc, loc.getBlock().getState().getBlockData());
                        }
                    }
                }
            }, delay + 1L + 20L * (long)clearSeconds);
        } else {
            frameCooldowns.remove(player.getUniqueId());
        }
    }

    public static void showAreaFrameParticles(final Player player, final Location corner1, final Location corner2, final int spacing, final int clearSeconds, final boolean loopInArea, final boolean includeColumns, final Color color) {
        final Particle.DustOptions dust = new Particle.DustOptions(color, 1.0f);
        if (frameCooldowns.contains(player.getUniqueId())) {
            return;
        }
        final ArrayList<Location> locs = TUMaths.getEdgeLocations(corner1, corner2, spacing, includeColumns);
        for (Location loc : new ArrayList()) {
            if (TUMaths.isLocationNearby(player.getLocation(), loc, frameRange)) continue;
            locs.remove(loc);
        }
        long delay = 0L;
        int count = 20;
        for (final Location loc : locs) {
            if (--count == 0) {
                ++delay;
            }
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    player.spawnParticle(Particle.DUST, loc.add(0.5, 0.5, 0.5), 1, (Object)dust);
                }
            }, delay);
        }
        if (clearSeconds > 0) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    frameCooldowns.remove(player.getUniqueId());
                    if (loopInArea && TUMaths.inArea(corner1, corner2, player.getLocation())) {
                        for (Location loc : locs) {
                            if (TUMaths.isLocationNearby(player.getLocation(), loc, frameRange)) continue;
                            player.spawnParticle(Particle.DUST, loc.add(0.5, 0.5, 0.5), 1, (Object)dust);
                        }
                        TUMaths.showAreaFrameParticles(player, corner1, corner2, spacing, clearSeconds, loopInArea, includeColumns, color);
                    }
                }
            }, delay + 1L + 20L * (long)clearSeconds);
        } else {
            frameCooldowns.remove(player.getUniqueId());
        }
    }

    private static Material getNextFrameMaterial() {
        if (lastMat == null) {
            return Material.EMERALD_BLOCK;
        }
        if (lastMat.equals((Object)Material.EMERALD_BLOCK)) {
            return Material.BLACK_CONCRETE;
        }
        if (lastMat.equals((Object)Material.BLACK_CONCRETE)) {
            return Material.WHITE_CONCRETE;
        }
        if (lastMat.equals((Object)Material.WHITE_CONCRETE)) {
            return Material.BLUE_CONCRETE;
        }
        if (lastMat.equals((Object)Material.BLUE_CONCRETE)) {
            return Material.BROWN_CONCRETE;
        }
        if (lastMat.equals((Object)Material.BROWN_CONCRETE)) {
            return Material.CYAN_CONCRETE;
        }
        if (lastMat.equals((Object)Material.CYAN_CONCRETE)) {
            return Material.GRAY_CONCRETE;
        }
        if (lastMat.equals((Object)Material.GRAY_CONCRETE)) {
            return Material.GREEN_CONCRETE;
        }
        if (lastMat.equals((Object)Material.GREEN_CONCRETE)) {
            return Material.YELLOW_CONCRETE;
        }
        if (lastMat.equals((Object)Material.YELLOW_CONCRETE)) {
            return Material.PURPLE_CONCRETE;
        }
        if (lastMat.equals((Object)Material.PURPLE_CONCRETE)) {
            return Material.RED_CONCRETE;
        }
        if (lastMat.equals((Object)Material.RED_CONCRETE)) {
            return Material.LIGHT_BLUE_CONCRETE;
        }
        if (lastMat.equals((Object)Material.LIGHT_BLUE_CONCRETE)) {
            return Material.LIGHT_GRAY_CONCRETE;
        }
        if (lastMat.equals((Object)Material.LIGHT_GRAY_CONCRETE)) {
            return Material.LIME_CONCRETE;
        }
        if (lastMat.equals((Object)Material.LIME_CONCRETE)) {
            return Material.MAGENTA_CONCRETE;
        }
        if (lastMat.equals((Object)Material.MAGENTA_CONCRETE)) {
            return Material.PINK_CONCRETE;
        }
        if (lastMat.equals((Object)Material.PINK_CONCRETE)) {
            return Material.PURPLE_CONCRETE;
        }
        return Material.EMERALD_BLOCK;
    }

    public static String simplifyNumber(int number) {
        String[] suffix = new String[]{"", "k", "M", "B", "T"};
        boolean isNegative = number < 0;
        number = Math.abs(number);
        int index = 0;
        while (number >= 1000 && index < suffix.length - 1) {
            ++index;
            number /= 1000;
        }
        String result = String.valueOf(number) + suffix[index];
        if (isNegative) {
            result = "-" + result;
        }
        return result;
    }

    public static boolean canLocationHaveRain(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        Biome biome = location.getBlock().getBiome();
        if (biome == Biome.DESERT || biome == Biome.SAVANNA || biome == Biome.BADLANDS) {
            return false;
        }
        if (location.getBlock().getRelative(BlockFace.UP).getLightFromSky() != 15) {
            return false;
        }
        return world.hasStorm();
    }

    public static String capitalizeWords(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String[] words = input.toLowerCase().split("\\s+");
        StringBuilder result = new StringBuilder();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!word.isEmpty()) {
                result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
            }
            ++n2;
        }
        return result.toString().trim();
    }

    public static BlockFace getCardinalDirection(Location from, Location to) {
        double dx = to.getX() - from.getX();
        double dz = to.getZ() - from.getZ();
        if (Math.abs(dx) > Math.abs(dz)) {
            return dx > 0.0 ? BlockFace.EAST : BlockFace.WEST;
        }
        return dz > 0.0 ? BlockFace.SOUTH : BlockFace.NORTH;
    }

    public static String getItemName(ItemStack stack) {
        String name = ChatColor.stripColor((String)stack.getItemMeta().getDisplayName());
        if (name.length() == 0) {
            name = ChatColor.stripColor((String)stack.getItemMeta().getItemName());
        }
        if (name.length() == 0) {
            name = ChatColor.stripColor((String)stack.getType().toString());
        }
        return name;
    }

    public static String capitalize(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }
}

