/*
 * Decompiled with CFR 0.152.
 */
package com.MT.triggersUtility;

import java.time.temporal.ChronoUnit;
import java.util.Calendar;

public class TUTimes {
    public static String getNow() {
        return TUTimes.getTimeString(Calendar.getInstance());
    }

    public static String getTimeString(Calendar calendar) {
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return year + ":" + month + ":" + day + ":" + hour + ":" + minute;
    }

    public static int getTimeVariable(String timeString, String variable) {
        if (TUTimes.isValidTimeString(timeString)) {
            if (variable.contains("year")) {
                return Integer.valueOf(timeString.split(":")[0]);
            }
            if (variable.contains("month")) {
                return Integer.valueOf(timeString.split(":")[1]);
            }
            if (variable.contains("day")) {
                return Integer.valueOf(timeString.split(":")[2]);
            }
            if (variable.contains("hour")) {
                return Integer.valueOf(timeString.split(":")[3]);
            }
            if (variable.contains("minute")) {
                return Integer.valueOf(timeString.split(":")[4]);
            }
        }
        return -1;
    }

    public static String addDays(String timeString, int days) {
        if (TUTimes.isValidTimeString(timeString)) {
            Calendar calendar = Calendar.getInstance();
            int year = TUTimes.getTimeVariable(timeString, "year");
            int month = TUTimes.getTimeVariable(timeString, "month");
            int day = TUTimes.getTimeVariable(timeString, "day");
            int hour = TUTimes.getTimeVariable(timeString, "hour");
            int minute = TUTimes.getTimeVariable(timeString, "minute");
            calendar.set(year, month, day, hour, minute);
            calendar.add(5, days);
            return TUTimes.getTimeString(calendar);
        }
        return null;
    }

    public static boolean isDatePassed(String timeString, String seconString) {
        return TUTimes.dayDifference(timeString, seconString) > 0;
    }

    public static String getOldestDate(String timeString, String timeString2) {
        int year = TUTimes.getTimeVariable(timeString, "year");
        int month = TUTimes.getTimeVariable(timeString, "month");
        int day = TUTimes.getTimeVariable(timeString, "day");
        int hour = TUTimes.getTimeVariable(timeString, "hour");
        int minute = TUTimes.getTimeVariable(timeString, "minute");
        int year2 = TUTimes.getTimeVariable(timeString2, "year");
        int month2 = TUTimes.getTimeVariable(timeString2, "month");
        int day2 = TUTimes.getTimeVariable(timeString2, "day");
        int hour2 = TUTimes.getTimeVariable(timeString2, "hour");
        int minute2 = TUTimes.getTimeVariable(timeString2, "minute");
        if (year < year2) {
            return timeString;
        }
        if (year == year2) {
            if (month < month2) {
                return timeString;
            }
            if (month == month2) {
                if (day < day2) {
                    return timeString;
                }
                if (day == day2) {
                    if (hour < hour2) {
                        return timeString;
                    }
                    if (hour == hour2 && minute < minute2) {
                        return timeString;
                    }
                }
            }
        }
        return timeString2;
    }

    public static int dayDifference(String timeString, String seconString) {
        if (TUTimes.isValidTimeString(timeString) && TUTimes.isValidTimeString(seconString)) {
            Calendar calendar1 = Calendar.getInstance();
            int year = TUTimes.getTimeVariable(timeString, "year");
            int month = TUTimes.getTimeVariable(timeString, "month");
            int day = TUTimes.getTimeVariable(timeString, "day");
            int hour = TUTimes.getTimeVariable(timeString, "hour");
            int minute = TUTimes.getTimeVariable(timeString, "minute");
            calendar1.set(year, month, day, hour, minute);
            Calendar calendar2 = Calendar.getInstance();
            int year2 = TUTimes.getTimeVariable(seconString, "year");
            int month2 = TUTimes.getTimeVariable(seconString, "month");
            int day2 = TUTimes.getTimeVariable(seconString, "day");
            int hour2 = TUTimes.getTimeVariable(seconString, "hour");
            int minute2 = TUTimes.getTimeVariable(seconString, "minute");
            calendar2.set(year2, month2, day2, hour2, minute2);
            return TUTimes.daysBetween(calendar1, calendar2);
        }
        return -1;
    }

    public static int hourDifference(String timeString, String seconString) {
        if (TUTimes.isValidTimeString(timeString) && TUTimes.isValidTimeString(seconString)) {
            Calendar calendar1 = Calendar.getInstance();
            int year = TUTimes.getTimeVariable(timeString, "year");
            int month = TUTimes.getTimeVariable(timeString, "month");
            int day = TUTimes.getTimeVariable(timeString, "day");
            int hour = TUTimes.getTimeVariable(timeString, "hour");
            int minute = TUTimes.getTimeVariable(timeString, "minute");
            calendar1.set(year, month, day, hour, minute);
            Calendar calendar2 = Calendar.getInstance();
            int year2 = TUTimes.getTimeVariable(seconString, "year");
            int month2 = TUTimes.getTimeVariable(seconString, "month");
            int day2 = TUTimes.getTimeVariable(seconString, "day");
            int hour2 = TUTimes.getTimeVariable(seconString, "hour");
            int minute2 = TUTimes.getTimeVariable(seconString, "minute");
            calendar2.set(year2, month2, day2, hour2, minute2);
            return calendar1.get(11) - calendar2.get(11);
        }
        return -1;
    }

    public static int minuteDifference(String timeString, String seconString) {
        if (TUTimes.isValidTimeString(timeString) && TUTimes.isValidTimeString(seconString)) {
            Calendar calendar1 = Calendar.getInstance();
            int year = TUTimes.getTimeVariable(timeString, "year");
            int month = TUTimes.getTimeVariable(timeString, "month");
            int day = TUTimes.getTimeVariable(timeString, "day");
            int hour = TUTimes.getTimeVariable(timeString, "hour");
            int minute = TUTimes.getTimeVariable(timeString, "minute");
            calendar1.set(year, month, day, hour, minute);
            Calendar calendar2 = Calendar.getInstance();
            int year2 = TUTimes.getTimeVariable(seconString, "year");
            int month2 = TUTimes.getTimeVariable(seconString, "month");
            int day2 = TUTimes.getTimeVariable(seconString, "day");
            int hour2 = TUTimes.getTimeVariable(seconString, "hour");
            int minute2 = TUTimes.getTimeVariable(seconString, "minute");
            calendar2.set(year2, month2, day2, hour2, minute2);
            return calendar1.get(12) - calendar2.get(12);
        }
        return -1;
    }

    public static int timePassed(String timeString, String seconString, String type) {
        if (TUTimes.isValidTimeString(timeString) && TUTimes.isValidTimeString(seconString)) {
            Calendar calendar1 = Calendar.getInstance();
            int year = TUTimes.getTimeVariable(timeString, "year");
            int month = TUTimes.getTimeVariable(timeString, "month");
            int day = TUTimes.getTimeVariable(timeString, "day");
            int hour = TUTimes.getTimeVariable(timeString, "hour");
            int minute = TUTimes.getTimeVariable(timeString, "minute");
            calendar1.set(year, month, day, hour, minute);
            Calendar calendar2 = Calendar.getInstance();
            int year2 = TUTimes.getTimeVariable(seconString, "year");
            int month2 = TUTimes.getTimeVariable(seconString, "month");
            int day2 = TUTimes.getTimeVariable(seconString, "day");
            int hour2 = TUTimes.getTimeVariable(seconString, "hour");
            int minute2 = TUTimes.getTimeVariable(seconString, "minute");
            calendar2.set(year2, month2, day2, hour2, minute2);
            int yearsElapsed = year - year2;
            int monthsElapsed = (year - year2) * 12 + (month - month2);
            int daysBetween = (int)ChronoUnit.DAYS.between(calendar1.toInstant(), calendar2.toInstant());
            int minsBetween = (int)ChronoUnit.MINUTES.between(calendar1.toInstant(), calendar2.toInstant());
            int secondsBetween = (int)ChronoUnit.SECONDS.between(calendar1.toInstant(), calendar2.toInstant());
            if (type.toLowerCase().contains("year")) {
                return yearsElapsed;
            }
            if (type.toLowerCase().contains("months")) {
                return monthsElapsed;
            }
            if (type.toLowerCase().contains("days")) {
                return daysBetween;
            }
            if (type.toLowerCase().contains("minutes")) {
                return minsBetween;
            }
            if (type.toLowerCase().contains("seconds")) {
                return secondsBetween;
            }
            return calendar1.get(12) - calendar2.get(12);
        }
        return -1;
    }

    private static int daysBetween(Calendar day1, Calendar day2) {
        Calendar dayOne = (Calendar)day1.clone();
        Calendar dayTwo = (Calendar)day2.clone();
        if (dayOne.get(1) == dayTwo.get(1)) {
            return dayOne.get(6) - dayTwo.get(6);
        }
        if (dayTwo.get(1) > dayOne.get(1)) {
            Calendar temp = dayOne;
            dayOne = dayTwo;
            dayTwo = temp;
        }
        int extraDays = 0;
        int dayOneOriginalYearDays = dayOne.get(6);
        while (dayOne.get(1) > dayTwo.get(1)) {
            dayOne.add(1, -1);
            extraDays += dayOne.getActualMaximum(6);
        }
        return extraDays - dayTwo.get(6) + dayOneOriginalYearDays;
    }

    public static String getReadableTimeString(String timeString) {
        if (TUTimes.isValidTimeString(timeString)) {
            int year = TUTimes.getTimeVariable(timeString, "year");
            int month = TUTimes.getTimeVariable(timeString, "month") + 1;
            int day = TUTimes.getTimeVariable(timeString, "day");
            int hour = TUTimes.getTimeVariable(timeString, "hour");
            Object strMin = "";
            int minute = TUTimes.getTimeVariable(timeString, "minute");
            strMin = minute < 10 ? "0" + minute : "" + minute;
            String side = "AM";
            int newHour = hour;
            if (newHour >= 12) {
                newHour -= 12;
                side = "PM";
            }
            return month + "/" + day + "/" + year + "/" + Math.abs(newHour) + ":" + (String)strMin + " " + side + " EST";
        }
        return null;
    }

    private static boolean isValidTimeString(String timeString) {
        return timeString != null && timeString.split(":").length == 5;
    }
}

