/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Defense;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.Pollution.BiterAttack;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BiterDetector
extends Device {
    private static final long serialVersionUID = 7571974022228037011L;
    private static int detectorRange = 200;
    private transient ArrayList<UUID> pinged = new ArrayList();

    public BiterDetector(Location loc) {
        super(loc);
        this.setMaterial("BAMBOO_SLAB");
        this.deviceName = "Biter Detector";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(2);
        this.setActionPower(2);
        this.useAutoSlots();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Sends a warning for incoming biter attacks!");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.ENDER_EYE, 0.5);
    }

    @Override
    public void action() {
        if (this.pinged == null) {
            this.pinged = new ArrayList();
        }
        if (this.isPowered()) {
            this.updateUI();
            if (this.getPlacerUUIDString() != null && Bukkit.getPlayer((UUID)UUID.fromString(this.getPlacerUUIDString())) != null && Bukkit.getPlayer((UUID)UUID.fromString(this.getPlacerUUIDString())).isOnline()) {
                Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.getPlacerUUIDString()));
                for (BiterAttack ba : BiterAttack.getAllAttacks()) {
                    if (!ba.getCurrentStage().equals((Object)BiterAttack.AttackStage.MOVING) && !ba.getCurrentStage().equals((Object)BiterAttack.AttackStage.ATTACKING) || this.pinged.contains(ba.getUUID()) || TUMaths.getManhattanDistance(ba.convoyLocation, this.getLocation()) > detectorRange) continue;
                    player.sendMessage(MineItems.goldBold() + "[Biter Detector] " + String.valueOf(ChatColor.WHITE) + "Attack Incoming! Detector - " + TUMaths.locationString(this.getLocation()));
                    player.playSound((Entity)player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 2.0f);
                    this.pinged.add(ba.getUUID());
                    break;
                }
            }
        }
    }
}

