/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Defense;

import com.MT.xxxtrigger50xxx.Devices.Turret;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class BowTurret
extends Turret {
    private static final long serialVersionUID = 6859323692496618403L;

    public BowTurret(Location loc) {
        super(loc);
        this.deviceName = "Bow Turret";
        this.setActionPower(3);
    }

    @Override
    public ItemStack getAmmo() {
        return new ItemStack(Material.ARROW);
    }

    @Override
    public ItemStack getCartidge() {
        return null;
    }

    @Override
    public void shootTarget(Location shootSpot, Entity target, Location targetLoc, ArrayList<Location> line) {
        this.shootArrow(shootSpot, targetLoc, 3.0);
        this.logItem(this.getAmmo(), -1);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Requires a bow & arrow to shoot.");
        lore.add("- This will shoot up to " + this.range + " blocks away.");
        lore.add("- Arrows & a Bow can be inputted into the input slots.");
        return lore;
    }

    @Override
    public boolean allowedToShoot() {
        for (ItemStack stack : this.getInputItemsAsClones()) {
            if (!stack.getType().equals((Object)Material.BOW)) continue;
            return true;
        }
        this.setFailReason("Missing bow");
        return false;
    }

    @Override
    public void postShoot() {
        for (ItemStack stack : this.getInputItems()) {
            if (!stack.getType().equals((Object)Material.BOW)) continue;
            MineUtil.damageItemStack(stack, this.getLocation(), this.getInventory(), 1.0);
            break;
        }
    }
}

