/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Defense;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class FloodLight
extends Device {
    private static final long serialVersionUID = 1114975555558037017L;
    private transient Item item = null;
    private ArrayList<String> lightLocations = new ArrayList();
    private transient ArrayList<Location> bakedLoctions = new ArrayList();
    private boolean lightsSpawned = false;

    public FloodLight(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = "Flood Light";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(false);
        this.setRefreshInv(false);
        this.setIdlePower(3);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Covers a massive area with light.");
        lore.add("- Light is only created in air spaces.");
        lore.add("- Only works when powered.");
        return lore;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.REDSTONE_LAMP, 1.0);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
        if (this.bakedLoctions != null && this.bakedLoctions.size() > 0) {
            for (Location loc : this.bakedLoctions) {
                if (!loc.getBlock().getType().equals((Object)Material.LIGHT)) continue;
                loc.getBlock().setType(Material.AIR);
            }
        }
    }

    @Override
    public void action() {
        block14: {
            block13: {
                if (this.bakedLoctions == null) {
                    this.bakedLoctions = new ArrayList();
                }
                if (!TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance)) {
                    return;
                }
                if (!this.isPowered()) break block13;
                if (this.lightLocations.size() == 0) {
                    Directional dis = (Directional)this.getLocation().getBlock().getBlockData();
                    Block center = this.getLocation().getBlock();
                    int i = 0;
                    while (i < 5) {
                        center = center.getRelative(dis.getFacing());
                        ++i;
                    }
                    BlockFace facing = dis.getFacing();
                    BlockFace leftFace = TUMaths.rotateBlockFace(facing, 90);
                    BlockFace rightFace = TUMaths.rotateBlockFace(facing, 270);
                    int cone = 2;
                    Location lastLeft = null;
                    Location lastRight = null;
                    int spacing = 3;
                    int i2 = 0;
                    while (i2 < 38) {
                        center = center.getRelative(dis.getFacing(), spacing);
                        if (i2 <= 32) {
                            if (i2 <= 12) {
                                left = center.getRelative(leftFace, cone).getLocation();
                                right = center.getRelative(rightFace, cone).getLocation();
                                this.lightLocations.add(TUMaths.locationString(left));
                                this.lightLocations.add(TUMaths.locationString(right));
                                lastLeft = left;
                                lastRight = right;
                                ++cone;
                            } else {
                                left = lastLeft.getBlock().getRelative(facing, spacing).getLocation();
                                right = lastRight.getBlock().getRelative(facing, spacing).getLocation();
                                lastLeft = left;
                                lastRight = right;
                                this.lightLocations.add(TUMaths.locationString(left));
                                this.lightLocations.add(TUMaths.locationString(right));
                            }
                        }
                        this.lightLocations.add(TUMaths.locationString(center));
                        i2 += spacing;
                    }
                }
                if (this.bakedLoctions.size() == 0) {
                    for (String str : this.lightLocations) {
                        this.bakedLoctions.add(TUMaths.getStringLocation(str));
                    }
                }
                if (this.lightsSpawned) break block14;
                this.lightsSpawned = true;
                for (Location loc : this.bakedLoctions) {
                    if (!this.canSpawnLight(loc.getBlock().getType())) continue;
                    loc.getBlock().setType(Material.LIGHT);
                }
                break block14;
            }
            if (this.lightsSpawned) {
                this.lightsSpawned = false;
                for (Location loc : this.bakedLoctions) {
                    if (!loc.getBlock().getType().equals((Object)Material.LIGHT)) continue;
                    loc.getBlock().setType(Material.AIR);
                }
            }
        }
    }

    private boolean canSpawnLight(Material mat) {
        return mat.equals((Object)Material.AIR) || mat.equals((Object)Material.TALL_GRASS) || mat.equals((Object)Material.SHORT_GRASS) || mat.equals((Object)Material.SNOW);
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.DROPPER));
        ings.add(new ItemStack(Material.REDSTONE_LAMP));
        RecipeUtils.addDefaultRecipe(new FloodLight(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

