/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Defense;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Turret;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.PlayerData;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class LaserTurret
extends Turret {
    private static final long serialVersionUID = 6833323692496618403L;
    private static Particle.DustOptions dust = new Particle.DustOptions(Color.RED, 1.0f);

    public LaserTurret(Location loc) {
        super(loc);
        this.deviceName = "Laser Turret";
        this.setActionPower(20);
        this.cooldown = 2;
    }

    @Override
    public ItemStack getAmmo() {
        return null;
    }

    @Override
    public ItemStack getCartidge() {
        return null;
    }

    @Override
    public void shootTarget(final Location shootSpot, Entity target, Location targetLoc, ArrayList<Location> line) {
        PlayerData pd;
        World world = shootSpot.getWorld();
        if (TUMaths.isPlayerNearby(shootSpot, MineMain.nearDistance)) {
            world.playSound(shootSpot, Sound.ITEM_FIRECHARGE_USE, 0.5f, 1.2f);
        }
        if (TUMaths.isPlayerNearby(shootSpot, MineMain.distantDistance)) {
            for (Location loc : MineUtil.getLocationLine(shootSpot, targetLoc, 0.5)) {
                world.spawnParticle(MineMain.version.getDustParticle(), loc, 1, (Object)dust);
            }
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    LaserTurret.this.smokeEffect(shootSpot);
                }
            }, 5L);
        }
        LivingEntity lent = (LivingEntity)target;
        double damage = 8.0;
        if (this.getPlacerUUIDString() != null && (pd = PlayerData.getPlayerData(this.getPlacerUUIDString())) != null) {
            damage *= 2.0;
        }
        lent.damage(damage);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This will shoot up to " + this.range + " blocks away.");
        return lore;
    }

    @Override
    public boolean allowedToShoot() {
        return true;
    }

    public void smokeEffect(Location shootPoint) {
        Random random = new Random();
        double radius = 0.5;
        int i = 0;
        while (i <= 8) {
            double offsetX = (random.nextDouble() * 2.0 - 1.0) * radius;
            double offsetY = 0.0;
            double offsetZ = (random.nextDouble() * 2.0 - 1.0) * radius;
            Location particleLocation = shootPoint.add(offsetX, offsetY, offsetZ);
            particleLocation.getWorld().spawnParticle(MineMain.version.getSmokeParticle(), particleLocation, 1, 0.0, 0.0, 0.0, 1.0E-5);
            ++i;
        }
    }

    @Override
    public int getGridScore() {
        return 2;
    }
}

