/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Defense;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MobBlocker
extends Device {
    public static ArrayList<Location> blockedLocations = new ArrayList();
    private static final long serialVersionUID = -3929409112253171315L;
    private static String classSpacedNamed = "Mob Blocker";

    public MobBlocker(Location loc) {
        super(loc);
        this.setMaterial("SEA_LANTERN");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(false);
        this.setIdlePower(60);
        this.setActionPower(0);
        this.setUseUI(true);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device prevents hostile mobs");
        lore.add("- from spawning naturally. This will not stop");
        lore.add("- spawners, biters or other types of spawns.");
        return lore;
    }

    @Override
    public void updateUI() {
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.whiteBold()) + "Device Information", TUItems.basicLore(MineUtil.colon(" Powered", "" + this.isPowered())));
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.CREEPER_HEAD, 1.0);
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            blockedLocations.add(this.getLocation());
        } else if (blockedLocations.contains(this.getLocation())) {
            blockedLocations.remove(this.getLocation());
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, MobBlocker.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.DEFENSE, new MobBlocker(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Processing Unit"));
        ings.add(MineItems.getIndustrialItem("Low Density Structure", 7));
        ings.add(MineItems.getIndustrialItem("Electric Engine Unit"));
        RecipeUtils.addDefaultRecipe(new MobBlocker(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 5;
    }
}

