/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Furnace;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.ItemStack;

public class CombustionGenerator
extends Device {
    private static final long serialVersionUID = -3929409797254451315L;
    public transient boolean isPhysicalMode = false;
    private int burnTimer = 0;
    private transient Furnace furnaceInstance;
    private transient ItemStack vFuel;

    public CombustionGenerator(Location loc) {
        super(loc);
        this.setMaterial("FURNACE");
        this.deviceName = "Combustion Generator";
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.setPowerGen(15);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.add(1);
        slots.add(2);
        this.setClickableSlots(slots);
        this.setPollutionGen(10);
        this.updateDeviceHeadItem();
        this.displayRotationOffset = -90;
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.add(1);
        slots.add(2);
        this.setClickableSlots(slots);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Burns fuel supply but outputs power to the connected grid.");
        lore.add("- Fuel sources don't change the amount of power produced.");
        lore.add("- As long as the device is burning, power is being made.");
        lore.add("- Fuel burns twice as long.");
        return lore;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void playerNearbyUpdate(boolean nearby) {
        if (nearby && this.getGrid() == null) {
            this.updateMode();
            this.updateSmeltSlot();
        }
        if (!this.getPoweredState().equals((Object)Device.PoweredState.ON) && nearby) {
            this.getFurnace().getInventory().setSmelting(this.getNewSmeltStack());
        }
    }

    @Override
    public void visualUpdate(boolean nearby) {
    }

    @Override
    public void action() {
        this.updateMode();
        if (this.isPhysicalMode) {
            this.physicalAction();
        } else {
            this.virtualAction();
        }
        if (this.getGrid() != null) {
            if (this.burnTimer > 0) {
                this.getGrid().addPower(this, this.getPowerGen());
                this.setProducingPower(true);
            } else {
                this.setProducingPower(false);
            }
            if (this.burnTimer > 0) {
                --this.burnTimer;
            }
        }
    }

    @Override
    public void cleanup() {
    }

    private void virtualAction() {
        if (this.burnTimer <= 0 && TUItems.isValid(this.vFuel) && this.vFuel.getAmount() > 0 && !this.vFuel.getType().equals((Object)Material.BUCKET)) {
            this.burnTimer = MineUtil.burnSeconds(this.vFuel.getType()) * 2;
            if (!this.vFuel.getType().equals((Object)Material.LAVA_BUCKET)) {
                this.logItem(this.vFuel, -1);
                this.vFuel.setAmount(this.vFuel.getAmount() - 1);
            } else {
                this.vFuel.setType(Material.BUCKET);
            }
        }
    }

    private void physicalAction() {
        ItemStack fuel;
        boolean newburn = false;
        if (this.burnTimer <= 0 && TUItems.isValid(fuel = this.furnaceInstance.getInventory().getFuel()) && fuel.getAmount() > 0 && !fuel.getType().equals((Object)Material.BUCKET)) {
            this.burnTimer = MineUtil.burnSeconds(fuel.getType()) * 2;
            this.logItem(fuel, -1);
            if (!fuel.getType().equals((Object)Material.LAVA_BUCKET)) {
                fuel.setAmount(fuel.getAmount() - 1);
            } else {
                fuel.setType(Material.BUCKET);
            }
            newburn = true;
        }
        if (newburn) {
            Furnace furnace = this.getFurnace();
            furnace.setBurnTime((short)(this.burnTimer * 20));
            furnace.update();
        }
        if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.closeDistance)) {
            this.updateSmeltSlot();
        }
    }

    private void updateMode() {
        if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.distantDistance)) {
            if (!this.isPhysicalMode) {
                this.toPhysicalMode();
            }
        } else if (this.isPhysicalMode) {
            this.toVirtualMode();
        }
    }

    private void toVirtualMode() {
        this.isPhysicalMode = false;
        FurnaceInventory finv = ((Furnace)this.getLocation().getBlock().getState()).getInventory();
        this.vFuel = null;
        if (TUItems.isValid(finv.getFuel())) {
            this.vFuel = finv.getFuel();
        }
    }

    private void toPhysicalMode() {
        this.isPhysicalMode = true;
        this.furnaceInstance = (Furnace)this.getLocation().getBlock().getState();
        if (this.burnTimer <= 0) {
            this.furnaceInstance.setBurnTime((short)0);
        } else {
            this.furnaceInstance.setBurnTime((short)(this.burnTimer * 20));
        }
        this.furnaceInstance.update();
        if (this.vFuel != null && this.vFuel.getAmount() > 0) {
            this.furnaceInstance.getInventory().setFuel(this.vFuel);
        }
    }

    private ItemStack getNewSmeltStack() {
        Material mat = Material.GREEN_CONCRETE;
        String str = String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "Producing Power";
        int modelID = 9536;
        boolean isOn = this.getPoweredState().equals((Object)Device.PoweredState.ON);
        if (this.burnTimer <= 0 || !isOn) {
            String name = String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No Fuel";
            if (!isOn) {
                name = String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Turned Off";
            }
            str = name;
            mat = Material.RED_CONCRETE;
            modelID = 9535;
        }
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Burn Time", this.burnTimer + "s"));
        ItemStack stack = TUItems.setModelData(TUItems.createItem(mat, str, lore), modelID);
        if (!isOn) {
            TUItems.addLore(stack, String.valueOf(ChatColor.RED) + " - " + this.getPoweredStateString());
        }
        return stack;
    }

    private void updateSmeltSlot() {
        this.furnaceInstance.getInventory().setSmelting(this.getNewSmeltStack());
    }

    public Furnace getFurnace() {
        return (Furnace)this.getLocation().getBlock().getState();
    }
}

