/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.SkullCreator;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public class GlowStoneGenerator
extends Device {
    private static String classSpacedNamed = "Glowstone Generator";
    private static final long serialVersionUID = -313509797254451315L;
    private int fuel = 0;
    private String worldType = null;
    public static ArrayList<Material> netherStacks = new ArrayList();

    static {
        netherStacks.add(Material.WARPED_HYPHAE);
        netherStacks.add(Material.WARPED_STEM);
        netherStacks.add(Material.SOUL_SOIL);
        netherStacks.add(Material.SOUL_SAND);
        netherStacks.add(Material.NETHERRACK);
    }

    public GlowStoneGenerator(Location loc) {
        super(loc);
        this.setMaterial("LODESTONE");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setUseUI(true);
        this.setGridRange(5);
        this.setRefreshInv(false);
        this.setPowerGen(10);
        this.useAutoSlots();
        this.setIdlePower(0);
        this.setPollutionGen(0);
        if (loc != null) {
            this.worldType = loc.getWorld().getEnvironment().toString();
        }
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This burns glowstone to generate power.");
        lore.add("- It burns 2x longer in the nether.");
        lore.add("- Produces nether items when burning glowstone.");
        return lore;
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        this.setDisplayStackString(SkullCreator.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTdiZjU3NzMyOGE4YTE4ZTU0Nzg0NGQxNDQ4NWMwN2JmYjg2YTAyODczZTk5MDc4NDMxNjQ0NTBjYTg4OGYwYiJ9fX0="));
        this.displayRotationOffset = -90;
        this.handleDisplay();
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        TUItems.removeLoreNoColor(this.getInventory().getItem(13), "Power Usage");
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Fuel", "" + this.fuel));
        return lore;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GLOWSTONE_DUST, 1.0);
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            if (this.fuel <= 0) {
                for (ItemStack stack : this.getInputItems()) {
                    if (!stack.getType().equals((Object)Material.GLOWSTONE_DUST)) continue;
                    this.logItem(stack, -1);
                    stack.setAmount(stack.getAmount() - 1);
                    int add = 180;
                    if (this.worldType.equals("NETHER")) {
                        add *= 2;
                    }
                    if (MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), 8.0)) {
                        this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_SOUL_SAND_BREAK, 1.0f, 1.0f);
                    }
                    this.fuel = add;
                    this.generateNetherItem();
                    break;
                }
            }
            if (this.fuel > 0) {
                if (MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), 4.0)) {
                    this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_FURNACE_FIRE_CRACKLE, 0.5f, 1.0f);
                    if (TUMaths.rollRange(0, 99) <= 10) {
                        this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_LODESTONE_PLACE, 0.5f, 0.5f);
                    }
                }
                this.getGrid().addPower(this, this.getPowerGen());
                this.setProducingPower(true);
                --this.fuel;
            } else {
                this.setFailReason("Missing glowstone");
            }
        }
    }

    public void generateNetherItem() {
        if (this.getOutputSlot() != -1) {
            ItemStack stack = new ItemStack(netherStacks.get(TUMaths.rollRange(0, netherStacks.size() - 1)));
            this.getInventory().setItem(this.getOutputSlot(), stack);
            this.logItem(stack, 1);
            if (MinetorioListener.isPlayerNearby2DOPT(this.getLocation(), 8.0)) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 1.0f);
            }
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, GlowStoneGenerator.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new GlowStoneGenerator(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.POLISHED_ANDESITE, 3));
        ings.add(new ItemStack(Material.GLOWSTONE, 2));
        ings.add(new ItemStack(Material.MAGMA_BLOCK));
        RecipeUtils.addDefaultRecipe(new GlowStoneGenerator(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, true);
    }
}

