/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Smoker;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class HeavySteamGenerator
extends Device {
    private static final long serialVersionUID = -39294092888451315L;
    private transient BlockFace faceDir;
    private static String classSpacedNamed = "Heavy Steam Generator";
    public static int steamNeeded = 40;

    public HeavySteamGenerator(Location loc) {
        super(loc);
        this.setMaterial("SMOKER");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.setPowerGen(120);
        this.setUseUI(true);
        this.addLiquidType(Device.LiquidType.STEAM, 100);
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Convert mass steam into power.");
        lore.add("- Requires steam piping connection.");
        lore.add("- Placing grindstones on the left and right");
        lore.add("- Will increase power efficiency");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Stored Steam", this.getStoredLiquid(Device.LiquidType.STEAM) + "/100"));
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Power Generation", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            this.setProducingPower(false);
            if (this.getStoredLiquid(Device.LiquidType.STEAM) >= steamNeeded) {
                Block block = this.getLocation().getBlock();
                this.removeLiquid(Device.LiquidType.STEAM, steamNeeded);
                this.getGrid().logLiquid(Device.LiquidType.STEAM, -steamNeeded);
                if (this.faceDir == null) {
                    Smoker smoker2 = (Smoker)block.getState();
                    Directional directionalData = (Directional)smoker2.getBlockData();
                    this.faceDir = directionalData.getFacing();
                }
                double eff = 0.34;
                boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance);
                boolean playerReallyClose = TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance);
                this.steamSmoke(block.getLocation(), playerNear);
                if (playerReallyClose) {
                    block.getWorld().playSound(block.getLocation(), Sound.BLOCK_SMOKER_SMOKE, 1.0f, 1.0f);
                }
                if (block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 90)).getType().equals((Object)Material.GRINDSTONE)) {
                    eff += 0.33;
                    this.steamSmoke(block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 90)).getLocation(), playerNear);
                }
                if (block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 270)).getType().equals((Object)Material.GRINDSTONE)) {
                    eff += 0.33;
                    this.steamSmoke(block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 270)).getLocation(), playerNear);
                }
                this.getGrid().addPower(this, (int)((double)this.getPowerGen() * eff));
                this.setProducingPower(true);
            }
        }
    }

    private void steamSmoke(final Location loc, boolean nearby) {
        if (!nearby) {
            return;
        }
        loc.add(0.5, 1.0, 0.5);
        int i = 0;
        while (i < 3) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    loc.add(0.0, 0.33, 0.0);
                    if (!loc.getBlock().getType().isSolid()) {
                        loc.getWorld().spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, loc, 1, 0.0, 0.0, 0.0, 1.0E-11);
                    }
                }
            }, 10L * (long)i);
            ++i;
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, HeavySteamGenerator.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new HeavySteamGenerator(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit", 4));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 5));
        RecipeUtils.addDefaultRecipe(new HeavySteamGenerator(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 2;
    }
}

