/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Generators.HeatExchanger;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class NuclearReactor
extends Device {
    private static final long serialVersionUID = -39814092254451315L;
    private static String classSpacedNamed = "Nuclear Reactor";
    private int heatLeft = 0;
    public static int neededWater = 10;
    public static int producedHeat = 4000;
    private transient HashSet<HeatExchanger> exchangers = new HashSet();

    public NuclearReactor(Location loc) {
        super(loc);
        this.setMaterial("BEACON");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setIdlePower(0);
        this.setActionPower(0);
        this.setUseUI(true);
        this.addLiquidType(Device.LiquidType.WATER, 100);
        this.useAutoSlots();
        this.useAutoUI();
        this.setUseUI(true);
        this.updateDeviceHeadItem();
        this.displayRotationOffset = 90;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Requires water to keep the reactor cool.");
        lore.add("- Transfers heat to adjacent heat exchangers.");
        lore.add("- Requires Uranium Fuel Cells to run.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Heat", this.heatLeft + "/" + producedHeat));
        lore.add(MineUtil.colon(" Stored Water", this.getStoredLiquid(Device.LiquidType.WATER) + "/100"));
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Heat Generation", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            if (this.exchangers == null) {
                this.exchangers = new HashSet();
            }
            if (this.getStoredLiquid(Device.LiquidType.WATER) < neededWater) {
                this.setFailReason("Need more water");
                return;
            }
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            if (this.heatLeft > 0) {
                this.removeLiquid(Device.LiquidType.WATER, neededWater);
                if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance)) {
                    this.exchangers.clear();
                    Block block = this.getLocation().getBlock();
                    Device nDevice = Device.getDevice(block.getRelative(BlockFace.NORTH));
                    Device sDevice = Device.getDevice(block.getRelative(BlockFace.SOUTH));
                    Device eDevice = Device.getDevice(block.getRelative(BlockFace.EAST));
                    Device wDevice = Device.getDevice(block.getRelative(BlockFace.WEST));
                    Device dDevice = Device.getDevice(block.getRelative(BlockFace.DOWN));
                    Device uDevice = Device.getDevice(block.getRelative(BlockFace.UP));
                    if (nDevice != null && nDevice instanceof HeatExchanger) {
                        HeatExchanger he = (HeatExchanger)nDevice;
                        this.exchangers.add(he);
                    }
                    if (sDevice != null && sDevice instanceof HeatExchanger) {
                        HeatExchanger he = (HeatExchanger)sDevice;
                        this.exchangers.add(he);
                    }
                    if (eDevice != null && eDevice instanceof HeatExchanger) {
                        HeatExchanger he = (HeatExchanger)eDevice;
                        this.exchangers.add(he);
                    }
                    if (wDevice != null && wDevice instanceof HeatExchanger) {
                        HeatExchanger he = (HeatExchanger)wDevice;
                        this.exchangers.add(he);
                    }
                    if (dDevice != null && dDevice instanceof HeatExchanger) {
                        HeatExchanger he = (HeatExchanger)dDevice;
                        this.exchangers.add(he);
                    }
                    if (uDevice != null && uDevice instanceof HeatExchanger) {
                        HeatExchanger he = (HeatExchanger)uDevice;
                        this.exchangers.add(he);
                    }
                }
                boolean sentHeat = false;
                for (HeatExchanger he : this.exchangers) {
                    if (this.heatLeft > 2) {
                        he.giveHeat(2);
                        this.heatLeft -= 2;
                        sentHeat = true;
                        continue;
                    }
                    he.giveHeat(1);
                    --this.heatLeft;
                    sentHeat = true;
                }
                if (!sentHeat) {
                    --this.heatLeft;
                }
                return;
            }
            ItemStack fuelCell = null;
            for (ItemStack stack : this.getInputItems()) {
                if (!TUItems.isValid(stack) || !MineItems.isIndustrialItem(stack, "Uranium Fuel Cell")) continue;
                fuelCell = stack;
                break;
            }
            if (fuelCell != null) {
                fuelCell.setAmount(fuelCell.getAmount() - 1);
                this.getInventory().setItem(this.getOutputSlot(), MineItems.getIndustrialItem("Used Uranium Fuel Cell"));
                this.removeLiquid(Device.LiquidType.WATER, 50);
                this.getGrid().logLiquid(Device.LiquidType.WATER, -50);
                this.heatLeft = producedHeat;
            } else {
                this.setFailReason("Need Uranium Fuel Cell");
                return;
            }
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, NuclearReactor.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new NuclearReactor(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Processing Unit", 5));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 4));
        RecipeUtils.addDefaultRecipe(new NuclearReactor(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public int getGridScore() {
        return 5;
    }
}

