/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import com.MT.xxxtrigger50xxx.StoryTeller;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class SolarPanel
extends Device {
    private static final long serialVersionUID = -3929409797254451315L;
    private StoryTeller.CloudEnviroment cEnv;
    private int debris = 0;
    private int lastLight = 0;
    private static String classSpacedNamed = "Solar Panel";

    public SolarPanel(Location loc) {
        super(loc);
        this.setMaterial("DAYLIGHT_DETECTOR");
        this.deviceName = "Solar Panel";
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setUseUI(true);
        this.setGridRange(5);
        this.setStoreForm(false);
        this.setPowerGen(3);
        this.updateDeviceHeadItem();
        this.displayYScaleShift = -1.25f;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This needs clear sky access! Light level 15!");
        lore.add("- Creates max power output during mid day.");
        lore.add("- Power generation can shift up and down.");
        lore.add("- This is due to cloud coverage.");
        lore.add("- This can be avoided by going above the clouds!");
        lore.add("- This device can still be used as a daylight detector!");
        return lore;
    }

    @Override
    public void postCreate(boolean isFirstTime) {
        if (this.cEnv == null) {
            double temp = this.getLocation().getBlock().getTemperature();
            this.cEnv = StoryTeller.CloudEnviroment.TEMPERATE;
            if (temp <= 0.3) {
                this.cEnv = StoryTeller.CloudEnviroment.COLD;
            }
            if (temp >= 1.0) {
                this.cEnv = StoryTeller.CloudEnviroment.HOT;
            }
            this.lastLight = this.getLocation().getBlock().getLightFromSky();
        }
    }

    @Override
    public void updateUI() {
        int i = 0;
        while (i <= 8) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            this.getInventory().setItem(i + 18, MainMenu.createGoldPane());
            ++i;
        }
        this.getInventory().setItem(10, this.createCloudStack());
        this.getInventory().setItem(12, this.createTempStack());
        this.getInventory().setItem(14, this.createDebrisStack());
        this.getInventory().setItem(16, this.outputStack());
    }

    private ItemStack createCloudStack() {
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Current Clouds", MineItems.whiteBold() + MineMain.storyteller.getCloudCoverage().toString().replace("_", " ")));
        lore.add(MineUtil.colon(" Current Cloud Level", "" + MineMain.storyteller.getCurrentCloudLevel(this.getCloudEnviroment())));
        Material material = Material.WHITE_WOOL;
        switch (MineMain.storyteller.getCloudCoverage()) {
            case BROKEN_CLOUDS: {
                material = Material.GRAY_WOOL;
                break;
            }
            case MOSTLY_CLEAR: {
                material = Material.LIGHT_GRAY_WOOL;
                break;
            }
            case MOSTLY_CLOUDLY: {
                material = Material.GRAY_WOOL;
                break;
            }
            case OVERCAST: {
                material = Material.BLACK_WOOL;
                break;
            }
            case PARTLY_CLOUDY: {
                material = Material.GRAY_WOOL;
                break;
            }
            case SCATTERED_CLOUDS: {
                material = Material.LIGHT_GRAY_WOOL;
                break;
            }
        }
        return TUItems.createItem(material, MineItems.whiteBold() + "Cloud Coverage", lore);
    }

    private ItemStack createTempStack() {
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Enviroment", this.cEnv.toString()));
        Material material = Material.GRASS_BLOCK;
        switch (this.cEnv) {
            case COLD: {
                material = Material.ICE;
                lore.add(String.valueOf(ChatColor.RED) + " +1 Cloud Level");
                break;
            }
            case HOT: {
                material = Material.SAND;
                lore.add(String.valueOf(ChatColor.GREEN) + " -1 Cloud Level");
                break;
            }
        }
        return TUItems.createItem(material, MineItems.whiteBold() + "Cloud Enviroment", lore);
    }

    private ItemStack createDebrisStack() {
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Debris", this.debris + "/100"));
        Material material = Material.DIRT;
        String debrisType = "Dust";
        switch (this.cEnv) {
            case COLD: {
                material = Material.SNOW_BLOCK;
                debrisType = "Snow";
                break;
            }
            case HOT: {
                material = Material.SAND;
                debrisType = "Sand";
                break;
            }
        }
        if (this.debris >= 25) {
            lore.add(String.valueOf(ChatColor.RED) + " -1 Power Output - Clean With Brush");
        }
        if (this.debris >= 75) {
            lore.add(String.valueOf(ChatColor.RED) + " -2 Power Output - Clean With Brush");
        }
        return TUItems.createItem(material, MineItems.whiteBold() + debrisType + " Buildup", lore);
    }

    private ItemStack outputStack() {
        int clouds;
        int power = this.getSolarGen();
        if (power < 0) {
            power = 0;
        }
        ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Current Output", "" + power), " ");
        World world = this.getLocationREADONLY().getBlock().getWorld();
        if (world.getTime() >= 12000L) {
            lore.add(String.valueOf(ChatColor.RED) + " 0 Power, Nighttime");
        } else {
            int sunPower = 0;
            if (world.getTime() >= 0L) {
                ++sunPower;
            }
            if (world.getTime() >= 2000L) {
                ++sunPower;
            }
            if (world.getTime() >= 4000L) {
                ++sunPower;
            }
            if (world.getTime() >= 8000L) {
                --sunPower;
            }
            if (world.getTime() >= 10000L) {
                --sunPower;
            }
            lore.add(String.valueOf(ChatColor.GREEN) + " +" + sunPower + " Power - Day");
        }
        if (world.hasStorm()) {
            lore.add(String.valueOf(ChatColor.RED) + " -Storm, Power/2");
        }
        if (this.debris >= 25) {
            lore.add(String.valueOf(ChatColor.RED) + " -1 Power Output - Clean With Brush");
        }
        if (this.debris >= 75) {
            lore.add(String.valueOf(ChatColor.RED) + " -2 Power Output - Clean With Brush");
        }
        if (this.getLocationREADONLY().getY() < (double)MineMain.cloudYLevel && (clouds = MineMain.storyteller.getCurrentCloudLevel(this.getCloudEnviroment())) > 0) {
            lore.add(String.valueOf(ChatColor.RED) + " -" + clouds + " Power Output - From Current Clouds");
        }
        return TUItems.createItem(Material.YELLOW_CONCRETE, MineItems.whiteBold() + "Power Output", lore);
    }

    public int getDebris() {
        return this.debris;
    }

    public void setDebris(int debris) {
        this.debris = debris;
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            if (this.debris < 100 && MineMain.solarDustRate != 0.0) {
                int chance = 1;
                if (this.cEnv != null) {
                    if (this.cEnv.equals((Object)StoryTeller.CloudEnviroment.COLD)) {
                        chance += 2;
                    }
                    if (this.cEnv.equals((Object)StoryTeller.CloudEnviroment.HOT)) {
                        chance += 3;
                    }
                }
                if (TUMaths.rollRange(1.0, 500.0 * MineMain.solarDustRate) <= (double)chance) {
                    ++this.debris;
                }
            }
            if (MinetorioListener.isPlayerNearby2DOPT(this.getLocationREADONLY(), 8.0)) {
                this.lastLight = this.getLocationREADONLY().getBlock().getLightFromSky();
            }
            if (this.lastLight == 15 && this.cEnv != null) {
                this.setProducingPower(false);
                int power = this.getSolarGen();
                if (power > 0) {
                    this.getGrid().addPower(this, power);
                    if (power > 0) {
                        this.setProducingPower(true);
                    }
                }
            }
        }
    }

    public int getSolarGen() {
        int power = 0;
        World world = this.getLocationREADONLY().getBlock().getWorld();
        if (world.getTime() >= 0L) {
            ++power;
        }
        if (world.getTime() >= 2000L) {
            ++power;
        }
        if (world.getTime() >= 4000L) {
            ++power;
        }
        if (world.getTime() >= 8000L) {
            --power;
        }
        if (world.getTime() >= 10000L) {
            --power;
        }
        if (world.getTime() >= 12000L) {
            power = 0;
        }
        if (power > 0 && world.hasStorm()) {
            power /= 2;
        }
        if (this.getLocationREADONLY().getY() < (double)MineMain.cloudYLevel) {
            power -= MineMain.storyteller.getCurrentCloudLevel(this.getCloudEnviroment());
        }
        if (this.debris >= 25) {
            --power;
        }
        if (this.debris >= 75) {
            power -= 2;
        }
        power = this.planetAdjustment(power);
        return power;
    }

    public int planetAdjustment(int power) {
        Planet planet = PlanetHandler.getPlanetByWorld(this.getLocationREADONLY().getWorld().getName());
        if (planet != null) {
            return (int)((double)power * planet.getSunDistance());
        }
        return power;
    }

    public StoryTeller.CloudEnviroment getCloudEnviroment() {
        return this.cEnv;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, SolarPanel.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new SolarPanel(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Copper Cable", 2));
        ings.add(new ItemStack(Material.GLASS));
        ings.add(new ItemStack(Material.QUARTZ));
        ings.add(new ItemStack(Material.REDSTONE));
        RecipeUtils.addDefaultRecipe(new SolarPanel(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

