/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Smoker;
import org.bukkit.block.data.Directional;

public class SteamEngine
extends Device {
    private static final long serialVersionUID = -3929409797254451315L;
    private transient BlockFace faceDir;
    public static int neededSteam = 5;

    public SteamEngine(Location loc) {
        super(loc);
        this.setMaterial("SMOKER");
        this.deviceName = "Steam Engine";
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.addLiquidType(Device.LiquidType.STEAM, 100);
        this.setPowerGen(15);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.add(0);
        slots.add(1);
        this.setClickableSlots(slots);
        this.updateDeviceHeadItem();
        if (loc != null) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    SteamEngine.this.updateUIIcon();
                }
            }, 1L);
        }
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.RED) + "- 5\ud83d\udca8");
        lore.add("- Convert steam into power.");
        lore.add("- Requires steam piping connection.");
        lore.add("- Placing grindstones on the left and right");
        lore.add("- Will increase power efficiency");
        return lore;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void action() {
        if (this.getGrid() != null) {
            Smoker smoker;
            BlockState blockState;
            boolean playerNear = MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.nearDistance);
            boolean playerReallyClose = MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.closeDistance);
            Block block = this.getLocation().getBlock();
            if (playerReallyClose && (blockState = block.getState()) instanceof Smoker && (smoker = (Smoker)blockState).getInventory().getViewers().size() > 0) {
                this.updateUIIcon();
            }
            this.setProducingPower(false);
            if (this.getStoredLiquid(Device.LiquidType.STEAM) >= neededSteam) {
                this.removeLiquid(Device.LiquidType.STEAM, neededSteam);
                this.getGrid().logLiquid(Device.LiquidType.STEAM, -neededSteam);
                if (this.faceDir == null) {
                    Smoker smoker2 = (Smoker)block.getState();
                    Directional directionalData = (Directional)smoker2.getBlockData();
                    this.faceDir = directionalData.getFacing();
                }
                double eff = 0.34;
                this.steamSmoke(block.getLocation(), playerNear);
                if (playerReallyClose) {
                    block.getWorld().playSound(block.getLocation(), Sound.BLOCK_SMOKER_SMOKE, 1.0f, 1.0f);
                }
                if (block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 90)).getType().equals((Object)Material.GRINDSTONE)) {
                    eff += 0.33;
                    this.steamSmoke(block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 90)).getLocation(), playerNear);
                }
                if (block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 270)).getType().equals((Object)Material.GRINDSTONE)) {
                    eff += 0.33;
                    this.steamSmoke(block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 270)).getLocation(), playerNear);
                }
                this.getGrid().addPower(this, (int)((double)this.getPowerGen() * eff));
                this.setProducingPower(true);
            }
        }
    }

    private void updateUIIcon() {
        Block block = this.getLocationREADONLY().getBlock();
        BlockState blockState = block.getState();
        if (blockState instanceof Smoker) {
            Smoker smoker = (Smoker)blockState;
            ArrayList<String> lore = TUItems.basicLore(MineUtil.colon(" Steam", String.valueOf(this.getStoredLiquid(Device.LiquidType.STEAM)) + "/" + this.getMaxLiquid(Device.LiquidType.STEAM)));
            if (this.getStoredLiquid(Device.LiquidType.STEAM) < neededSteam) {
                lore.add(String.valueOf(ChatColor.RED) + " - Need more steam!");
            }
            smoker.getInventory().setResult(TUItems.setModelData(TUItems.createItem(Material.GLASS, String.valueOf(MineItems.goldBold()) + "Stored Steam", lore), 9528));
        }
    }

    private void steamSmoke(final Location loc, boolean nearby) {
        if (!nearby) {
            return;
        }
        loc.add(0.5, 1.0, 0.5);
        int i = 0;
        while (i < 3) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    loc.add(0.0, 0.33, 0.0);
                    if (!loc.getBlock().getType().isSolid()) {
                        loc.getWorld().spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, loc, 1, 0.0, 0.0, 0.0, 1.0E-11);
                    }
                }
            }, 10L * (long)i);
            ++i;
        }
    }
}

