/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Generators;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pump;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Smoker;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Openable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TidalGenerator
extends Device {
    static final int load = 0;
    private static final long serialVersionUID = -3929409111254451315L;
    private transient BlockFace faceDir;
    private int waterSize = 0;
    private int lastPower = 0;
    private static int requiredWater = 50;
    private transient Biome biome;
    private transient boolean isFlooded = false;
    private double lastEff = 0.0;
    private double lastTidalLoss = 0.0;
    private int lastTidalCount = 0;
    private int rescan = 0;
    private transient World lastWorld;

    public TidalGenerator(Location loc) {
        super(loc);
        this.setMaterial("SMOKER");
        this.deviceName = "Tidal Generator";
        this.setActionTimer(2);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setStoreForm(false);
        this.setPowerGen(10);
        this.setUseUI(true);
        this.setDeviceCrowding(true);
        this.crowdingDistance = 15;
        this.waterSize = Pump.calculateLiquidBlocks(loc, requiredWater, Material.WATER, 5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Needs water on left and right side");
        lore.add("- Place iron trapdoors on the left and right");
        lore.add("- Works best in oceans & well in rivers.");
        lore.add("- Generates the most power at midnight and midday.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> lore = TUItems.basicLore(String.valueOf(ChatColor.GOLD) + " Production:" + String.valueOf(ChatColor.WHITE) + " " + this.lastPower + MineItems.getEnergyIcon() + "/" + this.getPowerGen() + MineItems.getEnergyIcon());
        int tidalLevel = (int)(this.getTidalLevel(this.lastWorld) * 100.0);
        ChatColor color = ChatColor.WHITE;
        if (tidalLevel >= 80) {
            color = ChatColor.GREEN;
        }
        if (tidalLevel <= 50) {
            color = ChatColor.YELLOW;
        }
        if (tidalLevel <= 30) {
            color = ChatColor.RED;
        }
        lore.add(MineUtil.colon(" Tidal Level", String.valueOf(color) + tidalLevel + "%"));
        if (!this.isFlooded) {
            lore.add(String.valueOf(ChatColor.RED) + " - Missing water on left or right side " + String.valueOf(ChatColor.BOLD) + "x0.0\u26a1");
        }
        if (this.waterSize < requiredWater) {
            lore.add(String.valueOf(ChatColor.YELLOW) + " - Small water source " + String.valueOf(ChatColor.BOLD) + "x" + TUMaths.roundDouble((double)this.waterSize / ((double)requiredWater * 1.0), 2) + "\u26a1");
        }
        if (this.lastEff != 1.0) {
            lore.add(String.valueOf(ChatColor.YELLOW) + " - Missing trapdoor " + String.valueOf(ChatColor.BOLD) + "x" + this.lastEff + "\u26a1");
        }
        if (this.lastTidalLoss > 0.0) {
            double conv = 1.0 - this.lastTidalLoss;
            lore.add(String.valueOf(ChatColor.YELLOW) + " - Tidal device crowding " + String.valueOf(ChatColor.BOLD) + "x" + TUMaths.roundDouble(conv, 2) + "\u26a1");
        }
        if (this.biome != null && (!this.biome.toString().contains("OCEAN") || this.biome.toString().contains("SHORE"))) {
            if (this.biome.toString().contains("RIVER")) {
                lore.add(String.valueOf(ChatColor.YELLOW) + " - River Penalty " + String.valueOf(ChatColor.BOLD) + "x0.8\u26a1");
            } else {
                lore.add(String.valueOf(ChatColor.YELLOW) + " - Still Water Penalty " + String.valueOf(ChatColor.BOLD) + "x0.5\u26a1");
            }
        }
        ItemStack powerStack = TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.goldBold()) + "Power Generation", lore);
        powerStack = TUItems.setModelData(powerStack, 9531);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        if (this.lastWorld == null) {
            this.lastWorld = this.getLocation().getWorld();
        }
        if (this.getGrid() != null) {
            Block block = this.getLocation().getBlock();
            this.setProducingPower(false);
            if (this.faceDir == null) {
                Smoker smoker2 = (Smoker)block.getState();
                Directional directionalData = (Directional)smoker2.getBlockData();
                this.faceDir = directionalData.getFacing();
                this.biome = block.getBiome();
            }
            boolean isPlayerNear = TUMaths.isPlayerNearby(block.getLocation(), MineMain.distantDistance);
            final Block leftBlock = block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 90));
            final Block rightBlock = block.getRelative(TUMaths.rotateBlockFace(this.faceDir, 270));
            if (isPlayerNear) {
                boolean bl = this.isFlooded = TidalGenerator.isBlockWaterlogged(leftBlock) && TidalGenerator.isBlockWaterlogged(rightBlock);
            }
            if (!this.isFlooded) {
                return;
            }
            double eff = 0.34;
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 8.0)) {
                if (leftBlock.getType().equals((Object)Material.IRON_TRAPDOOR)) {
                    eff += 0.33;
                    if (isPlayerNear) {
                        TidalGenerator.setTrapdoorState(leftBlock, true);
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                TidalGenerator.setTrapdoorState(leftBlock, false);
                            }
                        }, 30L);
                    }
                }
                if (rightBlock.getType().equals((Object)Material.IRON_TRAPDOOR)) {
                    eff += 0.33;
                    if (isPlayerNear) {
                        TidalGenerator.setTrapdoorState(rightBlock, true);
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                TidalGenerator.setTrapdoorState(rightBlock, false);
                            }
                        }, 30L);
                    }
                }
            } else {
                eff = this.lastEff;
            }
            if (isPlayerNear) {
                this.lastTidalCount = Device.getNearbyDevicesByType(this.getLocation(), 15, "Tidal Generator").size() - 1;
                --this.rescan;
                if (this.rescan <= 0) {
                    this.waterSize = Pump.calculateLiquidBlocks(this.getLocation(), requiredWater, Material.WATER, 5);
                    this.rescan = 30;
                }
            }
            double tidalLoss = 0.0;
            if (this.lastTidalCount > 0) {
                tidalLoss = (double)this.lastTidalCount * 0.1;
                if (tidalLoss > 1.0) {
                    tidalLoss = 1.0;
                }
                this.lastTidalLoss = tidalLoss;
            }
            this.lastEff = eff;
            int powerGen = (int)((double)this.getPowerGen() * eff);
            powerGen = (int)((double)powerGen * ((double)this.waterSize / ((double)requiredWater * 1.0)));
            if (!this.biome.toString().contains("OCEAN")) {
                powerGen = this.biome.toString().contains("RIVER") || this.biome.toString().contains("SHORE") ? (int)((double)powerGen * 0.8) : (int)((double)powerGen * 0.5);
            }
            powerGen = (int)((double)powerGen - (double)powerGen * tidalLoss);
            double tidalLevel = this.planetAdjustment(this.getTidalLevel(this.lastWorld));
            this.lastPower = powerGen = (int)((double)powerGen * tidalLevel);
            this.getGrid().addPower(this, powerGen);
            this.setProducingPower(true);
        }
    }

    public double planetAdjustment(double tidalLevel) {
        Planet planet = PlanetHandler.getPlanetByWorld(this.getLocationREADONLY().getWorld().getName());
        if (planet != null) {
            return tidalLevel * planet.getTidalLevels();
        }
        return tidalLevel;
    }

    public double getTidalLevel(World world) {
        if (world == null) {
            return 1.0;
        }
        long time = world.getTime();
        if ((time %= 24000L) >= 0L && time < 6000L) {
            return (double)time / 6000.0;
        }
        if (time >= 6000L && time < 12000L) {
            return 1.0 - (double)(time - 6000L) / 6000.0;
        }
        if (time >= 12000L && time < 18000L) {
            return (double)(time - 12000L) / 6000.0;
        }
        return 1.0 - (double)(time - 18000L) / 6000.0;
    }

    private static void setTrapdoorState(Block block, boolean open) {
        if (block.getType() == Material.IRON_TRAPDOOR) {
            Openable openable = (Openable)block.getBlockData();
            openable.setOpen(open);
            block.setBlockData((BlockData)openable);
        }
    }

    public static boolean isBlockWaterlogged(Block block) {
        if (block.getType().equals((Object)Material.WATER)) {
            return true;
        }
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Waterlogged) {
            Waterlogged waterlogged = (Waterlogged)blockData;
            return waterlogged.isWaterlogged();
        }
        return false;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put("Tidal Generator", TidalGenerator.class);
        ItemMenu.registerDeviceStack("Tidal Generator", ItemMenu.Category.POWER, new TidalGenerator(null).getDeviceStack(), true);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.SMOOTH_STONE));
        ings.add(MineItems.getIndustrialItem("Copper Cable", 2));
        RecipeUtils.addDefaultRecipe(new TidalGenerator(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

