/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.xxxtrigger50xxx.Devices.Belt;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class Lift {
    public static HashMap<Location, Lift> lifts = new HashMap();
    private Mover mover;
    private Location location;
    private Location leftLocation;
    private Location rightLocation;
    private ItemStack leftStack;
    private ItemStack rightStack;
    private Entity leftItem;
    private Entity rightItem;
    private boolean addedTicket = false;
    private boolean removed = false;
    public ItemDisplay leftTransit;
    public ItemDisplay rightTransit;
    public static boolean classicItems = false;
    public static boolean animateLiftMovement = true;
    public static LiftEntityType liftType = LiftEntityType.DISPLAY;

    public Lift(Mover mover, Location location) {
        this.setMover(mover);
        this.setLocation(location);
        this.leftLocation = location.clone().add(0.5, 0.5, 0.75);
        this.rightLocation = location.clone().add(0.5, 0.5, 0.25);
        lifts.put(location.clone(), this);
    }

    public Mover getMover() {
        return this.mover;
    }

    public void setMover(Mover mover) {
        this.mover = mover;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public ItemStack getLeftStack() {
        return this.leftStack;
    }

    public void setLeftStack(ItemStack leftStack) {
        if (this.removed) {
            return;
        }
        if (leftStack == null && this.leftItem != null) {
            this.leftItem.remove();
            this.leftItem = null;
        }
        this.leftStack = leftStack;
    }

    public void setLeftStackNoRemoval(ItemStack leftStack) {
        this.leftStack = leftStack;
    }

    public void setRightStackNoRemoval(ItemStack stack) {
        this.rightStack = stack;
    }

    public void removeLeftItem() {
        if (this.leftItem != null) {
            this.leftItem.remove();
            this.leftItem = null;
        }
    }

    public void removeRightItem() {
        if (this.rightItem != null) {
            this.rightItem.remove();
            this.rightItem = null;
        }
    }

    public ItemStack getRightStack() {
        return this.rightStack;
    }

    public void setRightStack(ItemStack rightStack) {
        if (this.removed) {
            return;
        }
        if (rightStack == null && this.rightItem != null) {
            this.rightItem.remove();
            this.rightItem = null;
        }
        this.rightStack = rightStack;
    }

    public Location getLeftLocation() {
        return this.leftLocation;
    }

    public Location getRightLocation() {
        return this.rightLocation;
    }

    public boolean isLeftCloser(Location from) {
        return from.distanceSquared(this.leftLocation) < from.distanceSquared(this.rightLocation);
    }

    public ItemStack getClosestStack(Location from, boolean override) {
        if (from.distanceSquared(this.leftLocation) < from.distanceSquared(this.rightLocation)) {
            if (this.leftStack != null) {
                return this.leftStack;
            }
            if (this.leftTransit != null) {
                return this.leftTransit.getItemStack();
            }
            if (override && this.rightStack != null) {
                return this.rightStack;
            }
            if (override && this.rightTransit != null) {
                return this.rightTransit.getItemStack();
            }
        } else {
            if (this.rightStack != null) {
                return this.rightStack;
            }
            if (this.rightTransit != null) {
                return this.rightTransit.getItemStack();
            }
            if (override && this.leftStack != null) {
                return this.leftStack;
            }
            if (override && this.leftTransit != null) {
                return this.leftTransit.getItemStack();
            }
        }
        return null;
    }

    public void insertStack(Location from, ItemStack stack, boolean override) {
        if (from.distanceSquared(this.leftLocation) < from.distanceSquared(this.rightLocation)) {
            if (this.leftStack == null) {
                this.setLeftStack(stack);
            } else if (override && this.rightStack == null) {
                this.setRightStack(stack);
            }
        } else if (this.rightStack == null) {
            this.setRightStack(stack);
        } else if (override && this.leftStack == null) {
            this.setLeftStack(stack);
        }
        this.updateDisplay();
    }

    public static Lift getLift(Location location) {
        return lifts.getOrDefault(location, null);
    }

    public void updateDisplay() {
        if (this.removed) {
            if (this.leftItem != null) {
                this.leftItem.remove();
                this.leftItem = null;
            }
            if (this.rightItem != null) {
                this.rightItem.remove();
                this.rightItem = null;
            }
            return;
        }
        if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), MineMain.beltDistance)) {
            if (!this.addedTicket) {
                this.addedTicket = this.getLocation().getChunk().addPluginChunkTicket(MineMain.getPlugin());
            }
            this.spawnLeftItem();
            this.spawnRightItem();
        } else {
            if (this.leftItem != null) {
                this.leftItem.remove();
                this.leftItem = null;
            }
            if (this.rightItem != null) {
                this.rightItem.remove();
                this.rightItem = null;
            }
            if (this.addedTicket) {
                this.getLocation().getChunk().removePluginChunkTicket(MineMain.getPlugin());
                this.addedTicket = false;
            }
        }
    }

    public void tickLift() {
        this.updateDisplay();
    }

    public void removeDisplay() {
        if (this.leftItem != null) {
            this.leftItem.remove();
            this.leftItem = null;
        }
        if (this.rightItem != null) {
            this.rightItem.remove();
            this.rightItem = null;
        }
    }

    public void spawnLeftItem() {
        if (this.getLeftStack() != null && this.leftItem == null) {
            Location loc = this.getLeftLocation();
            ItemStack convStack = this.getLeftStack();
            if (liftType.equals((Object)LiftEntityType.DISPLAY)) {
                ItemDisplay display = (ItemDisplay)loc.getWorld().spawn(loc, ItemDisplay.class);
                MineUtil.setDisposableEntity((Entity)display);
                display.setTransformation(Lift.getDisplayScale(display, convStack));
                display.setItemStack(convStack);
                display.setMetadata("MT-LIFTDISPLAY", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)true));
                display.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
                this.leftItem = display;
            }
            if (liftType.equals((Object)LiftEntityType.ITEM)) {
                Item item = loc.getWorld().dropItem(loc, convStack);
                item.setMetadata(MineMain.noPickupMetaValue, (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)MineMain.noPickupMetaValue));
                item.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
                item.setVelocity(new Vector());
                item.setGravity(false);
                this.leftItem = item;
                Belt.noPickups.add(item);
            }
            if (this.leftItem != null) {
                this.leftItem.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
            }
        }
    }

    public void spawnRightItem() {
        if (this.getRightStack() != null && this.rightItem == null) {
            Location loc = this.getRightLocation();
            ItemStack convStack = this.getRightStack();
            if (liftType.equals((Object)LiftEntityType.DISPLAY)) {
                ItemDisplay display = (ItemDisplay)loc.getWorld().spawn(loc, ItemDisplay.class);
                MineUtil.setDisposableEntity((Entity)display);
                display.setTransformation(Lift.getDisplayScale(display, convStack));
                display.setItemStack(convStack);
                display.setMetadata("MT-LIFTDISPLAY", (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)true));
                this.rightItem = display;
            }
            if (liftType.equals((Object)LiftEntityType.ITEM)) {
                Item item = loc.getWorld().dropItem(loc, convStack);
                item.setMetadata(MineMain.noPickupMetaValue, (MetadataValue)new FixedMetadataValue(MineMain.getPlugin(), (Object)MineMain.noPickupMetaValue));
                item.setVelocity(new Vector());
                item.setGravity(false);
                this.rightItem = item;
                Belt.noPickups.add(item);
            }
            if (this.rightItem != null) {
                this.rightItem.getPersistentDataContainer().set(Device.iconStackKey, PersistentDataType.BOOLEAN, (Object)true);
            }
        }
    }

    public void releaseItems(boolean popEffect) {
        if (this.leftItem != null && !this.leftItem.isDead()) {
            this.getLocation().getWorld().dropItem(this.leftItem.getLocation(), this.getLeftStack());
            this.leftItem.remove();
        }
        if (this.rightItem != null && !this.rightItem.isDead()) {
            this.getLocation().getWorld().dropItem(this.rightItem.getLocation(), this.getRightStack());
            this.rightItem.remove();
        }
    }

    public void removeLift() {
        lifts.remove(this.getLocation());
        this.setLeftStack(null);
        this.setRightStack(null);
        if (this.leftTransit != null) {
            this.leftTransit.remove();
        }
        if (this.rightTransit != null) {
            this.rightTransit.remove();
        }
        this.removed = true;
    }

    public static Transformation getDisplayScale(ItemDisplay display, ItemStack convStack) {
        Material type;
        Transformation form = display.getTransformation();
        double scale = 0.225;
        if (classicItems) {
            scale = 0.5;
        }
        if (!(!(type = convStack.getType()).isBlock() || type.equals((Object)Material.REDSTONE_TORCH) || type.equals((Object)Material.REPEATER) || type.equals((Object)Material.COMPARATOR) || type.equals((Object)Material.REDSTONE_TORCH) || type.equals((Object)Material.TORCH) || type.equals((Object)Material.LEVER))) {
            scale = 0.125;
        }
        if (convStack.getType().equals((Object)Material.PLAYER_HEAD)) {
            scale = 0.3;
        }
        if (!classicItems) {
            form.getTranslation().y = -0.225f;
        }
        if (!classicItems) {
            form.getLeftRotation().x = 1.0f;
        }
        form.getScale().set(scale);
        return form;
    }

    public static void loadLiftConfig(Plugin plugin) {
        String mode = plugin.getConfig().getString("Item Mode");
        LiftEntityType[] liftEntityTypeArray = LiftEntityType.values();
        int n = liftEntityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LiftEntityType let = liftEntityTypeArray[n2];
            if (let.toString().equals(mode)) {
                liftType = let;
                break;
            }
            ++n2;
        }
        animateLiftMovement = plugin.getConfig().getBoolean("Smooth Movement");
        Mover.maxLift = plugin.getConfig().getInt("Lift Distance");
    }

    public static enum LiftEntityType {
        ITEM,
        DISPLAY;

    }
}

