/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Liquids;

import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Generators.HeatExchanger;
import com.MT.xxxtrigger50xxx.Devices.Liquids.BarrelPump;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Boiler;
import com.MT.xxxtrigger50xxx.Devices.Liquids.Pump;
import com.MT.xxxtrigger50xxx.Devices.Manufactoring.OilRefinery;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public class LiquidUtil {
    private static NamespacedKey oilKey = new NamespacedKey(MineMain.getPlugin(), "OilChunk");

    public static HashSet<Device> getConnectedDevices(Block source, Device.LiquidType liquidType) {
        HashSet<Device> attachedDevices = new HashSet<Device>();
        ArrayList<BlockFace> faces = new ArrayList<BlockFace>();
        faces.add(BlockFace.UP);
        faces.add(BlockFace.DOWN);
        faces.add(BlockFace.EAST);
        faces.add(BlockFace.WEST);
        faces.add(BlockFace.NORTH);
        faces.add(BlockFace.SOUTH);
        HashSet<Block> scannedPiping = new HashSet<Block>();
        ArrayList<Block> unscannedPiping = new ArrayList<Block>();
        block0: for (BlockFace face : faces) {
            Block sourceBlock = source.getRelative(face);
            if (!LiquidUtil.isPipeBlock(sourceBlock)) continue;
            Material wallMat = sourceBlock.getType();
            Material junctionMat = LiquidUtil.getJunctionMaterial(wallMat);
            unscannedPiping.add(sourceBlock);
            int maxScans = 200;
            while (unscannedPiping.size() > 0) {
                for (Block block : new ArrayList(unscannedPiping)) {
                    scannedPiping.add(block);
                    unscannedPiping.remove(block);
                    LiquidUtil.addCardinalPipes(block, unscannedPiping, scannedPiping, attachedDevices, liquidType, wallMat, junctionMat);
                    --maxScans;
                }
                if (maxScans <= 0) continue block0;
            }
        }
        return attachedDevices;
    }

    public static void pulseConnectedDevices(final Player player, final Device liquidMover) {
        if (liquidMover != null) {
            long delay = -1L;
            if (liquidMover instanceof Pump) {
                Pump pump = (Pump)liquidMover;
                delay = pump.getExtractionType().equals((Object)Device.LiquidType.WATER) ? LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.WATER) : LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.OIL);
            }
            if (liquidMover instanceof HeatExchanger) {
                delay = LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.STEAM);
            }
            if (liquidMover instanceof BarrelPump) {
                BarrelPump liqMover = (BarrelPump)liquidMover;
                delay = LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), liqMover.getTargetLiquidType());
            }
            if (liquidMover instanceof Boiler) {
                delay = LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.STEAM);
            }
            if (liquidMover instanceof OilRefinery) {
                OilRefinery liqMover = (OilRefinery)liquidMover;
                String recipe = liqMover.getRecipeName();
                if (recipe.equals("Oil Cracking")) {
                    delay = LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.PETROL);
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.HEAVYOIL);
                        }
                    }, 10L);
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.LIGHTOIL);
                        }
                    }, 20L);
                    delay += 15L;
                }
                if (recipe.equals("Heavy Oil Cracking")) {
                    delay = LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.LIGHTOIL);
                }
                if (recipe.equals("Light Oil Cracking")) {
                    delay = LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.PETROL);
                }
                if (recipe.equals("Lubricant")) {
                    delay = LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.LUBRICANT);
                }
                if (recipe.equals("Sulfuric Acid")) {
                    delay = LiquidUtil.pulseConnectedDevices(player, liquidMover.getLocation().getBlock(), Device.LiquidType.SULFURIC_ACID);
                }
            }
            if (delay != -1L) {
                if (!player.isOnline()) {
                    return;
                }
                if (MineItems.isIndustrialItem(player.getInventory().getItemInMainHand(), "Pipe Tool")) {
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            LiquidUtil.pulseConnectedDevices(player, liquidMover);
                        }
                    }, delay);
                }
            }
        }
    }

    public static long pulseConnectedDevices(final Player player, Block source, Device.LiquidType liquidType) {
        HashSet<Device> attachedDevices = new HashSet<Device>();
        ArrayList<BlockFace> faces = new ArrayList<BlockFace>();
        faces.add(BlockFace.UP);
        faces.add(BlockFace.DOWN);
        faces.add(BlockFace.EAST);
        faces.add(BlockFace.WEST);
        faces.add(BlockFace.NORTH);
        faces.add(BlockFace.SOUTH);
        HashMap scannedOrder = new HashMap();
        HashMap<Integer, HashSet<Device>> scannedOrderDevices = new HashMap<Integer, HashSet<Device>>();
        HashSet<Block> scannedPiping = new HashSet<Block>();
        ArrayList<Block> unscannedPiping = new ArrayList<Block>();
        int order = 0;
        scannedOrder.putIfAbsent(0, new HashSet());
        scannedOrder.putIfAbsent(1, new HashSet());
        scannedOrder.put(order, new HashSet());
        block9: for (BlockFace face : faces) {
            order = 0;
            Block sourceBlock = source.getRelative(face);
            if (!LiquidUtil.isPipeBlock(sourceBlock)) continue;
            Material wallMat = sourceBlock.getType();
            Material junctionMat = LiquidUtil.getJunctionMaterial(wallMat);
            unscannedPiping.add(sourceBlock);
            order = 1;
            ((HashSet)scannedOrder.get(order)).add(sourceBlock);
            int maxScans = 200;
            while (unscannedPiping.size() > 0) {
                scannedOrder.putIfAbsent(++order, new HashSet());
                for (Block block : new ArrayList(unscannedPiping)) {
                    scannedPiping.add(block);
                    ((HashSet)scannedOrder.get(order)).add(block);
                    unscannedPiping.remove(block);
                    HashSet preDevices = new HashSet(attachedDevices);
                    LiquidUtil.addCardinalPipes(block, unscannedPiping, scannedPiping, attachedDevices, liquidType, wallMat, junctionMat);
                    if (preDevices.size() != attachedDevices.size()) {
                        HashSet<Device> added = new HashSet<Device>(attachedDevices);
                        added.removeAll(preDevices);
                        scannedOrderDevices.put(order, added);
                    }
                    --maxScans;
                }
                if (maxScans <= 0) continue block9;
            }
        }
        BlockData liquidColorMat = Bukkit.createBlockData((Material)Material.BLUE_CONCRETE);
        switch (liquidType) {
            case OIL: {
                liquidColorMat = Bukkit.createBlockData((Material)Material.BLACK_CONCRETE);
                break;
            }
            case PETROL: {
                liquidColorMat = Bukkit.createBlockData((Material)Material.GRAY_CONCRETE);
                break;
            }
            case HEAVYOIL: {
                liquidColorMat = Bukkit.createBlockData((Material)Material.ORANGE_CONCRETE);
                break;
            }
            case LIGHTOIL: {
                liquidColorMat = Bukkit.createBlockData((Material)Material.YELLOW_CONCRETE);
                break;
            }
            case LUBRICANT: {
                liquidColorMat = Bukkit.createBlockData((Material)Material.LIME_CONCRETE);
                break;
            }
            case SULFURIC_ACID: {
                liquidColorMat = Bukkit.createBlockData((Material)Material.RED_CONCRETE);
                break;
            }
            case STEAM: {
                liquidColorMat = Bukkit.createBlockData((Material)Material.WHITE_CONCRETE);
                break;
            }
            default: {
                liquidColorMat = Bukkit.createBlockData((Material)Material.BLUE_CONCRETE);
            }
        }
        final BlockData liquidColor = liquidColorMat;
        long delay = 0L;
        for (Integer orderNumber : new ArrayList(scannedOrder.keySet())) {
            delay += 5L;
            for (final Block pipeBlock : (HashSet)scannedOrder.get(orderNumber)) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        if (!player.isOnline()) {
                            return;
                        }
                        player.sendBlockChange(pipeBlock.getLocation(), liquidColor);
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                if (!player.isOnline()) {
                                    return;
                                }
                                player.sendBlockChange(pipeBlock.getLocation(), pipeBlock.getBlockData());
                            }
                        }, 5L);
                    }
                }, delay);
            }
            if (!scannedOrderDevices.containsKey(orderNumber)) continue;
            for (Device device : (HashSet)scannedOrderDevices.get(orderNumber)) {
                final Location loc = device.getLocation();
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        if (!player.isOnline()) {
                            return;
                        }
                        player.sendBlockChange(loc, Bukkit.createBlockData((Material)Material.GREEN_CONCRETE));
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                if (!player.isOnline()) {
                                    return;
                                }
                                player.sendBlockChange(loc, loc.getBlock().getBlockData());
                            }
                        }, 5L);
                    }
                }, delay + 10L);
            }
        }
        return delay;
    }

    public static Material getJunctionMaterial(Material mat) {
        if (mat.equals((Object)Material.ANDESITE_WALL)) {
            return Material.POLISHED_ANDESITE;
        }
        if (mat.equals((Object)Material.GRANITE_WALL)) {
            return Material.POLISHED_GRANITE;
        }
        return Material.POLISHED_DIORITE;
    }

    public static void addCardinalPipes(Block block, ArrayList<Block> unscannedPiping, HashSet<Block> scannedPiping, HashSet<Device> attachedDevices, Device.LiquidType liquidType, Material wallMat, Material junction) {
        LiquidUtil.checkFace(block, unscannedPiping, BlockFace.UP, scannedPiping, attachedDevices, liquidType, wallMat, junction);
        LiquidUtil.checkFace(block, unscannedPiping, BlockFace.DOWN, scannedPiping, attachedDevices, liquidType, wallMat, junction);
        LiquidUtil.checkFace(block, unscannedPiping, BlockFace.EAST, scannedPiping, attachedDevices, liquidType, wallMat, junction);
        LiquidUtil.checkFace(block, unscannedPiping, BlockFace.WEST, scannedPiping, attachedDevices, liquidType, wallMat, junction);
        LiquidUtil.checkFace(block, unscannedPiping, BlockFace.NORTH, scannedPiping, attachedDevices, liquidType, wallMat, junction);
        LiquidUtil.checkFace(block, unscannedPiping, BlockFace.SOUTH, scannedPiping, attachedDevices, liquidType, wallMat, junction);
    }

    private static void checkFace(Block block, ArrayList<Block> unscannedPiping, BlockFace face, HashSet<Block> scannedPiping, HashSet<Device> attachedDevices, Device.LiquidType liquidType, Material wallMat, Material junctionType) {
        Block scanTarget = block.getRelative(face);
        Material scanType = scanTarget.getType();
        if ((scanType.equals((Object)wallMat) || scanType.equals((Object)junctionType)) && !scannedPiping.contains(scanTarget)) {
            unscannedPiping.add(scanTarget);
        }
        if (scanType.equals((Object)junctionType)) {
            LiquidUtil.checkConnectedDevice(scanTarget, BlockFace.UP, attachedDevices, liquidType);
            LiquidUtil.checkConnectedDevice(scanTarget, BlockFace.DOWN, attachedDevices, liquidType);
            LiquidUtil.checkConnectedDevice(scanTarget, BlockFace.EAST, attachedDevices, liquidType);
            LiquidUtil.checkConnectedDevice(scanTarget, BlockFace.WEST, attachedDevices, liquidType);
            LiquidUtil.checkConnectedDevice(scanTarget, BlockFace.NORTH, attachedDevices, liquidType);
            LiquidUtil.checkConnectedDevice(scanTarget, BlockFace.SOUTH, attachedDevices, liquidType);
        }
    }

    private static void checkConnectedDevice(Block block, BlockFace face, HashSet<Device> attachedDevices, Device.LiquidType liquidType) {
        Device device = Device.getDevice(block.getRelative(face).getLocation());
        if (device != null && device.acceptsLiquid(liquidType) && !attachedDevices.contains(device)) {
            attachedDevices.add(device);
        }
    }

    public static boolean isPipeBlock(Block block) {
        return block.getType().equals((Object)Material.DIORITE_WALL) || block.getType().equals((Object)Material.ANDESITE_WALL) || block.getType().equals((Object)Material.GRANITE_WALL);
    }

    public static boolean hasBeenScanned(Chunk chunk) {
        return chunk.getPersistentDataContainer().has(oilKey);
    }
}

