/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public class Infuser
extends Device {
    private static final long serialVersionUID = 7571974070728037013L;

    public Infuser(Location loc) {
        super(loc);
        this.setMaterial("ENCHANTING_TABLE");
        this.deviceName = "Infuser";
        this.setActionTimer(2);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(20);
        this.useAutoSlots();
        this.setStoreForm(true);
        this.setPollutionGen(10);
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Attempts to infuse items.");
        lore.add("- Infusing has a high chance to destroy inputs.");
        lore.add("- Can turn sand into redstone.");
        lore.add("- Redsand is much more likely to infuse.");
        lore.add("- Can turn spider eyes into enderpearls.");
        lore.add("- Uses amethyst shards to always infuse.");
        return lore;
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            boolean infused = false;
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance);
            if (this.getGrid().hasPower(this.getActionPower()) && this.getOutputSlot() != -1) {
                ItemStack amy = null;
                for (ItemStack stack : this.getInputItems()) {
                    if (!stack.getType().equals((Object)Material.AMETHYST_SHARD)) continue;
                    amy = stack;
                    break;
                }
                for (ItemStack stack : this.getInputItems()) {
                    boolean matched = false;
                    boolean burned = false;
                    Material spawnMat = null;
                    if (stack.getType().equals((Object)Material.SAND)) {
                        matched = true;
                        spawnMat = Material.REDSTONE;
                        if (TUMaths.rollRange(0, 99) >= 25) {
                            burned = true;
                        }
                    }
                    if (stack.getType().equals((Object)Material.RED_SAND)) {
                        matched = true;
                        spawnMat = Material.REDSTONE;
                        if (TUMaths.rollRange(0, 99) >= 50) {
                            burned = true;
                        }
                    }
                    if (stack.getType().equals((Object)Material.SPIDER_EYE)) {
                        matched = true;
                        spawnMat = Material.ENDER_PEARL;
                        if (TUMaths.rollRange(0, 99) >= 25) {
                            burned = true;
                        }
                    }
                    if (!matched) continue;
                    playSound = true;
                    infused = true;
                    this.logItem(stack, -1);
                    stack.setAmount(stack.getAmount() - 1);
                    if (amy != null) {
                        this.logItem(amy, -1);
                        amy.setAmount(amy.getAmount() - 1);
                        burned = false;
                    }
                    if (!burned) {
                        ItemStack spawnStack = new ItemStack(spawnMat);
                        this.getInventory().setItem(this.getOutputSlot(), spawnStack);
                        this.logItem(spawnStack, 1);
                    }
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    break;
                }
            } else {
                this.setFailReason("Not enough power");
            }
            if (!infused) {
                this.setFailReason("Nothing to infuse");
            }
            if (playerNear) {
                if (playSound && TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                    this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.7f);
                } else if (!infused) {
                    this.spawnInactiveParticles();
                }
            }
        }
    }
}

