/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Manufactoring;

import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemForge
extends Device {
    private static final long serialVersionUID = -3929401797254451215L;

    public ItemForge(Location loc) {
        super(loc);
        this.setMaterial("CRAFTING_TABLE");
        this.deviceName = "Item Forge";
        this.setActionTimer(1);
        this.setGridRange(0);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(0);
        this.setActionPower(0);
        this.addTag("Debug Item");
        ArrayList<Integer> outputSlots = new ArrayList<Integer>();
        outputSlots.add(15);
        outputSlots.add(16);
        outputSlots.add(17);
        this.setOutputSlots(outputSlots);
        ArrayList<Integer> allSlots = new ArrayList<Integer>();
        allSlots.addAll(outputSlots);
        allSlots.add(22);
        this.setClickableSlots(allSlots);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(MineItems.descColor) + "- Creates the target item from nothing.");
        return lore;
    }

    @Override
    public void updateUI() {
        Inventory inv = null;
        if (this.inv == null) {
            this.inv = TUInventory.createInventory(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Item Forge", 3, "Item Forge");
        }
        inv = this.inv;
        ItemStack pane = MainMenu.createWhitePane();
        inv.setItem(3, pane);
        inv.setItem(5, pane);
        inv.setItem(12, pane);
        inv.setItem(13, pane);
        inv.setItem(14, pane);
        inv.setItem(21, pane);
        inv.setItem(23, pane);
        pane = MainMenu.createYellowPane();
        inv.setItem(6, pane);
        inv.setItem(7, pane);
        inv.setItem(8, pane);
        inv.setItem(24, pane);
        inv.setItem(25, pane);
        inv.setItem(26, pane);
        ItemStack infoStack = TUItems.createItem(Material.CRAFTING_TABLE, String.valueOf(MineItems.whiteBold()) + "Device Info", new ArrayList<String>());
        infoStack = TUItems.setModelData(infoStack, 9525);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.GOLD) + " Produce Time: " + String.valueOf(ChatColor.WHITE) + this.getActionTimer() + "s");
        lore.add(String.valueOf(ChatColor.GOLD) + " Time Left: " + String.valueOf(ChatColor.WHITE) + this.getCurrentTimer() + "s");
        if (!this.getFailReason().equals("None")) {
            lore.add(String.valueOf(ChatColor.RED) + " - " + this.getFailReason());
        }
        TUItems.addLore(infoStack, lore);
        inv.setItem(4, infoStack);
    }

    @Override
    public void action() {
        if (this.isPowered() && this.getGrid() != null) {
            if (this.getGrid().hasPower(5)) {
                this.produceCraft();
            } else {
                this.setFailReason("Not Enough Power");
            }
        }
    }

    public ItemStack getTargetCraft() {
        if (TUItems.isValid(this.getInventory().getItem(22))) {
            ItemStack target = this.getInventory().getItem(22).clone();
            target.setAmount(1);
            return target;
        }
        return null;
    }

    public String produceCraft() {
        ItemStack targetCraft = this.getTargetCraft();
        if (targetCraft != null) {
            if (this.getOutputSlot() != -1) {
                ItemStack result = targetCraft.clone();
                result.setAmount(1);
                this.getInventory().setItem(this.getOutputSlot(), result);
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 0.2f, 1.0f);
                this.setFailReason("None");
                this.logItem(result, 1);
            } else {
                this.setFailReason("No output space");
            }
        } else {
            this.setFailReason("No Target Craft Found");
        }
        return "Failed";
    }

    @Override
    public int getGridScore() {
        return 5;
    }
}

