/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Belt;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Lift;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.Devices.MoverIOCenter;
import com.MT.xxxtrigger50xxx.Devices.Producers.ElectricBlastFurnace;
import com.MT.xxxtrigger50xxx.Devices.Producers.ElectricFurnace;
import com.MT.xxxtrigger50xxx.Devices.Producers.ElectricSmoker;
import com.MT.xxxtrigger50xxx.Devices.Transport.TrainStation;
import com.MT.xxxtrigger50xxx.Devices.VanillaDevice;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsAPI;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.AdvancedChest;
import us.lynuxcraft.deadsilenceiv.advancedchests.chest.gui.page.ChestPage;

public class MoverOutput {
    private Mover mover;
    private MoverIOCenter.DeviceIOType type;
    private Inventory cachedInv = null;
    private ArrayList<Integer> cachedDynamicSlots = null;
    private boolean placeBothOverride = false;
    private int cX;
    private int cZ;
    private World world;
    private Mover.OutDirection out;
    private static ArrayList<ItemStack> actualStacks = new ArrayList(100);
    private HashMap<Material, Integer> maxStackSizes = new HashMap();

    public MoverOutput(Mover mover, MoverIOCenter.DeviceIOType outType, boolean placeBoth, Mover.OutDirection out) {
        this.mover = mover;
        this.setType(outType);
        this.setPlaceBothOverride(placeBoth);
        this.world = mover.getLocation().getWorld();
        this.cX = mover.getOutChunk(out).getX();
        this.cZ = mover.getOutChunk(out).getZ();
        this.out = out;
    }

    public boolean isLoaded() {
        return this.world.isChunkLoaded(this.cX, this.cZ);
    }

    public Mover getMover() {
        return this.mover;
    }

    public void setMover(Mover mover) {
        this.mover = mover;
    }

    public Inventory getInventory() {
        if (this.cachedInv != null) {
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.CHAIN)) {
            this.cachedInv = Device.getDevice(this.mover.getOutputLocation(this.out)).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.STANDARD) || this.type.equals((Object)MoverIOCenter.DeviceIOType.ROCKET_SILO)) {
            this.cachedInv = Device.getDevice(this.mover.getOutputLocation(this.out)).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.CRAFTER)) {
            this.cachedInv = Device.getDevice(this.mover.getOutputLocation(this.out)).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.AUTODEVICE)) {
            this.cachedInv = Device.getDevice(this.mover.getOutputLocation(this.out)).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.ASSEMBLER)) {
            this.cachedInv = Device.getDevice(this.mover.getOutputLocation(this.out)).getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.TRAIN_STATION)) {
            TrainStation ts = (TrainStation)Device.getDevice(this.mover.getOutputLocation(this.out));
            this.cachedInv = ts.getInventory();
            return this.cachedInv;
        }
        if (this.type.equals((Object)MoverIOCenter.DeviceIOType.STORAGE_CART)) {
            for (Entity ent : this.mover.getOutputLocation(this.out).getWorld().getNearbyEntities(this.mover.getOutputLocation(this.out), 1.0, 1.0, 1.0)) {
                if (!ent.getType().equals((Object)MineMain.version.getMinecartChestEntityType())) continue;
                StorageMinecart sm = (StorageMinecart)ent;
                this.cachedInv = sm.getInventory();
                return this.cachedInv;
            }
            return null;
        }
        Device device = Device.getDevice(this.mover.getOutputLocation(this.out));
        if (device instanceof ElectricFurnace) {
            ElectricFurnace ef = (ElectricFurnace)device;
            this.cachedInv = ef.getInventory();
            return this.cachedInv;
        }
        if (device instanceof ElectricBlastFurnace) {
            ElectricBlastFurnace ef = (ElectricBlastFurnace)device;
            this.cachedInv = ef.getInventory();
            return this.cachedInv;
        }
        if (device instanceof ElectricSmoker) {
            ElectricSmoker ef = (ElectricSmoker)device;
            this.cachedInv = ef.getInventory();
            return this.cachedInv;
        }
        if (MoverIOCenter.isBlockHolderIOType(this.type)) {
            if (this.type.equals((Object)MoverIOCenter.DeviceIOType.DISPENSER) && Mover.isMover(this.mover.getOutputLocation(this.out))) {
                return null;
            }
            this.cachedInv = VanillaDevice.getVanillaDevice(this.mover.getOutputLocation(this.out)).getInventory();
            return this.cachedInv;
        }
        this.cachedInv = null;
        return null;
    }

    private boolean hasSpaceBelt() {
        boolean isLeftCloser;
        Belt belt = Belt.getBelt(this.mover.getOutputLocation(this.out));
        if (belt == null) {
            return false;
        }
        ItemStack leftStack = belt.getLeftStack();
        ItemStack rightStack = belt.getRightStack();
        if (leftStack != null && rightStack != null) {
            return false;
        }
        if (!this.isInserter(belt)) {
            boolean hasMotor = this.mover.hasBeltMotor();
            Mover.MotorType motorType = this.mover.getMotorType();
            if (hasMotor) {
                if (motorType == Mover.MotorType.ALTERNATE) {
                    return this.mover.beltToggle ? rightStack == null : leftStack == null;
                }
                if (motorType == Mover.MotorType.LEFT) {
                    return leftStack == null;
                }
                if (motorType == Mover.MotorType.RIGHT) {
                    return rightStack == null;
                }
            }
            return true;
        }
        Location center = TUMaths.centerLocation(this.mover.getLocation(), 0.0);
        boolean bl = isLeftCloser = center.distanceSquared(belt.getLeftLocation()) < center.distanceSquared(belt.getRightLocation());
        return isLeftCloser && leftStack == null || !isLeftCloser && rightStack == null || this.isPlaceBothOverride() && (leftStack == null || rightStack == null);
    }

    private boolean hasSpaceLift() {
        Lift lift = Lift.getLift(this.mover.getOutputLocation(this.out));
        if (lift == null) {
            return false;
        }
        ItemStack leftStack = lift.getLeftStack();
        ItemStack rightStack = lift.getRightStack();
        if (leftStack == null || rightStack == null) {
            boolean override = !this.isInserter(lift) || this.isPlaceBothOverride();
            Location center = TUMaths.centerLocation(this.mover.getLocation(), 0.0);
            if (center.distanceSquared(lift.getLeftLocation()) < center.distanceSquared(lift.getRightLocation())) {
                if (leftStack == null) {
                    return true;
                }
                if (override && rightStack == null) {
                    return true;
                }
            } else {
                if (rightStack == null) {
                    return true;
                }
                if (override && leftStack == null) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasSpace(ItemStack itemToAdd, int amount) {
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.ADVANCED_CHEST)) {
            AdvancedChest chest = AdvancedChestsAPI.getChestManager().getAdvancedChest(this.mover.getOutputLocation(this.out));
            if (chest == null) {
                return false;
            }
            int i = 0;
            while (i <= chest.getPages().size() - 1) {
                ChestPage page = chest.getPageById(i);
                Inventory inventory = page.getBukkitInventory();
                if (TUMaths.hasSpace(inventory, itemToAdd, amount)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.AIR)) {
            return true;
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.BELT)) {
            return this.hasSpaceBelt();
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.LIFT)) {
            return this.hasSpaceLift();
        }
        Inventory inv = this.getInventory();
        if (inv == null) {
            return false;
        }
        ArrayList<Integer> slots = MoverIOCenter.getDynamicSlots(itemToAdd, this, this.out);
        ItemStack checkStack = itemToAdd;
        Material checkType = checkStack.getType();
        boolean toolChecking = false;
        if (MineUtil.isTool(checkType)) {
            Damageable dmg;
            toolChecking = true;
            ItemMeta itemMeta = checkStack.getItemMeta();
            if (itemMeta instanceof Damageable && (dmg = (Damageable)itemMeta).getDamage() > 0) {
                dmg.setDamage(0);
                checkStack = itemToAdd.clone();
                checkStack.setItemMeta((ItemMeta)dmg);
            }
        }
        int stackSize = 0;
        stackSize = !this.getMover().stackLimitOverride ? this.getMaxStackSize(itemToAdd, this.getType()) : itemToAdd.getType().getMaxStackSize();
        HashMap<Integer, ItemStack> invSlotStacks = new HashMap<Integer, ItemStack>();
        if (!MoverIOCenter.isContainer(this.getType()) && !this.getMover().stackLimitOverride) {
            int amountStored = 0;
            for (Integer n : slots) {
                Damageable dmg;
                ItemMeta itemMeta;
                ItemStack stack = inv.getItem(n.intValue());
                invSlotStacks.put(n, stack);
                if (toolChecking && stack != null && MineUtil.isTool(checkType) && (itemMeta = stack.getItemMeta()) instanceof Damageable && (dmg = (Damageable)itemMeta).getDamage() > 0) {
                    stack = stack.clone();
                    dmg.setDamage(0);
                    stack.setItemMeta((ItemMeta)dmg);
                }
                if (!TUItems.isValid(stack) || !stack.getType().equals((Object)checkType) || !stack.isSimilar(checkStack) || (amountStored += stack.getAmount()) < stackSize) continue;
                return false;
            }
            if (amountStored >= stackSize) {
                return false;
            }
        } else {
            for (Integer slot : slots) {
                invSlotStacks.put(slot, inv.getItem(slot.intValue()));
            }
        }
        int freeSpace = 0;
        int n = amount;
        actualStacks.clear();
        for (Integer slot2 : slots) {
            ItemStack i = (ItemStack)invSlotStacks.get(slot2);
            if (i == null) {
                if ((freeSpace += stackSize) < n) continue;
                return true;
            }
            actualStacks.add(i);
        }
        for (ItemStack aStack : actualStacks) {
            if (!aStack.getType().equals((Object)checkType) || !aStack.isSimilar(checkStack) || (freeSpace += stackSize - aStack.getAmount()) < n) continue;
            return true;
        }
        return false;
    }

    private int getMaxStackSize(ItemStack itemToAdd, MoverIOCenter.DeviceIOType type) {
        Material matType = itemToAdd.getType();
        if (this.maxStackSizes.containsKey(matType)) {
            return this.maxStackSizes.get(matType);
        }
        int stackSize = MineUtil.getMoverMaxStackSize(matType, type);
        this.maxStackSizes.put(matType, stackSize);
        return stackSize;
    }

    private boolean isInserter(Belt belt) {
        boolean isInserter = false;
        if (!belt.getDirection().equals((Object)this.getMover().getFacing())) {
            isInserter = true;
        }
        return isInserter;
    }

    private boolean isInserter(Lift lift) {
        boolean isInserter = false;
        if (!lift.getMover().liftDirection.equals((Object)this.getMover().getFacing())) {
            isInserter = true;
        }
        return isInserter;
    }

    public void addStack(ItemStack stack, boolean toggle) {
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.ADVANCED_CHEST)) {
            AdvancedChest chest = AdvancedChestsAPI.getChestManager().getAdvancedChest(this.mover.getOutputLocation(this.out));
            int i = 0;
            while (i <= chest.getPages().size() - 1) {
                ChestPage page = chest.getPageById(i);
                Inventory inventory = page.getBukkitInventory();
                if (TUMaths.hasSpace(inventory, stack, 1)) {
                    ItemStack addStack = stack.clone();
                    addStack.setAmount(1);
                    inventory.addItem(new ItemStack[]{addStack});
                    return;
                }
                ++i;
            }
            return;
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.AIR)) {
            Location out = this.getMover().getOutputDropLocation();
            ItemStack dropStack = stack.clone();
            dropStack.setAmount(1);
            Item item = out.getWorld().dropItem(out, dropStack);
            item.setVelocity(new Vector());
            if (MinetorioListener.isPlayerNearbyOPT(out, 16.0)) {
                out.getWorld().playSound(out, Sound.BLOCK_DISPENSER_DISPENSE, 1.0f, 1.0f);
            }
            return;
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.LIFT)) {
            Lift lift = Lift.getLift(this.mover.getOutputLocation(this.out));
            if (lift != null) {
                Location center = TUMaths.centerLocation(this.mover.getLocation(), 0.0);
                ItemStack dropStack = stack.clone();
                dropStack.setAmount(1);
                boolean isOveride = this.isPlaceBothOverride() || !this.isInserter(lift);
                lift.insertStack(center, dropStack, isOveride);
            }
            return;
        }
        if (this.getType().equals((Object)MoverIOCenter.DeviceIOType.BELT)) {
            Belt belt = null;
            if (Belt.isBelt(this.mover.getOutputLocation(this.out))) {
                belt = Belt.getBelt(this.mover.getOutputLocation(this.out));
            }
            ItemStack beltStack = stack.clone();
            beltStack.setAmount(1);
            if (!this.isInserter(belt)) {
                if (this.mover.hasBeltMotor()) {
                    if (this.mover.getMotorType().equals((Object)Mover.MotorType.LEFT)) {
                        if (belt.getLeftStack() == null) {
                            belt.setLeftStack(beltStack);
                            belt.updateBelt();
                        }
                        return;
                    }
                    if (this.mover.getMotorType().equals((Object)Mover.MotorType.RIGHT)) {
                        if (belt.getRightStack() == null) {
                            belt.setRightStack(beltStack);
                            belt.updateBelt();
                        }
                        return;
                    }
                    if (toggle) {
                        if (belt.getRightStack() == null) {
                            belt.setRightStack(beltStack);
                            belt.updateBelt();
                        } else if (belt.getLeftStack() == null) {
                            belt.setLeftStack(beltStack);
                            belt.updateBelt();
                        }
                    } else if (belt.getLeftStack() == null) {
                        belt.setLeftStack(beltStack);
                        belt.updateBelt();
                    } else if (belt.getRightStack() == null) {
                        belt.setRightStack(beltStack);
                        belt.updateBelt();
                    }
                    return;
                }
                if (belt.getRightStack() == null) {
                    belt.setRightStack(beltStack);
                    belt.updateBelt();
                }
            } else {
                Location center = TUMaths.centerLocation(this.mover.getLocation(), 0.0);
                if (center.distanceSquared(belt.getLeftLocation()) < center.distanceSquared(belt.getRightLocation())) {
                    if (belt.getLeftStack() == null) {
                        belt.setLeftStack(beltStack);
                        belt.updateBelt();
                    } else if (this.isPlaceBothOverride() && belt.getRightStack() == null) {
                        belt.setRightStack(beltStack);
                        belt.updateBelt();
                    }
                } else if (belt.getRightStack() == null) {
                    belt.setRightStack(beltStack);
                    belt.updateBelt();
                } else if (this.isPlaceBothOverride() && belt.getLeftStack() == null) {
                    belt.setLeftStack(beltStack);
                    belt.updateBelt();
                }
            }
            return;
        }
        int stackSize = stack.getType().getMaxStackSize();
        if (!this.getMover().stackLimitOverride && (this.getType().equals((Object)MoverIOCenter.DeviceIOType.CRAFTER) || this.getType().equals((Object)MoverIOCenter.DeviceIOType.AUTODEVICE))) {
            stackSize = (stackSize = (int)Math.floor(stackSize / 8)) < 0 ? 1 : ++stackSize;
        }
        Inventory inv = this.getInventory();
        for (int slot : MoverIOCenter.getDynamicSlots(stack, this, this.out)) {
            if (!TUItems.isValid(inv.getItem(slot))) {
                ItemStack newStack = stack.clone();
                newStack.setAmount(1);
                inv.setItem(slot, newStack);
                break;
            }
            ItemStack invStack = inv.getItem(slot);
            if (!stack.isSimilar(invStack) || invStack.getAmount() >= stackSize) continue;
            invStack.setAmount(invStack.getAmount() + 1);
            inv.setItem(slot, invStack);
            break;
        }
    }

    public MoverIOCenter.DeviceIOType getType() {
        return this.type;
    }

    public void setType(MoverIOCenter.DeviceIOType type) {
        this.type = type;
    }

    public void setCachedDynamicSlot(ArrayList<Integer> slots) {
        this.cachedDynamicSlots = slots;
    }

    public ArrayList<Integer> getCachedDynamicSlots() {
        if (this.cachedDynamicSlots == null) {
            return null;
        }
        return this.cachedDynamicSlots;
    }

    public boolean isPlaceBothOverride() {
        return this.placeBothOverride;
    }

    public void setPlaceBothOverride(boolean grabBothOverride) {
        this.placeBothOverride = grabBothOverride;
    }
}

