/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.PowerPylon;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.PowerGrid;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PowerPylonMk2
extends PowerPylon {
    private static final long serialVersionUID = -3923232797254451315L;

    public PowerPylonMk2(Location loc) {
        super(loc);
        this.setMaterial("OBSERVER");
        this.deviceName = "Power Pylon Mk2";
        this.setActionTimer(6);
        this.setActionPower(2);
        this.setOpenable(true);
        this.setGridRange(30);
        this.setUseUI(true);
        this.setStoreForm(false);
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
    }

    @Override
    public int getGridScore() {
        return 2;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device has a large power range.");
        lore.add("- Making it useful for power to other devices.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> gridInfo = new ArrayList<String>();
        PowerGrid grid = this.getGrid();
        if (grid != null) {
            gridInfo.add(MineUtil.colon(" Current Load", MineItems.getEnergyIcon() + grid.getLastConsume()) + "/" + MineItems.getEnergyIcon() + grid.getPotentialLoad());
            gridInfo.add(MineUtil.colon(" Power Production", MineItems.getEnergyIcon() + grid.getLastGenerate() + "/" + MineItems.getEnergyIcon() + grid.getPotentialGeneration()));
            int netRate = this.getGrid().getLastGenerate() - grid.getLastConsume();
            String rate = String.valueOf(ChatColor.GREEN) + MineItems.getEnergyIcon() + netRate;
            if (netRate <= 0) {
                rate = String.valueOf(ChatColor.RED) + ChatColor.stripColor((String)rate);
            }
            gridInfo.add(MineUtil.colon(" Net Power", rate));
            int maxCap = this.getGrid().batteryMaxCapacity();
            int bat = grid.batteryPower();
            Object capStr = "" + maxCap;
            Object batStr = "" + bat;
            if (maxCap > 10000) {
                capStr = TUMaths.simplifyNumber(maxCap);
                batStr = TUMaths.simplifyNumber(bat);
            }
            gridInfo.add(MineUtil.colon(" Battery Power", MineItems.getEnergyIcon() + (String)batStr + "/" + MineItems.getEnergyIcon() + (String)capStr));
            gridInfo.add(MineUtil.colon(" Connections", String.valueOf(this.getGrid().gridSize())));
            gridInfo.add(MineUtil.colon(" Grid Score", "" + grid.getGridScore()));
            if (maxCap >= bat && this.getGrid().getPower() > 0) {
                gridInfo.add(" ");
                gridInfo.add(MineItems.redBold() + " Wasting Power");
            }
        } else {
            gridInfo.add(MineItems.redBold() + " No Grid Connection");
        }
        ArrayList<String> loadInfo = new ArrayList<String>();
        if (grid != null) {
            int idleLoad = 0;
            int activeLoad = 0;
            int total = 0;
            HashMap<Device, Integer> lastConsumers = grid.getLastConsumers();
            HashMap<String, Integer> activeLoadConsumers = new HashMap<String, Integer>();
            HashMap<String, Integer> idleLoadConsumers = new HashMap<String, Integer>();
            HashMap<String, Integer> activeLoadConsumersCount = new HashMap<String, Integer>();
            HashMap<String, Integer> idleLoadConsumersCount = new HashMap<String, Integer>();
            for (Device device : new ArrayList<Device>(lastConsumers.keySet())) {
                total += lastConsumers.get(device).intValue();
                if (lastConsumers.get(device).intValue() != device.getIdlePower()) {
                    activeLoad += device.getActionPower() + device.getIdlePower();
                    activeLoadConsumers.put(device.getName(), activeLoadConsumers.getOrDefault(device.getName(), 0) + device.getActionPower() + device.getIdlePower());
                    activeLoadConsumersCount.put(device.getName(), activeLoadConsumersCount.getOrDefault(device.getName(), 0) + 1);
                    continue;
                }
                idleLoad += device.getIdlePower();
                idleLoadConsumers.put(device.getName(), idleLoadConsumers.getOrDefault(device.getName(), 0) + device.getIdlePower());
                idleLoadConsumersCount.put(device.getName(), idleLoadConsumersCount.getOrDefault(device.getName(), 0) + 1);
            }
            loadInfo.add(MineUtil.colon(" Total Load", MineItems.getEnergyIcon() + total));
            loadInfo.add(" ");
            loadInfo.add(MineItems.whiteBold() + " Active Load >> " + MineItems.getEnergyIcon() + activeLoad);
            for (String activeLoadDevice : new ArrayList(activeLoadConsumers.keySet())) {
                loadInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(activeLoadConsumersCount.get(activeLoadDevice)) + "x " + activeLoadDevice + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(activeLoadConsumers.get(activeLoadDevice)));
            }
            loadInfo.add(" ");
            loadInfo.add(MineItems.whiteBold() + " Idle Load >> " + MineItems.getEnergyIcon() + idleLoad);
            for (String idleLoadDevice : new ArrayList(idleLoadConsumers.keySet())) {
                loadInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(idleLoadConsumersCount.get(idleLoadDevice)) + "x " + idleLoadDevice + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(idleLoadConsumers.get(idleLoadDevice)));
            }
        } else {
            loadInfo.add(MineItems.redBold() + " No Grid Connection");
        }
        ArrayList<String> genInfo = new ArrayList<String>();
        if (grid != null) {
            int totalPower = 0;
            int renewablePower = 0;
            int dirtyPower = 0;
            HashMap<Device, Integer> lastGenerators = grid.getLastGenerators();
            HashMap<String, Integer> renewableGenCount = new HashMap<String, Integer>();
            HashMap<String, Integer> renewableGenTotal = new HashMap<String, Integer>();
            HashMap<String, Integer> dirtyGenCount = new HashMap<String, Integer>();
            HashMap<String, Integer> dirtyGenTotal = new HashMap<String, Integer>();
            for (Device device : new ArrayList<Device>(lastGenerators.keySet())) {
                int genned = lastGenerators.get(device);
                totalPower += genned;
                if (PowerPylon.isReneweable(device.getName())) {
                    renewablePower += genned;
                    renewableGenTotal.put(device.getName(), renewableGenTotal.getOrDefault(device.getName(), 0) + genned);
                    renewableGenCount.put(device.getName(), renewableGenCount.getOrDefault(device.getName(), 0) + 1);
                    continue;
                }
                dirtyGenTotal.put(device.getName(), dirtyGenTotal.getOrDefault(device.getName(), 0) + genned);
                dirtyGenCount.put(device.getName(), dirtyGenCount.getOrDefault(device.getName(), 0) + 1);
                dirtyPower += genned;
            }
            genInfo.add(MineUtil.colon(" Total Power", MineItems.getEnergyIcon() + totalPower));
            genInfo.add(" ");
            genInfo.add(MineItems.whiteBold() + " Renewable Power >> " + MineItems.getEnergyIcon() + renewablePower);
            for (String string : new ArrayList(renewableGenTotal.keySet())) {
                genInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(renewableGenCount.get(string)) + "x " + string + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(renewableGenTotal.get(string)));
            }
            genInfo.add(" ");
            genInfo.add(MineItems.whiteBold() + " Non-Renewable Power >> " + MineItems.getEnergyIcon() + dirtyPower);
            for (String string : new ArrayList(dirtyGenTotal.keySet())) {
                genInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(dirtyGenCount.get(string)) + "x " + string + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(dirtyGenTotal.get(string)));
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            HashMap<String, Integer> inactiveTotal = new HashMap<String, Integer>();
            int totalInactive = 0;
            for (Device device : grid.getPowerGenerators()) {
                if (lastGenerators.containsKey(device)) continue;
                inactiveTotal.put(device.getName(), inactiveTotal.getOrDefault(device.getName(), 0) + device.getPowerGen());
                hashMap.put(device.getName(), hashMap.getOrDefault(device.getName(), 0) + 1);
                totalInactive += device.getPowerGen();
            }
            genInfo.add(" ");
            genInfo.add(MineItems.whiteBold() + " Inactive Power >> " + MineItems.getEnergyIcon() + totalInactive);
            for (String string : new ArrayList(inactiveTotal.keySet())) {
                genInfo.add(String.valueOf(ChatColor.GOLD) + "  " + String.valueOf(hashMap.get(string)) + "x " + string + " " + String.valueOf(ChatColor.WHITE) + MineItems.getEnergyIcon() + String.valueOf(inactiveTotal.get(string)));
            }
        } else {
            genInfo.add(MineItems.redBold() + " No Grid Connection");
        }
        ItemStack powerStack = TUItems.setModelData(TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.whiteBold()) + "Grid Information", gridInfo), 9524);
        ItemStack loadStack = TUItems.setModelData(TUItems.createItem(Material.RED_CONCRETE, String.valueOf(MineItems.whiteBold()) + "Load Information", loadInfo), 9524);
        ItemStack genStack = TUItems.setModelData(TUItems.createItem(Material.GREEN_CONCRETE, String.valueOf(MineItems.whiteBold()) + "Generation Information", genInfo), 9524);
        Inventory inv = this.getInventory();
        inv.setItem(8, this.createUpgradeStack());
        inv.setItem(15, genStack);
        inv.setItem(13, powerStack);
        inv.setItem(11, loadStack);
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13 && i != 11 && i != 15 && i != 8) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        this.pylonUpgradeClick(this.getLocation(), this.getFacing(), event);
    }

    @Override
    public void action() {
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            this.getGrid().consumePower(this, this.getActionPower());
        }
        this.checkPylonVisualUpdate();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.REDSTONE_TORCH, 1.0);
    }
}

