/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.PowerPylon;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PowerGrid;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PowerSubstation
extends PowerPylon {
    private static final long serialVersionUID = -3911232797254451315L;
    private static String classSpacedNamed = "Power Substation";

    public PowerSubstation(Location loc) {
        super(loc);
        this.setMaterial("OBSERVER");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(3);
        this.setActionPower(2);
        this.setOpenable(true);
        this.setGridRange(10);
        this.setUseUI(true);
        this.setStoreForm(false);
        this.updateDeviceHeadItem();
        this.displayLockedHorizontal = true;
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This device has a configurable power range.");
        lore.add("- Making it useful for power to other devices.");
        return lore;
    }

    @Override
    public void updateUI() {
        ArrayList<String> gridInfo = new ArrayList<String>();
        gridInfo.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Change Range"));
        gridInfo.add(MineUtil.colon(" Configured Range", "" + this.getGridRange()));
        gridInfo.add(" ");
        PowerGrid grid = this.getGrid();
        if (grid != null) {
            gridInfo.add(MineUtil.colon(" Power Production", String.valueOf(grid.getLastGenerate())));
            gridInfo.add(MineUtil.colon(" Power Usage", String.valueOf(grid.getLastConsume())));
            int netRate = this.getGrid().getLastGenerate() - grid.getLastConsume();
            Object rate = "" + ChatColor.GREEN + netRate;
            if (netRate <= 0) {
                rate = String.valueOf(ChatColor.RED) + ChatColor.stripColor((String)rate);
            }
            gridInfo.add(MineUtil.colon(" Net Power", (String)rate));
            int maxCap = this.getGrid().batteryMaxCapacity();
            int bat = grid.batteryPower();
            Object capStr = "" + maxCap;
            Object batStr = "" + bat;
            if (maxCap > 1000) {
                capStr = TUMaths.simplifyNumber(maxCap);
                batStr = TUMaths.simplifyNumber(bat);
            }
            gridInfo.add(MineUtil.colon(" Stored Power", (String)batStr + "/" + (String)capStr));
            gridInfo.add(MineUtil.colon(" Grid Power", String.valueOf(this.getGrid().getPower())));
            gridInfo.add(MineUtil.colon(" Grid Connections", String.valueOf(this.getGrid().gridSize())));
        } else {
            gridInfo.add(MineItems.redBold() + " No Grid Connection");
        }
        ItemStack powerStack = TUItems.setModelData(TUItems.createItem(Material.OBSERVER, String.valueOf(MineItems.whiteBold()) + "Grid Information", gridInfo), 9524);
        Inventory inv = this.getInventory();
        inv.setItem(13, powerStack);
        inv.setItem(8, this.createUpgradeStack());
        ItemStack gPane = MainMenu.createGoldPane();
        int i = 0;
        while (i <= 26) {
            if (i != 13 && i != 8) {
                inv.setItem(i, gPane);
            }
            ++i;
        }
    }

    @Override
    public void action() {
        if (this.getGrid() != null && this.getGrid().hasPower(this.getActionPower())) {
            this.getGrid().consumePower(this, this.getActionPower());
        }
        this.checkPylonVisualUpdate();
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        this.pylonUpgradeClick(this.getLocation(), this.getFacing(), event);
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            player.closeInventory();
            player.closeInventory();
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    int range = Integer.valueOf(message);
                    if (range > 100) {
                        range = 100;
                    }
                    if (range < 10) {
                        PowerSubstation.this.setActionPower(2);
                    } else {
                        PowerSubstation.this.setActionPower(range / 5);
                    }
                    PowerSubstation.this.setGridRange(range);
                    PowerGrid grid = PowerSubstation.this.getGrid();
                    HashMap<Device, Device> connected = PowerSubstation.this.getGrid().getConnectedDevices();
                    for (Device device : connected.keySet()) {
                        if (connected.get(device) == null || !connected.get(device).equals(PowerSubstation.this)) continue;
                        grid.removeDevice(device);
                    }
                    MineUtil.sendMessage(this.val$player, LocaleUtil.messageText("Substation_Configured"));
                    PowerSubstation.this.updateUI();
                    this.val$player.openInventory(PowerSubstation.this.getInventory());
                }
            }
            ChatInput input = new ChatInput(LocaleUtil.messageText("Substation_Range"), true, player);
            input.start(player);
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.BEACON, 1.0);
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, PowerSubstation.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.POWER, new PowerSubstation(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Advanced Circuit", 2));
        ings.add(new PowerPylon(null).getDeviceStack());
        ings.add(MineItems.getIndustrialItem("Engine Unit"));
        RecipeUtils.addDefaultRecipe(new PowerSubstation(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }
}

