/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.ItemStack;

public class AutoBreaker
extends Device {
    private static final long serialVersionUID = 7232923070728037023L;
    private String direction = null;

    public AutoBreaker(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = "Auto Breaker";
        this.setActionTimer(3);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        this.setUsingAutoUI(true);
        this.setPollutionGen(5);
        if (loc != null) {
            Directional dis = (Directional)this.getLocation().getBlock().getBlockData();
            this.direction = dis.getFacing().toString();
        }
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This will break whatever block is in front of it.");
        lore.add("- Uses pickaxes to break blocks.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GOLDEN_PICKAXE, 1.0);
    }

    @Override
    public void action() {
        if (this.isPowered() && this.getGrid().hasPower(this.getActionPower())) {
            if (this.getOutputSlot() != -1) {
                if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 6.0)) {
                    Directional dis = (Directional)this.getLocation().getBlock().getBlockData();
                    this.direction = dis.getFacing().toString();
                }
                if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance)) {
                    BlockFace facing = BlockFace.valueOf((String)this.direction);
                    Block block = this.getLocation().getBlock().getRelative(facing);
                    if (!MinetorioListener.canBuild(this, block.getLocation())) {
                        return;
                    }
                    if (!(block.getType().equals((Object)Material.AIR) || block.getType().equals((Object)Material.WATER) || block.getType().equals((Object)Material.LAVA) || block.getType().getHardness() == -1.0f)) {
                        ItemStack pickaxe2 = this.getBestPickaxe();
                        ItemStack stonePickaxe = this.getStonePickaxe();
                        ItemStack chosenPickaxe = null;
                        if (stonePickaxe != null && block.isPreferredTool(stonePickaxe)) {
                            chosenPickaxe = stonePickaxe;
                        }
                        if (chosenPickaxe == null && pickaxe2 != null && block.isPreferredTool(pickaxe2)) {
                            chosenPickaxe = pickaxe2;
                        }
                        if (chosenPickaxe != null) {
                            MineUtil.damageItemStack(chosenPickaxe, this.getLocation(), this.getInventory());
                            for (ItemStack drop : block.getDrops(chosenPickaxe)) {
                                if (this.getOutputSlot() != -1) {
                                    this.getInventory().setItem(this.getOutputSlot(), drop);
                                    continue;
                                }
                                block.getWorld().dropItemNaturally(TUMaths.centerLocation(block.getLocation(), 0.5), drop);
                            }
                            block.setType(Material.AIR);
                            if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_CALCITE_BREAK, 1.0f, 1.0f);
                            }
                        } else if (stonePickaxe == null && pickaxe2 == null) {
                            this.setFailReason("Missing pickaxe");
                        } else {
                            this.setFailReason("Need better tool");
                        }
                    } else {
                        this.setFailReason("Nothing to break");
                    }
                } else {
                    this.setFailReason("Need player nearby");
                }
            } else {
                this.setFailReason("No output space");
            }
        }
    }

    private ArrayList<ItemStack> getPicks() {
        ArrayList<ItemStack> picks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getInputItems()) {
            if (!TUItems.isValid(stack) || !stack.getType().toString().contains("PICKAXE")) continue;
            picks.add(stack);
        }
        return picks;
    }

    private ItemStack getBestPickaxe() {
        ItemStack best = null;
        for (ItemStack pickaxe : this.getPicks()) {
            if (best == null) {
                best = pickaxe;
            } else {
                if (best.getType().equals((Object)Material.WOODEN_PICKAXE) && !pickaxe.getType().equals((Object)Material.WOODEN_PICKAXE)) {
                    best = pickaxe;
                }
                if (best.getType().equals((Object)Material.STONE_PICKAXE) && pickaxe.getType().equals((Object)Material.IRON_PICKAXE)) {
                    best = pickaxe;
                }
                if (best.getType().equals((Object)Material.IRON_PICKAXE) && pickaxe.getType().equals((Object)Material.DIAMOND_PICKAXE)) {
                    best = pickaxe;
                }
            }
            if (best == null || !best.getType().equals((Object)Material.NETHERITE_PICKAXE)) continue;
            return best;
        }
        return best;
    }

    private ItemStack getStonePickaxe() {
        for (ItemStack stack : this.getInputItems()) {
            if (!stack.getType().equals((Object)Material.STONE_PICKAXE)) continue;
            return stack;
        }
        return null;
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.CLOCK));
        ings.add(new ItemStack(Material.DISPENSER));
        ings.add(new ItemStack(Material.SMOOTH_STONE, 7));
        RecipeUtils.addDefaultRecipe(new AutoBreaker(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

