/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class AutoCauldron
extends Device {
    private static final long serialVersionUID = 2171974070728037018L;
    private transient Item item = null;
    private static String classSpacedNamed = "Auto Cauldron";
    private int skip = 600;

    public AutoCauldron(Location loc) {
        super(loc);
        this.setMaterial("CAULDRON");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will fill empty buckets with filled liquid.");
        lore.add("- Filled buckets are placed in output slots.");
        lore.add("- Fill level checking is faster when loaded.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.BUCKET, 1.0);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance);
            --this.skip;
            if (playerNear && this.skip > 20) {
                this.skip = 20;
            }
            if (this.skip > 0) {
                this.setFailReason("On cooldown for " + this.skip + "s");
                return;
            }
            this.skip = playerNear ? 20 : 600;
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            ItemStack bucket = null;
            for (ItemStack stack : this.getInputItems()) {
                if (stack == null || !stack.getType().equals((Object)Material.BUCKET)) continue;
                bucket = stack;
                break;
            }
            if (bucket == null) {
                this.setFailReason("Missing empty buckets");
                return;
            }
            if (AutoCauldron.isCauldronFilled(this.getLocation().getBlock())) {
                Material bucketType = AutoCauldron.getCauldronLiquidBucket(this.getLocation().getBlock());
                if (bucketType == null) {
                    return;
                }
                playSound = true;
                AutoCauldron.emptyCauldron(this.getLocation().getBlock());
                this.logItem(bucket, -1);
                bucket.setAmount(bucket.getAmount() - 1);
                ItemStack newBucket = new ItemStack(bucketType);
                this.getInventory().setItem(this.getOutputSlot(), newBucket);
                this.logItem(newBucket, 1);
                this.setConsumingPower(true);
                this.getGrid().consumePower(this, this.getActionPower());
            } else {
                this.setFailReason("Cauldron not filled");
            }
            if (playSound && TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance)) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ITEM_BUCKET_FILL, 1.0f, 1.0f);
            }
        }
    }

    private static boolean isCauldronFilled(Block block) {
        if (block.getType().equals((Object)Material.LAVA_CAULDRON)) {
            return true;
        }
        if (block.getBlockData() instanceof Levelled && block.getType().equals((Object)Material.WATER_CAULDRON)) {
            Levelled levelled = (Levelled)block.getBlockData();
            return levelled.getLevel() >= 7;
        }
        return false;
    }

    public static void emptyCauldron(Block block) {
        if (block.getType().equals((Object)Material.WATER_CAULDRON)) {
            Levelled levelled = (Levelled)block.getBlockData();
            levelled.setLevel(0);
            block.setBlockData((BlockData)levelled);
        }
        if (block.getType().equals((Object)Material.LAVA_CAULDRON)) {
            block.setType(Material.CAULDRON);
        }
    }

    public static Material getCauldronLiquidBucket(Block block) {
        Material material = block.getType();
        if (material.equals((Object)Material.WATER_CAULDRON)) {
            return Material.WATER_BUCKET;
        }
        if (material.equals((Object)Material.LAVA_CAULDRON)) {
            return Material.LAVA_BUCKET;
        }
        if (material.equals((Object)Material.POWDER_SNOW_CAULDRON)) {
            return Material.POWDER_SNOW_BUCKET;
        }
        if (material.equals((Object)Material.CAULDRON)) {
            return Material.BUCKET;
        }
        return null;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, AutoCauldron.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.AUTOMATION, new AutoCauldron(null).getDeviceStack(), true);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(new ItemStack(Material.IRON_INGOT, 7));
        ings.add(new ItemStack(Material.BUCKET));
        RecipeUtils.addDefaultRecipe(new AutoCauldron(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

