/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AutoCollector
extends Device {
    private static final long serialVersionUID = 7571974070728037019L;
    private transient Item item = null;
    private int pickupRange = 5;

    public AutoCollector(Location loc) {
        super(loc);
        this.setMaterial("PURPUR_SLAB");
        this.deviceName = "Auto Collector";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(3);
        this.useAutoSlots();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will collect dropped items within a configurable range");
        lore.add("- Area is configurable between 1 to 8 radius");
        lore.add("- Each item collected is placed into its own output slot.");
        lore.add("- Items placed inside input slots are allowed pickups.");
        lore.add("- All items are picked up with no inputs.");
        lore.add("- A mover will only extract items from the output slots.");
        lore.add("- Output slots are the bottom row of slots.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.HOPPER, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        return TUItems.basicLore(MineUtil.colon(" Pickup Radius", "" + this.getPickupRange()), " ", String.valueOf(ChatColor.YELLOW) + "  -> Click to change pickup range");
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 13) {
            Player player = (Player)event.getWhoClicked();
            player.closeInventory();
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    int newRange = Integer.valueOf(message);
                    if (newRange > 8) {
                        newRange = 8;
                    }
                    if (newRange < 1) {
                        newRange = 1;
                    }
                    AutoCollector.this.setPickupRange(newRange);
                    AutoCollector.this.updateUI();
                    this.val$player.openInventory(AutoCollector.this.getInventory());
                }
            }
            ChatInput input = new ChatInput("Enter the new pickup radius now. The value will be clamped between 1 - 8, remember that this is the radius, not the full length.", true, player);
            input.start(player);
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getPickupRange() == 0) {
                this.setPickupRange(5);
            }
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance);
            for (Entity entity : MineUtil.getEntitiesInCubeRange(this.getLocation(), this.getPickupRange())) {
                Item item;
                if (!this.getGrid().hasPower(this.getActionPower())) break;
                if (!entity.getType().equals((Object)MineMain.version.getItemEntityType()) || (item = (Item)entity).hasMetadata(MineMain.noPickupMetaValue) || MineMain.usingEliteMobs && item.hasMetadata("betterdrops_ignore") || !this.canPickup(item.getItemStack())) continue;
                if (this.getOutputSlot() == -1) break;
                if (playerNear) {
                    MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), item.getLocation(), MineMain.version.getDrippingLavaParticle(), 1, 0.5);
                }
                this.getGrid().consumePower(this, this.getActionPower());
                this.setConsumingPower(true);
                playSound = true;
                this.getInventory().setItem(this.getOutputSlot(), item.getItemStack());
                this.logItem(item.getItemStack());
                item.remove();
                break;
            }
            if (playSound) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            } else {
                this.setFailReason("No Nearby Drops");
            }
        }
    }

    private boolean canPickup(ItemStack stack) {
        if (this.getInputItems().size() == 0) {
            return true;
        }
        for (ItemStack input : this.getInputItems()) {
            if (!input.isSimilar(stack)) continue;
            return true;
        }
        return false;
    }

    public int getPickupRange() {
        return this.pickupRange;
    }

    public void setPickupRange(int pickupRange) {
        this.pickupRange = pickupRange;
    }
}

