/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.azlagor.litefarm.API.API;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class AutoHarvester
extends Device {
    private static final long serialVersionUID = 7571974070728037020L;
    private transient Item item = null;

    public AutoHarvester(Location loc) {
        super(loc);
        this.setMaterial("DARK_PRISMARINE_SLAB");
        this.deviceName = "Auto Harvester";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(3);
        this.useAutoSlots();
        this.setPollutionGen(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will harvest nearby crops!");
        lore.add("- This requires any hoe to be in the input slots to operate.");
        lore.add("- Input slots are the top row of slots.");
        lore.add("- Each item collected is placed into its own output slot.");
        lore.add("- A mover will only extract items from the output slots.");
        lore.add("- Output slots are the bottom row of slots.");
        lore.add("- Only gathers crops within a 11x11x3 area.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.GOLDEN_HOE, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (this.getOutputSlot() == -1) {
                this.setFailReason("No output space");
                return;
            }
            boolean isLoaded = TUMaths.isPlayerNearby(this.getLocation(), MineMain.chunkViewDistance);
            if (!isLoaded) {
                return;
            }
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance);
            if (this.getGrid().hasPower(this.getActionPower())) {
                ArrayList<Location> cropSpots = new ArrayList<Location>();
                Location corner1 = this.getLocation();
                corner1.setX(corner1.getX() - 5.0);
                corner1.setZ(corner1.getZ() - 5.0);
                corner1.setY(corner1.getY() - 1.0);
                Location corner2 = this.getLocation();
                corner2.setX(corner2.getX() + 5.0);
                corner2.setZ(corner2.getZ() + 5.0);
                corner2.setY(corner2.getY() + 1.0);
                for (Location location : AutoHarvester.generateLocationsInArea(corner1, corner2)) {
                    Block upBlock;
                    int i;
                    if (location.getBlock().getType().equals((Object)Material.FARMLAND) && !location.getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.AIR)) {
                        cropSpots.add(location);
                    }
                    if (location.getBlock().getType().equals((Object)Material.PUMPKIN) || location.getBlock().getType().equals((Object)Material.MELON) || location.getBlock().getType().equals((Object)Material.COCOA)) {
                        cropSpots.add(location);
                    }
                    if (location.getBlock().getType().equals((Object)Material.SUGAR_CANE)) {
                        Location caneLoc = location;
                        i = 0;
                        while (i < 4) {
                            upBlock = caneLoc.getBlock().getRelative(BlockFace.UP);
                            if (!upBlock.getType().equals((Object)Material.SUGAR_CANE)) break;
                            caneLoc = upBlock.getLocation();
                            ++i;
                        }
                        if (!caneLoc.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.SUGAR_CANE)) continue;
                        cropSpots.add(caneLoc);
                    }
                    if (location.getBlock().getType().equals((Object)Material.KELP)) {
                        cropSpots.add(location);
                    }
                    if (!location.getBlock().getType().equals((Object)Material.CACTUS)) continue;
                    Location cactusLoc = location;
                    i = 0;
                    while (i < 3) {
                        upBlock = cactusLoc.getBlock().getRelative(BlockFace.UP);
                        if (!upBlock.getType().equals((Object)Material.CACTUS)) break;
                        cactusLoc = upBlock.getLocation();
                        ++i;
                    }
                    if (!cactusLoc.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.CACTUS)) continue;
                    cropSpots.add(cactusLoc);
                }
                ArrayList<ItemStack> hoes = new ArrayList<ItemStack>();
                for (ItemStack stack : this.getInventory()) {
                    if (!TUItems.isValid(stack) || !stack.getType().toString().contains("HOE")) continue;
                    hoes.add(stack);
                }
                if (hoes.size() == 0) {
                    if (playerNear) {
                        this.spawnInactiveParticles();
                    }
                    this.setFailReason("Missing hoes");
                }
                for (Location spot : cropSpots) {
                    if (hoes.size() <= 0 || !this.getGrid().hasPower(this.getActionPower())) break;
                    if (!MinetorioListener.canBuild(this, spot)) continue;
                    ArrayList<ItemStack> gatherables = new ArrayList<ItemStack>();
                    if (spot.getBlock().getType().equals((Object)Material.FARMLAND)) {
                        gatherables.addAll(this.getHarvestable(spot.getBlock().getRelative(BlockFace.UP)));
                    }
                    gatherables.addAll(this.getHarvestable(spot.getBlock()));
                    if (gatherables.size() <= 0 || this.getOutputSlot() == -1) continue;
                    this.getGrid().consumePower(this, this.getActionPower());
                    this.setConsumingPower(true);
                    ItemStack stack2 = (ItemStack)hoes.get(0);
                    MineUtil.damageItemStack(stack2, spot, this.getInventory());
                    boolean isCropBlock = false;
                    for (ItemStack item : gatherables) {
                        if (this.getOutputSlot() == -1) continue;
                        this.logItem(item);
                        this.getInventory().setItem(this.getOutputSlot(), item);
                        if (!item.getType().equals((Object)Material.PUMPKIN) && !item.getType().equals((Object)Material.MELON) && !item.getType().equals((Object)Material.SUGAR_CANE) && !item.getType().equals((Object)Material.COCOA_BEANS) && !item.getType().equals((Object)Material.CACTUS) && !item.getType().equals((Object)Material.KELP)) continue;
                        isCropBlock = true;
                    }
                    if (isCropBlock) {
                        if (!spot.getBlock().getType().equals((Object)Material.KELP)) {
                            spot.getBlock().setType(Material.AIR);
                        } else {
                            spot.getBlock().setType(Material.WATER);
                        }
                    } else {
                        spot.getBlock().getRelative(BlockFace.UP).setType(Material.AIR);
                    }
                    playSound = true;
                    if (!playerNear) continue;
                    MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), spot.getBlock().getRelative(BlockFace.UP).getLocation(), MineMain.version.getDrippingLavaParticle(), 1, 0.5);
                }
            }
            if (playSound) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_CROP_BREAK, 1.0f, 1.0f);
            }
        }
    }

    private ArrayList<ItemStack> getHarvestable(Block block) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        boolean fullyGrown = true;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            boolean bl = fullyGrown = ageable.getAge() == ageable.getMaximumAge();
        }
        if (fullyGrown) {
            if (MineMain.usingLiteFarms && API.isPlant((Location)block.getLocation())) {
                stacks.addAll(API.get_drop((Block)block));
                API.setPlant(null, (Block)block, (int)this.crowdingDistance, (boolean)fullyGrown);
                return stacks;
            }
            if (block.getType().equals((Object)Material.WHEAT)) {
                stacks.add(new ItemStack(Material.WHEAT, 1));
                stacks.add(new ItemStack(Material.WHEAT_SEEDS, TUMaths.rollRange(1, 4)));
            }
            if (block.getType().equals((Object)Material.BEETROOTS)) {
                stacks.add(new ItemStack(Material.BEETROOT, 2));
                stacks.add(new ItemStack(Material.BEETROOT_SEEDS, 1));
            }
            if (block.getType().equals((Object)Material.CARROTS)) {
                stacks.add(new ItemStack(Material.CARROT, 2));
            }
            if (block.getType().equals((Object)Material.POTATOES)) {
                stacks.add(new ItemStack(Material.POTATO, 2));
            }
            if (block.getType().equals((Object)Material.COCOA)) {
                stacks.add(new ItemStack(Material.COCOA_BEANS, 3));
            }
        }
        if (block.getType().equals((Object)Material.PUMPKIN)) {
            stacks.add(new ItemStack(Material.PUMPKIN));
        }
        if (block.getType().equals((Object)Material.MELON)) {
            stacks.add(new ItemStack(Material.MELON));
        }
        if (block.getType().equals((Object)Material.SUGAR_CANE)) {
            stacks.add(new ItemStack(Material.SUGAR_CANE));
        }
        if (block.getType().equals((Object)Material.CACTUS)) {
            stacks.add(new ItemStack(Material.CACTUS));
        }
        if (block.getType().equals((Object)Material.KELP)) {
            stacks.add(new ItemStack(Material.KELP));
        }
        return stacks;
    }

    public static List<Location> generateLocationsInArea(Location corner1, Location corner2) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int minY = Math.min(corner1.getBlockY(), corner2.getBlockY());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int maxY = Math.max(corner1.getBlockY(), corner2.getBlockY());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    locations.add(new Location(corner1.getWorld(), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return locations;
    }
}

