/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ExampleFactorys;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import com.gmail.nossr50.mcMMO;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class AutoPlacer
extends Device {
    private static final long serialVersionUID = 1114974070728037017L;
    private transient Item item = null;
    private static String classSpacedNamed = "Auto Placer";
    private int lastLength = -1;
    private int lastWidth = -1;
    private int lastHeight = -1;
    private transient ArrayList<Block> bakedBlocks = new ArrayList();

    public AutoPlacer(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.useAutoSlots();
        this.setPollutionGen(1);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will place blocks in a square in front of it.");
        lore.add("- The square size is defined by its inputs.");
        lore.add("- It will place on air. It will never replace a block.");
        lore.add("- Max  width / height / length is 32");
        lore.add("- This only works if its chunk is loaded.");
        lore.add("- This device only places actual blocks.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack upStack = ExampleFactorys.directionHead("UP");
        ItemStack lengthStack = upStack.clone();
        TUItems.addLore(TUItems.setModelData(lengthStack, 9539), new ArrayList<String>(MineUtil.wrapText("The slot above this one is used to determine the placement length. Length is the distance the device is facing. The amount of the item in the slot above determines the length. You can use any item!", 45, ChatColor.GRAY)));
        ItemStack widthStack = upStack.clone();
        TUItems.addLore(TUItems.setModelData(widthStack, 9540), new ArrayList<String>(MineUtil.wrapText("The slot above this one is used to determine the placement width. Note that the center block is not considered its width. So a width of 2 will actually be 5 long total, 2 for left and right and 1 for the center block. The amount of the item in the slot above determines the width. You can use any item!", 45, ChatColor.GRAY)));
        ItemStack heightStack = upStack.clone();
        TUItems.addLore(TUItems.setModelData(heightStack, 9541), new ArrayList<String>(MineUtil.wrapText("The slot above this one is used to determine the placement height. The lowest y level will be the y level of the device, and the height will be added to the device y level. The amount of the item in the slot above determines the height. You can use any item!", 45, ChatColor.GRAY)));
        TUItems.setName(lengthStack, MineItems.whiteBold() + "Place Length");
        TUItems.setName(widthStack, MineItems.whiteBold() + "Place Width");
        TUItems.setName(heightStack, MineItems.whiteBold() + "Place Height");
        this.getInventory().setItem(9, lengthStack);
        this.getInventory().setItem(10, widthStack);
        this.getInventory().setItem(11, heightStack);
    }

    @Override
    public ArrayList<String> extraInfoLore() {
        ArrayList<String> lore = new ArrayList<String>();
        int length = 0;
        if (TUItems.isValid(this.getInventory().getItem(0))) {
            length = this.getInventory().getItem(0).getAmount();
        }
        lore.add(MineUtil.colon(" Square Size", length + "x" + length));
        int area = length * length;
        double stacks = 0.0;
        if (area > 0) {
            stacks = TUMaths.roundDouble((double)area / 64.0, 1);
        }
        lore.add(MineUtil.colon(" Area", length * length + " blocks (" + stacks + " stacks)"));
        lore.add(String.valueOf(ChatColor.GRAY) + " Stack size is always 64");
        return lore;
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.SCAFFOLDING, 1.0);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            if (!TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance * 2)) {
                return;
            }
            int length = 0;
            if (TUItems.isValid(this.getInventory().getItem(0))) {
                length = this.getInventory().getItem(0).getAmount();
            }
            if (length == 0) {
                this.setFailReason("No item in slot 1 (length)");
                return;
            }
            int width = 0;
            if (TUItems.isValid(this.getInventory().getItem(1))) {
                width = this.getInventory().getItem(1).getAmount();
            }
            if (width == 0) {
                this.setFailReason("No item in slot 2 (width)");
                return;
            }
            int height = 0;
            if (TUItems.isValid(this.getInventory().getItem(2))) {
                height = this.getInventory().getItem(2).getAmount();
            }
            if (height == 0) {
                this.setFailReason("No item in slot 3 (height)");
                return;
            }
            ItemStack placeStack = null;
            int i = 3;
            while (i < 8) {
                ItemStack invStack = this.getInventory().getItem(i);
                if (TUItems.isValid(invStack) && invStack.getType().isBlock() && !MineItems.isMinetorioItem(invStack)) {
                    placeStack = invStack;
                    break;
                }
                ++i;
            }
            if (length > 32) {
                length = 32;
            }
            if (width > 32) {
                width = 32;
            }
            if (height > 32) {
                height = 32;
            }
            if (placeStack != null) {
                Directional dis = (Directional)this.getLocation().getBlock().getBlockData();
                Block center = this.getLocation().getBlock();
                Block corner1 = center = center.getRelative(dis.getFacing());
                Block corner2 = center;
                BlockFace forwardFace = dis.getFacing();
                BlockFace leftFace = TUMaths.rotateBlockFace(forwardFace, 270);
                BlockFace rightFace = TUMaths.rotateBlockFace(forwardFace, 90);
                int i2 = 0;
                while (i2 < width - 1) {
                    corner1 = corner1.getRelative(leftFace);
                    corner2 = corner2.getRelative(rightFace);
                    ++i2;
                }
                i2 = 0;
                while (i2 < length - 1) {
                    corner2 = corner2.getRelative(forwardFace);
                    ++i2;
                }
                corner2 = corner2.getLocation().add(0.0, (double)(height - 1), 0.0).getBlock();
                if (this.lastLength != length || this.lastWidth != width || this.lastHeight != height || this.bakedBlocks == null) {
                    this.bakedBlocks = new ArrayList<Block>(AutoPlacer.getBlocksInArea(corner1.getLocation(), corner2.getLocation()));
                    this.lastLength = length;
                    this.lastWidth = width;
                    this.lastHeight = height;
                }
                ArrayList<Block> removeBlocks = new ArrayList<Block>();
                for (Block block : this.bakedBlocks) {
                    if (block.getType().isAir() && MinetorioListener.canBuild(this, block.getLocation())) {
                        this.logItem(placeStack, -1);
                        block.setType(placeStack.getType());
                        if (MineMain.usingMCMMO) {
                            mcMMO.getPlaceStore().setTrue(block);
                        }
                        placeStack.setAmount(placeStack.getAmount() - 1);
                        if (!TUMaths.isPlayerNearby(this.getLocation(), MineMain.nearDistance)) break;
                        this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_STONE_PLACE, 1.0f, 1.0f);
                        break;
                    }
                    removeBlocks.add(block);
                }
                for (Block block : removeBlocks) {
                    this.bakedBlocks.remove(block);
                }
                if (this.bakedBlocks.size() == 0) {
                    this.lastLength = -1;
                    this.lastWidth = -1;
                    this.lastHeight = -1;
                }
            } else {
                this.setFailReason("No block to place");
            }
        }
    }

    public static List<Block> getBlocksInArea(Location loc1, Location loc2) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        World world = loc1.getWorld();
        int minX = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int minY = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int minZ = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int maxX = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int maxY = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int maxZ = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    blocks.add(world.getBlockAt(x, y, z));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blocks;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, AutoPlacer.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.AUTOMATION, new AutoPlacer(null).getDeviceStack(), true);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(new ItemStack(Material.REDSTONE));
        ings.add(new ItemStack(Material.CHEST));
        ings.add(new ItemStack(Material.SMOOTH_STONE, 6));
        RecipeUtils.addDefaultRecipe(new AutoPlacer(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, false);
    }
}

