/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Pollution.SuperChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class AutoPlanter
extends Device {
    private static final long serialVersionUID = 7571974070728037024L;
    private transient Item item;
    private transient List<Location> bakedSaplings;
    private transient List<Location> bakedCactus;
    private transient List<Location> bakedCocoaLogs;
    private int rebuildCooldown = 0;
    private int plantCooldown = 0;
    private static ItemStack bonemeal = new ItemStack(Material.BONE_MEAL);
    private static ArrayList<BlockFace> cardinals = new ArrayList();
    private static ArrayList<ItemStack> seeds = new ArrayList();

    static {
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat = materialArray[n2];
            if (mat.toString().contains("SAPLING") && !mat.toString().contains("POTTED") && !mat.toString().contains("BAMBOO_SAPLING")) {
                seeds.add(new ItemStack(mat));
            }
            ++n2;
        }
    }

    public AutoPlanter(Location loc) {
        super(loc);
        cardinals.add(BlockFace.NORTH);
        cardinals.add(BlockFace.EAST);
        cardinals.add(BlockFace.SOUTH);
        cardinals.add(BlockFace.WEST);
        this.item = null;
        this.bakedSaplings = new ArrayList<Location>();
        this.setMaterial("MUD_BRICK_SLAB");
        this.deviceName = "Auto Planter";
        this.setActionTimer(5);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(3);
        this.useAutoSlots();
        this.setPollutionGen(5);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Will plant saplings in a 3 block radius.");
        lore.add("- Will plant seeds in an 11x11x3 area.");
        lore.add("- Will bonemeal saplings and seeds.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.WHEAT_SEEDS, 0.5);
    }

    @Override
    public void cleanup() {
        if (this.item != null) {
            this.item.remove();
        }
    }

    @Override
    public void action() {
        if (this.isPowered()) {
            boolean playSound = false;
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), MineMain.farDistance);
            if (MinetorioListener.isPlayerNearby2DOPT(this.getLocationREADONLY(), 8.0)) {
                if (this.rebuildCooldown <= 0) {
                    this.bakedCactus = null;
                    this.bakedCocoaLogs = null;
                    this.bakedSaplings = null;
                    this.rebuildCooldown = 10;
                } else {
                    --this.rebuildCooldown;
                }
            }
            if (this.getGrid().hasPower(5)) {
                Material cactus;
                SuperChunk sc;
                if (this.plantCooldown > 0) {
                    --this.plantCooldown;
                    if (playerNear) {
                        this.plantCooldown = 0;
                    }
                    this.setFailReason("Planter Scan in " + this.plantCooldown * this.getActionTimer() + "s");
                    return;
                }
                boolean haveBoneMeal = TUMaths.hasStackAmount(this.getInventory(), bonemeal, 1);
                if (haveBoneMeal && (sc = SuperChunk.getSuperChunk(this.getLocationREADONLY())).getPollution() >= 1000) {
                    haveBoneMeal = false;
                }
                boolean saplingAction = false;
                Material sapling = this.getSapling();
                if (sapling != null) {
                    for (Location location : this.getSaplingLocations(this.getLocation())) {
                        if (!location.getBlock().getType().isAir() || !location.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.DIRT) && !location.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.GRASS_BLOCK)) continue;
                        TUMaths.removeStackAmount(this.getInventory(), new ItemStack(sapling), 1);
                        this.logItem(new ItemStack(sapling), -1);
                        location.getBlock().setType(sapling);
                        playSound = true;
                        saplingAction = true;
                        if (!playerNear) break;
                        MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), location.getBlock().getLocation(), Particle.COMPOSTER, 1, 0.5);
                        break;
                    }
                }
                boolean cactusAction = false;
                if (!saplingAction && (cactus = this.getCactus()) != null) {
                    for (Location location : this.getCactusLocations(this.getLocation())) {
                        if (!location.getBlock().getType().isAir() || !location.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.SAND) && !location.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.RED_SAND)) continue;
                        TUMaths.removeStackAmount(this.getInventory(), new ItemStack(cactus), 1);
                        this.logItem(new ItemStack(cactus), -1);
                        location.getBlock().setType(cactus);
                        playSound = true;
                        cactusAction = true;
                        if (!playerNear) break;
                        MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), location.getBlock().getLocation(), Particle.COMPOSTER, 1, 0.5);
                        break;
                    }
                }
                boolean cocoaAction = false;
                if (!saplingAction && !cactusAction) {
                    ItemStack cocoaStack = new ItemStack(Material.COCOA_BEANS);
                    if (TUMaths.hasStackAmount(this.getInventory(), new ItemStack(Material.COCOA_BEANS), 1)) {
                        block2: for (Location location : this.getCocoaLogs()) {
                            for (BlockFace face : cardinals) {
                                if (!location.getBlock().getRelative(face).getType().isAir()) continue;
                                TUMaths.removeStackAmount(this.getInventory(), cocoaStack, 1);
                                this.logItem(new ItemStack(cocoaStack), -1);
                                this.placeCocoaBean(location.getBlock(), face);
                                playSound = true;
                                cocoaAction = true;
                                if (!playerNear) continue block2;
                                MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), location.getBlock().getLocation(), Particle.COMPOSTER, 1, 0.5);
                                continue block2;
                            }
                        }
                    }
                }
                if (!(saplingAction || cactusAction || cocoaAction)) {
                    for (Location location : this.getSaplingLocations(this.getLocation())) {
                        if (!haveBoneMeal || !location.getBlock().getType().toString().contains("SAPLING")) continue;
                        TUMaths.removeStackAmount(this.getInventory(), bonemeal, 1);
                        this.logItem(new ItemStack(Material.BONE_MEAL), -1);
                        haveBoneMeal = false;
                        playSound = true;
                        saplingAction = true;
                        if (playerNear) {
                            MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), location.getBlock().getLocation(), Particle.COMPOSTER, 1, 0.5);
                        }
                        location.getBlock().applyBoneMeal(BlockFace.NORTH);
                        break;
                    }
                }
                if (!(saplingAction || cactusAction || cocoaAction)) {
                    ArrayList<Location> openSpots = new ArrayList<Location>();
                    ArrayList<Location> cropSpots = new ArrayList<Location>();
                    Location corner1 = this.getLocation();
                    corner1.setX(corner1.getX() - 5.0);
                    corner1.setZ(corner1.getZ() - 5.0);
                    corner1.setY(corner1.getY() - 1.0);
                    Location corner2 = this.getLocation();
                    corner2.setX(corner2.getX() + 5.0);
                    corner2.setZ(corner2.getZ() + 5.0);
                    corner2.setY(corner2.getY() + 1.0);
                    for (Location location2 : AutoPlanter.generateLocationsInArea(corner1, corner2)) {
                        if (!location2.getBlock().getType().equals((Object)Material.FARMLAND)) continue;
                        Material upType = location2.getBlock().getRelative(BlockFace.UP).getType();
                        if (upType.equals((Object)Material.AIR)) {
                            openSpots.add(location2);
                            continue;
                        }
                        if (!haveBoneMeal || !AutoPlanter.isBoneMealable(upType) || AutoPlanter.isDoneGrowing(location2.getBlock().getRelative(BlockFace.UP))) continue;
                        cropSpots.add(location2.getBlock().getRelative(BlockFace.UP).getLocation());
                    }
                    for (Location cropLoc : cropSpots) {
                        if (!this.getInventory().containsAtLeast(bonemeal, 1)) break;
                        this.getInventory().removeItem(new ItemStack[]{bonemeal});
                        this.logItem(new ItemStack(bonemeal), -1);
                        if (playerNear) {
                            MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), cropLoc.getBlock().getLocation(), Particle.COMPOSTER, 1, 0.5);
                        }
                        cropLoc.getBlock().applyBoneMeal(BlockFace.NORTH);
                    }
                    ArrayList<ItemStack> hoes = new ArrayList<ItemStack>();
                    for (ItemStack stack : this.getInventory()) {
                        if (!TUItems.isValid(stack) || !stack.getType().toString().contains("HOE")) continue;
                        hoes.add(stack);
                    }
                    if (hoes.size() == 0) {
                        if (playerNear) {
                            this.spawnInactiveParticles();
                        }
                        this.setFailReason("Missing hoes");
                    }
                    for (Location spot : openSpots) {
                        Material plantableType;
                        if (hoes.size() <= 0 || (plantableType = this.getPlantable()) == null) break;
                        ItemStack stack2 = (ItemStack)hoes.get(0);
                        MineUtil.damageItemStack(stack2, spot, this.getInventory());
                        TUMaths.removeStackAmount(this.getInventory(), new ItemStack(plantableType), 1);
                        this.logItem(new ItemStack(plantableType), -1);
                        spot.getBlock().getRelative(BlockFace.UP).setType(this.getBlockType(plantableType));
                        playSound = true;
                        if (!playerNear) continue;
                        MineUtil.spawnParticleLine(TUMaths.centerLocation(this.getLocation(), 0.8), spot.getBlock().getRelative(BlockFace.UP).getLocation(), MineMain.version.getDrippingLavaParticle(), 1, 0.5);
                    }
                }
            }
            if (playSound) {
                this.getLocation().getWorld().playSound(this.getLocation(), Sound.ITEM_CROP_PLANT, 1.0f, 1.0f);
            }
            if (!playerNear) {
                this.plantCooldown = 120;
            }
        }
    }

    public void placeCocoaBean(Block logBlock, BlockFace face) {
        Block cocoaBlock = logBlock.getRelative(face);
        cocoaBlock.setType(Material.COCOA);
        Directional directional = (Directional)cocoaBlock.getBlockData();
        directional.setFacing(face.getOppositeFace());
        cocoaBlock.setBlockData((BlockData)directional);
    }

    public static boolean isDoneGrowing(Block block) {
        return AutoPlanter.getCropGrowthStage(block) >= AutoPlanter.getMaxCropGrowthStage(block);
    }

    public static int getCropGrowthStage(Block block) {
        if (block.getBlockData() instanceof Ageable) {
            Ageable ageable = (Ageable)block.getBlockData();
            return ageable.getAge();
        }
        return -1;
    }

    public static int getMaxCropGrowthStage(Block block) {
        if (block.getBlockData() instanceof Ageable) {
            Ageable ageable = (Ageable)block.getBlockData();
            return ageable.getMaximumAge();
        }
        return -1;
    }

    public static boolean isBoneMealable(Material material) {
        if (material.toString().contains("SAPLING")) {
            return true;
        }
        switch (material) {
            case WHEAT: 
            case NETHER_WART: 
            case CARROTS: 
            case POTATOES: 
            case BEETROOTS: {
                return true;
            }
        }
        return false;
    }

    private Material getPlantable() {
        ArrayList<Material> seedList = new ArrayList<Material>();
        seedList.add(Material.WHEAT_SEEDS);
        seedList.add(Material.BEETROOT_SEEDS);
        seedList.add(Material.MELON_SEEDS);
        seedList.add(Material.PUMPKIN_SEEDS);
        seedList.add(Material.CARROT);
        seedList.add(Material.POTATO);
        for (Material seedType : seedList) {
            if (!TUMaths.hasStackAmount(this.getInventory(), new ItemStack(seedType), 1)) continue;
            return seedType;
        }
        return null;
    }

    private Material getSapling() {
        for (ItemStack seedType : seeds) {
            if (!TUMaths.hasStackAmount(this.getInventory(), seedType, 1)) continue;
            return seedType.getType();
        }
        return null;
    }

    private Material getCactus() {
        if (TUMaths.hasStackAmount(this.getInventory(), new ItemStack(Material.CACTUS), 1)) {
            return Material.CACTUS;
        }
        return null;
    }

    private Material getBlockType(Material seedType) {
        if (seedType.equals((Object)Material.WHEAT_SEEDS)) {
            return Material.WHEAT;
        }
        if (seedType.equals((Object)Material.BEETROOT_SEEDS)) {
            return Material.BEETROOTS;
        }
        if (seedType.equals((Object)Material.MELON_SEEDS)) {
            return Material.MELON_STEM;
        }
        if (seedType.equals((Object)Material.PUMPKIN_SEEDS)) {
            return Material.PUMPKIN_STEM;
        }
        if (seedType.equals((Object)Material.CARROT)) {
            return Material.CARROTS;
        }
        if (seedType.equals((Object)Material.POTATO)) {
            return Material.POTATOES;
        }
        return Material.WHEAT;
    }

    public List<Location> getSaplingLocations(Location center) {
        if (this.bakedSaplings != null && !this.bakedSaplings.isEmpty()) {
            Collections.shuffle(this.bakedSaplings);
            return this.bakedSaplings;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(center.clone().add(new Location(center.getWorld(), 4.0, 0.0, 0.0)));
        locations.add(center.clone().add(new Location(center.getWorld(), 4.0, 0.0, 4.0)));
        locations.add(center.clone().add(new Location(center.getWorld(), 4.0, 0.0, -4.0)));
        locations.add(center.clone().add(new Location(center.getWorld(), -4.0, 0.0, 0.0)));
        locations.add(center.clone().add(new Location(center.getWorld(), -4.0, 0.0, 4.0)));
        locations.add(center.clone().add(new Location(center.getWorld(), -4.0, 0.0, -4.0)));
        locations.add(center.clone().add(new Location(center.getWorld(), 0.0, 0.0, -4.0)));
        locations.add(center.clone().add(new Location(center.getWorld(), 0.0, 0.0, 4.0)));
        this.bakedSaplings = locations;
        return this.bakedSaplings;
    }

    public List<Location> getCactusLocations(Location center) {
        if (this.bakedCactus != null && !this.bakedCactus.isEmpty()) {
            Collections.shuffle(this.bakedCactus);
            return this.bakedCactus;
        }
        Location corner1 = this.getLocation();
        corner1.setX(corner1.getX() - 5.0);
        corner1.setZ(corner1.getZ() - 5.0);
        corner1.setY(corner1.getY() - 1.0);
        Location corner2 = this.getLocation();
        corner2.setX(corner2.getX() + 5.0);
        corner2.setZ(corner2.getZ() + 5.0);
        corner2.setY(corner2.getY() + 1.0);
        ArrayList<Location> locations = new ArrayList<Location>(AutoPlanter.generateLocationsInArea(corner1, corner2));
        boolean remove = false;
        for (Location loc : new ArrayList<Location>(locations)) {
            if (remove) {
                locations.remove(loc);
                remove = false;
                continue;
            }
            remove = true;
        }
        this.bakedCactus = locations;
        return this.bakedCactus;
    }

    public List<Location> getCocoaLogs() {
        if (this.bakedCocoaLogs != null && !this.bakedCocoaLogs.isEmpty()) {
            Collections.shuffle(this.bakedCocoaLogs);
            return this.bakedCocoaLogs;
        }
        Location corner1 = this.getLocation();
        corner1.setX(corner1.getX() - 5.0);
        corner1.setZ(corner1.getZ() - 5.0);
        corner1.setY(corner1.getY() - 1.0);
        Location corner2 = this.getLocation();
        corner2.setX(corner2.getX() + 5.0);
        corner2.setZ(corner2.getZ() + 5.0);
        corner2.setY(corner2.getY() + 1.0);
        ArrayList<Location> locations = new ArrayList<Location>(AutoPlanter.generateLocationsInArea(corner1, corner2));
        for (Location loc : new ArrayList<Location>(locations)) {
            if (loc.getBlock().getType().equals((Object)Material.JUNGLE_LOG)) continue;
            locations.remove(loc);
        }
        this.bakedCocoaLogs = locations;
        return this.bakedCocoaLogs;
    }

    public static List<Location> generateLocationsInArea(Location corner1, Location corner2) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int minX = Math.min(corner1.getBlockX(), corner2.getBlockX());
        int minY = Math.min(corner1.getBlockY(), corner2.getBlockY());
        int minZ = Math.min(corner1.getBlockZ(), corner2.getBlockZ());
        int maxX = Math.max(corner1.getBlockX(), corner2.getBlockX());
        int maxY = Math.max(corner1.getBlockY(), corner2.getBlockY());
        int maxZ = Math.max(corner1.getBlockZ(), corner2.getBlockZ());
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    locations.add(new Location(corner1.getWorld(), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return locations;
    }
}

