/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.Schematic;
import com.MT.triggersUtility.TUInterface.TUInventory;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.Mover;
import com.MT.xxxtrigger50xxx.Guide.ExampleFactorys;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import com.gmail.nossr50.mcMMO;
import com.sk89q.worldedit.math.BlockVector3;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class Blueprinter
extends Device {
    private static final long serialVersionUID = 984974070728037017L;
    private static String classSpacedNamed = "Blueprinter";
    private transient HashMap<Location, BlockData> pasteCache = new HashMap();
    private transient boolean forceCheckSchematic = false;
    private int printState = 0;
    private int length = 1;
    private int width = 1;
    private int height = 1;
    private int pasteDistance = 0;
    private String loadedBluePrint = "None";
    private boolean revealArea = true;
    private int distanceAdjustment = 0;
    private int rotationAdjustment = 0;
    private int forceReveal = 0;

    public Blueprinter(Location loc) {
        super(loc);
        this.setMaterial("DISPENSER");
        this.deviceName = "Blueprinter";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(5);
        this.setPollutionGen(1);
        ArrayList<Integer> ints = new ArrayList<Integer>();
        int i = 18;
        while (i <= 53) {
            ints.add(i);
            ++i;
        }
        this.setInputSlots(ints);
        this.setOutputSlots(ints);
        this.setClickableSlots(ints);
        this.chainingMoverBehavior = true;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Can create user schametics.");
        lore.add("- Which can be placed using this as well.");
        lore.add("- Schematics are placed as blocks are provided.");
        return lore;
    }

    @Override
    public void recreateInv() {
        this.inv = TUInventory.createInventory(ChatColor.GOLD + ChatColor.BOLD + this.deviceName, 6, this.deviceName);
    }

    @Override
    public void updateUI() {
        ArrayList<String> modLore = new ArrayList<String>();
        ArrayList<String> lengthLore = new ArrayList<String>();
        ArrayList<String> widthLore = new ArrayList<String>();
        ArrayList<String> heightLore = new ArrayList<String>();
        modLore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Increase By 1"));
        modLore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Decrease By 1"));
        modLore.add(" ");
        lengthLore.addAll(modLore);
        lengthLore.addAll(new ArrayList<String>(MineUtil.wrapText("The length is the direction the Blueprinter is facing.", 45, ChatColor.GRAY, 1)));
        widthLore.addAll(modLore);
        widthLore.addAll(new ArrayList<String>(MineUtil.wrapText("The width is the direction left and right of blueprinter.", 45, ChatColor.GRAY, 1)));
        heightLore.addAll(modLore);
        heightLore.addAll(new ArrayList<String>(MineUtil.wrapText("The height starts from the y level of the blueprinter and only expands up.", 45, ChatColor.GRAY, 1)));
        ItemStack lengthStack = ExampleFactorys.measurementHead("LENGTH").clone();
        TUItems.addLore(TUItems.setModelData(lengthStack, 9539), lengthLore);
        ItemStack widthStack = ExampleFactorys.measurementHead("WIDTH").clone();
        TUItems.addLore(TUItems.setModelData(widthStack, 9540), widthLore);
        ItemStack heightStack = ExampleFactorys.measurementHead("HEIGHT").clone();
        TUItems.addLore(TUItems.setModelData(heightStack, 9541), heightLore);
        TUItems.setName(lengthStack, MineItems.whiteBold() + "Area Length");
        TUItems.setName(widthStack, MineItems.whiteBold() + "Area Width");
        TUItems.setName(heightStack, MineItems.whiteBold() + "Area Height");
        lengthStack.setAmount(Math.max(this.length, 1));
        widthStack.setAmount(Math.max(this.width, 1));
        heightStack.setAmount(Math.max(this.height, 1));
        this.getInventory().setItem(0, lengthStack);
        this.getInventory().setItem(1, widthStack);
        this.getInventory().setItem(2, heightStack);
        ItemStack saveStack = TUItems.createItem(Material.BOOK, MineItems.whiteBold() + "Save Blueprint", new ArrayList<String>(MineUtil.wrapText("Click this with a named piece of paper on your cursor, this will create a blueprint and convert that piece of paper into a blueprint card. If a blueprint already exists then a new copy of the blueprint card is returned. If no blueprint exists, then the measurements are used to create a new blueprint. The blueprint card can then be used at any Blueprinter to load the blueprint for production.", 45, ChatColor.GRAY, 1)));
        ItemStack stopStack = TUItems.createItem(Material.RED_CONCRETE, MineItems.whiteBold() + "Stop Blueprinter", new ArrayList<String>(MineUtil.wrapText("This will remove the stored blueprint and stop any active printing.", 45, ChatColor.GRAY, 1)));
        ItemStack pauseStack = TUItems.createItem(Material.YELLOW_CONCRETE, MineItems.whiteBold() + "Pause Blueprinter", new ArrayList<String>(MineUtil.wrapText("This will pause the printing process.", 45, ChatColor.GRAY, 1)));
        ItemStack startStack = TUItems.createItem(Material.GREEN_CONCRETE, MineItems.whiteBold() + "Start Blueprinter", new ArrayList<String>(MineUtil.wrapText("This will start the printing process, as long as a blueprint was loaded onto the device. This can also unpause the printer if it was paused.", 45, ChatColor.GRAY, 1)));
        ArrayList<String> loadLore = new ArrayList<String>(MineUtil.wrapText("Click this with a blueprint card to have the card be copied over. Once this is done the device can begin printing by clicking the start button.", 45, ChatColor.GRAY, 1));
        loadLore.add(0, MineUtil.colon(" Shift Left Click", "Rotate paste" + String.valueOf(ChatColor.GRAY) + " (" + this.rotationAdjustment + ")"));
        loadLore.add(0, MineUtil.colon(" " + LocaleUtil.uiText("General_Right_Click"), "Decrease Paste Distance" + String.valueOf(ChatColor.GRAY) + " (" + this.distanceAdjustment + ")"));
        loadLore.add(0, MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Increase Paste Distance" + String.valueOf(ChatColor.GRAY) + " (" + this.distanceAdjustment + ")"));
        String blue = this.loadedBluePrint;
        if (blue == null) {
            blue = "None";
        }
        loadLore.add(0, MineUtil.colon(" Blueprint", blue));
        if (this.pasteCache != null) {
            loadLore.add(" ");
            loadLore.add(MineItems.whiteBold() + " Remaining Blocks");
            HashMap<Material, Integer> needed = new HashMap<Material, Integer>();
            for (BlockData bd : this.pasteCache.values()) {
                if (bd.getMaterial().asItemType() == null || bd.getMaterial().toString().contains("_BED")) continue;
                needed.put(bd.getMaterial(), needed.getOrDefault(bd.getMaterial(), 0) + 1);
            }
            needed.remove(Material.AIR);
            for (Material mat : new ArrayList(needed.keySet())) {
                loadLore.add(String.valueOf(ChatColor.WHITE) + "  - " + mat.toString() + " x" + String.valueOf(needed.get(mat)));
            }
        }
        ItemStack loadStack = TUItems.createItem(Material.HOPPER, MineItems.whiteBold() + "Manage Blueprint", loadLore);
        this.getInventory().setItem(3, saveStack);
        ItemStack bellStack = TUItems.createItem(Material.BELL, MineItems.goldBold() + "Info");
        ArrayList<String> lore = new ArrayList<String>();
        String desc = "This device is fairly complicated, so this will provide some general notes for when you are using this. When placing a blueprint it will remove blocks, however its dropped blocks will be dropped on top of the device. When placing the device it will use items from inside its storage. It will also center the blueprint in front of it. When reveal area is toggled it will switch back off once you are far away. Locations that you dont have permission to build in are also skipped when placing blocks.";
        for (String str : MineUtil.wrapText(desc, 45, ChatColor.WHITE, 1)) {
            lore.add(String.valueOf(ChatColor.WHITE) + " " + str);
        }
        TUItems.addLore(bellStack, lore);
        this.getInventory().setItem(4, bellStack);
        this.getInventory().setItem(5, stopStack);
        this.getInventory().setItem(6, pauseStack);
        this.getInventory().setItem(7, startStack);
        this.getInventory().setItem(8, loadStack);
        int i = 9;
        while (i <= 17) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        ItemStack infoStack = this.createInfoIcon();
        lore = TUItems.basicLore(MineUtil.colon(" Blueprint", this.loadedBluePrint));
        String state = "Stopped";
        if (this.printState == 1) {
            state = "Paused";
        }
        if (this.printState == 2) {
            state = "Printing";
        }
        lore.add(MineUtil.colon(" State", state));
        lore.add(MineUtil.colon(" Show Area", "" + this.revealArea));
        lore.add(MineUtil.colon(" " + LocaleUtil.uiText("General_Left_Click"), "Toggle Area View"));
        TUItems.addLore(infoStack, lore);
        this.getInventory().setItem(13, infoStack);
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.PAPER, 1.0);
    }

    private void showArea(Player player) {
        Block center;
        Directional dis = (Directional)this.getLocation().getBlock().getBlockData();
        BlockFace forwardFace = dis.getFacing();
        Block corner1 = center = this.getLocation().getBlock().getRelative(forwardFace);
        Block corner2 = center;
        BlockFace leftFace = TUMaths.rotateBlockFace(forwardFace, 270);
        BlockFace rightFace = TUMaths.rotateBlockFace(forwardFace, 90);
        int i = 0;
        while (i < this.width - 1) {
            corner1 = corner1.getRelative(leftFace);
            corner2 = corner2.getRelative(rightFace);
            ++i;
        }
        i = 0;
        while (i < this.length - 1) {
            corner2 = corner2.getRelative(forwardFace);
            ++i;
        }
        corner2 = corner2.getLocation().add(0.0, (double)(this.height - 1), 0.0).getBlock();
        TUMaths.showAreaFrameParticles(player, corner1.getLocation(), corner2.getLocation(), 3, 1, true, false, Color.GREEN);
    }

    @Override
    public void action() {
        if (this.forceReveal > 0) {
            --this.forceReveal;
        }
        if (this.isPowered()) {
            boolean playerNear = TUMaths.isPlayerNearby(this.getLocation(), 32.0);
            if (playerNear && (this.revealArea || this.forceReveal > 0)) {
                double distance = 32.0;
                if (this.forceReveal > 0) {
                    distance += 32.0;
                }
                for (Player player : MinetorioListener.getNearbyPlayersOPT(this.getLocationREADONLY(), distance)) {
                    if (this.isAuthorized(player)) {
                        this.showArea(player);
                    }
                    if ((!player.isSneaking() || this.pasteCache == null) && (this.forceReveal <= 0 || this.pasteCache == null)) continue;
                    for (Location loc : this.pasteCache.keySet()) {
                        BlockData bd = this.pasteCache.get(loc);
                        long removeTime = 10L;
                        final BlockDisplay itemDisplay = (BlockDisplay)player.getWorld().spawn(loc, BlockDisplay.class, display -> {
                            BlockData bd2 = bd;
                            if (loc.getBlock().getType().isAir() && !bd.getMaterial().isAir()) {
                                display.setGlowColorOverride(Color.YELLOW);
                            } else if (this.needsReplaced(loc, bd)) {
                                display.setGlowColorOverride(Color.RED);
                                bd2 = loc.getBlock().getBlockData();
                            } else {
                                display.setGlowColorOverride(Color.GREEN);
                            }
                            display.setGlowing(true);
                            display.setShadowStrength(0.0f);
                            display.setBrightness(new Display.Brightness(15, 15));
                            display.setViewRange(0.0f);
                            Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
                            AxisAngle4f leftRotation = new AxisAngle4f(0.0f, 1.0f, 0.0f, 0.0f);
                            Vector3f scale = new Vector3f(1.001f, 1.001f, 1.001f);
                            AxisAngle4f rightRotation = new AxisAngle4f(0.0f, 1.0f, 0.0f, 0.0f);
                            Transformation transformation = new Transformation(translation, leftRotation, scale, rightRotation);
                            display.setTransformation(transformation);
                            if (display.getGlowColorOverride().equals((Object)Color.RED) || display.getGlowColorOverride().equals((Object)Color.YELLOW)) {
                                BlockData bd3 = bd2;
                                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable((BlockDisplay)display, bd3){
                                    private final /* synthetic */ BlockDisplay val$display;
                                    private final /* synthetic */ BlockData val$bd3;
                                    {
                                        this.val$display = blockDisplay;
                                        this.val$bd3 = blockData;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$display.setBlock(this.val$bd3);
                                    }
                                }, 10L);
                            } else {
                                display.setBlock(bd2);
                            }
                            display.setViewRange(64.0f);
                        });
                        MineUtil.setDisposableEntity((Entity)itemDisplay);
                        if (itemDisplay.getGlowColorOverride().equals((Object)Color.RED) || itemDisplay.getGlowColorOverride().equals((Object)Color.YELLOW)) {
                            removeTime += 9L;
                        }
                        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                if (itemDisplay != null) {
                                    itemDisplay.remove();
                                }
                            }
                        }, removeTime);
                    }
                }
            }
            if (playerNear && TUMaths.isPlayerNearby(this.getLocation(), 8.0) || !this.forceCheckSchematic) {
                this.forceCheckSchematic = true;
                if (this.pasteCache == null && this.loadedBluePrint != null && Schematic.doesSchematicExist(this.loadedBluePrint)) {
                    Directional dis = (Directional)this.getLocation().getBlock().getBlockData();
                    BlockVector3 v3 = Schematic.getSchematicDimensions(this.loadedBluePrint);
                    this.pasteDistance = Math.max(v3.getX(), v3.getZ()) / 2 + 1 + this.distanceAdjustment;
                    Location pasteLocation = Blueprinter.adjustByDirection(this.getLocation(), this.pasteDistance, dis.getFacing());
                    pasteLocation.add(0.0, -1.0, 0.0);
                    this.pasteCache = Schematic.getPasteLocations(this.loadedBluePrint, pasteLocation, false, this.rotationAdjustment);
                    if (this.pasteCache.size() == 0) {
                        this.pasteCache = null;
                    }
                }
            }
            if (this.pasteCache != null) {
                if (this.pasteCache.size() > 0) {
                    if (this.printState != 2) {
                        return;
                    }
                    int blocksActions = 3;
                    HashSet<Location> changes = new HashSet<Location>();
                    boolean didPlace = false;
                    for (Location loc : this.pasteCache.keySet()) {
                        BlockData bd = this.pasteCache.get(loc);
                        boolean replaceBlock = this.needsReplaced(loc, bd);
                        if (!MinetorioListener.canBuild(this, loc)) {
                            replaceBlock = false;
                        }
                        if (replaceBlock) {
                            ItemStack useStack;
                            Object mover;
                            if (!loc.getBlock().getType().isAir() || bd.getMaterial().isAir() && !loc.getBlock().getType().isAir()) {
                                ArrayList<ItemStack> picks = this.getPicks();
                                if (picks.size() > 0) {
                                    MineUtil.damageItemStack(picks.get(0), this.getLocation(), this.getInventory());
                                    boolean mtItem = false;
                                    Device device = Device.getDevice(loc);
                                    if (device != null) {
                                        mtItem = true;
                                        device.dropInventory();
                                        loc.getWorld().dropItem(this.getLocation().add(0.5, 1.0, 0.5), device.getDeviceStack());
                                    }
                                    if ((mover = Mover.getMover(loc)) != null) {
                                        mtItem = true;
                                        loc.getWorld().dropItem(this.getLocation().add(0.5, 1.0, 0.5), MineItems.getIndustrialItem("Mover"));
                                    }
                                    Block block = loc.getBlock();
                                    if (!mtItem) {
                                        for (ItemStack drop : block.getDrops()) {
                                            block.getWorld().dropItem(this.getLocation().add(0.5, 1.0, 0.5), drop);
                                        }
                                    }
                                    block.setType(Material.AIR);
                                    if (TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                                        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_CALCITE_BREAK, 1.0f, 1.0f);
                                    }
                                } else {
                                    this.setFailReason("Iron Pickaxe or better missing");
                                    break;
                                }
                            }
                            if (bd.getMaterial().asItemType() == null || bd.getMaterial().toString().contains("_BED")) {
                                this.pasteCache.remove(loc);
                                return;
                            }
                            ItemStack placeStack = bd.getMaterial().asItemType().createItemStack();
                            String pasteDevice = Schematic.getPasteDevice(loc);
                            if (pasteDevice != null) {
                                mover = ItemMenu.getAllItems().iterator();
                                while (mover.hasNext()) {
                                    ItemStack possible = (ItemStack)mover.next();
                                    if (possible.getItemMeta() == null || !possible.getItemMeta().hasDisplayName() || !pasteDevice.equals(ChatColor.stripColor((String)possible.getItemMeta().getDisplayName()))) continue;
                                    placeStack = possible;
                                    placeStack.setAmount(1);
                                    break;
                                }
                            }
                            if ((useStack = this.getPlacementStack(placeStack)) == null) {
                                if (!TUMaths.hasName(placeStack)) {
                                    this.setFailReason("Need " + placeStack.getType().toString());
                                    continue;
                                }
                                this.setFailReason("Need " + ChatColor.stripColor((String)placeStack.getItemMeta().getDisplayName()));
                                continue;
                            }
                            useStack.setAmount(useStack.getAmount() - 1);
                            didPlace = true;
                            Block block = loc.getBlock();
                            BlockState blockState = bd.createBlockState();
                            if (blockState instanceof Container) {
                                Container container = (Container)blockState;
                                ItemStack[] contents = container.getInventory().getContents();
                                block.setBlockData(bd);
                                BlockState blockState2 = block.getState();
                                if (blockState2 instanceof Container) {
                                    Container newContainer = (Container)blockState2;
                                    newContainer.getInventory().setContents(contents);
                                }
                            } else {
                                loc.getBlock().setBlockData(bd);
                            }
                            block = loc.getBlock();
                            if (pasteDevice != null) {
                                if (pasteDevice.equals("Mover")) {
                                    Mover mover2 = new Mover(loc);
                                    Container container = (Container)loc.getBlock().getState();
                                    container.setCustomName(MineItems.goldBold() + "Mover");
                                    container.update(true);
                                    mover2.setPlacerUUID(this.getPlacerUUIDString());
                                } else {
                                    Device placedDevice = null;
                                    for (String deviceName : new HashSet<String>(MinetorioListener.deviceClasses.keySet())) {
                                        if (!pasteDevice.equals(deviceName)) continue;
                                        Class<?> clazz = MinetorioListener.deviceClasses.get(deviceName);
                                        try {
                                            Object instance = clazz.getDeclaredConstructor(Location.class).newInstance(loc);
                                            placedDevice = (Device)instance;
                                        }
                                        catch (NoSuchMethodException noSuchMethodException) {
                                        }
                                        catch (SecurityException securityException) {
                                        }
                                        catch (InstantiationException instantiationException) {
                                        }
                                        catch (IllegalAccessException illegalAccessException) {
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                        }
                                        catch (InvocationTargetException invocationTargetException) {}
                                        break;
                                    }
                                    if (placedDevice != null) {
                                        boolean isContainer = loc.getBlock().getState() instanceof Container;
                                        if (!isContainer || isContainer && loc.getBlock().getType().equals((Object)Material.BARREL)) {
                                            loc.getBlock().setType(placedDevice.getPlaceType());
                                            if (MineMain.usingMCMMO) {
                                                mcMMO.getPlaceStore().setTrue(block);
                                            }
                                        }
                                        placedDevice.setPlacerUUID(this.getPlacerUUIDString());
                                        placedDevice.compute();
                                    }
                                }
                            }
                            changes.add(loc);
                            --blocksActions;
                        } else {
                            changes.add(loc);
                        }
                        if (blocksActions > 0) continue;
                    }
                    if (didPlace && TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
                        this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.BLOCK_PISTON_CONTRACT, 1.0f, 2.0f);
                    }
                    for (Location loc : changes) {
                        this.pasteCache.remove(loc);
                    }
                } else {
                    OfflinePlayer op;
                    this.pasteCache = null;
                    this.printState = 0;
                    if (this.getPlacerUUID() != null && !this.loadedBluePrint.equals("None") && (op = Bukkit.getOfflinePlayer((UUID)this.getPlacerUUID())).isOnline()) {
                        MineUtil.sendMessage(op.getPlayer(), LocaleUtil.messageText("BP_Fnished").replace("%blueprint%", this.loadedBluePrint));
                    }
                }
            }
        }
    }

    private boolean needsReplaced(Location loc, BlockData target) {
        String pasteDevice;
        boolean replaceBlock = true;
        if (loc.getBlock().getType().equals((Object)Material.AIR) && target.getMaterial().equals((Object)Material.AIR)) {
            replaceBlock = false;
        }
        if (replaceBlock && loc.getBlock().getBlockData().equals(target)) {
            replaceBlock = false;
        }
        Device device = Device.getDevice(loc);
        if (replaceBlock && device != null) {
            pasteDevice = Schematic.getPasteDevice(loc);
            if (device.getName().equals(pasteDevice)) {
                replaceBlock = false;
            }
        }
        if (replaceBlock && (pasteDevice = Schematic.getPasteDevice(loc)) != null && pasteDevice.equals("Mover")) {
            Mover mover = Mover.getMover(loc);
            if (replaceBlock && mover != null) {
                replaceBlock = false;
            }
        }
        return replaceBlock;
    }

    private ArrayList<ItemStack> getPicks() {
        ArrayList<ItemStack> picks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getInputItems()) {
            if (!TUItems.isValid(stack) || !stack.getType().equals((Object)Material.IRON_PICKAXE) && !stack.getType().equals((Object)Material.DIAMOND_PICKAXE) && !stack.getType().equals((Object)Material.NETHERITE_PICKAXE)) continue;
            picks.add(stack);
        }
        return picks;
    }

    private ItemStack getPlacementStack(ItemStack neededStack) {
        for (ItemStack stack : this.getInputItems()) {
            if (!TUItems.isValid(stack) || !neededStack.isSimilar(stack)) continue;
            return stack;
        }
        return null;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 0) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.length = this.modMeasurement(event, this.length);
            this.updateUI();
            return;
        }
        if (event.getSlot() == 1) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.width = this.modMeasurement(event, this.width);
            this.updateUI();
            return;
        }
        if (event.getSlot() == 2) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.height = this.modMeasurement(event, this.height);
            this.updateUI();
            return;
        }
        if (event.getSlot() == 3 && TUItems.isValid(event.getCursor()) && event.getCursor().getType().equals((Object)Material.PAPER) && event.getCursor().hasItemMeta() && event.getCursor().getItemMeta().hasDisplayName()) {
            Block center;
            String schemName = ChatColor.stripColor((String)event.getCursor().getItemMeta().getDisplayName());
            if (!(Schematic.doesSchematicExist(schemName) || this.length != 0 && this.width != 0 && this.height != 0)) {
                MineUtil.sendWarning((CommandSender)event.getWhoClicked(), "No blueprint exists for this yet, please make sure length, width and height are not zero in order to create a new blueprint.");
                return;
            }
            Directional dis = (Directional)this.getLocation().getBlock().getBlockData();
            BlockVector3 devBlock = BlockVector3.at((int)this.getLocation().getBlockX(), (int)this.getLocation().getBlockY(), (int)this.getLocation().getBlockZ());
            BlockFace forwardFace = dis.getFacing();
            Block corner1 = center = this.getLocation().getBlock().getRelative(forwardFace);
            Block corner2 = center;
            BlockFace leftFace = TUMaths.rotateBlockFace(forwardFace, 270);
            BlockFace rightFace = TUMaths.rotateBlockFace(forwardFace, 90);
            int i = 0;
            while (i < this.width - 1) {
                corner1 = corner1.getRelative(leftFace);
                corner2 = corner2.getRelative(rightFace);
                ++i;
            }
            i = 0;
            while (i < this.length - 1) {
                corner2 = corner2.getRelative(forwardFace);
                ++i;
            }
            corner2 = corner2.getLocation().add(0.0, (double)(this.height - 1), 0.0).getBlock();
            if (!Schematic.doesSchematicExist(schemName)) {
                MineUtil.sendMessage((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_New"));
                Schematic.saveSchematic(this.getLocation().getWorld(), BlockVector3.at((int)corner1.getX(), (int)corner1.getY(), (int)corner1.getZ()), BlockVector3.at((int)corner2.getX(), (int)corner2.getY(), (int)corner2.getZ()), schemName, devBlock);
            } else {
                MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_Existing"));
            }
            event.getCursor().setAmount(event.getCursor().getAmount() - 1);
            ItemStack card = this.createBlueprintCard(schemName);
            event.getWhoClicked().getWorld().dropItem(TUMaths.centerLocation(event.getWhoClicked().getEyeLocation(), 0.0), card);
        }
        if (event.getSlot() == 5 && this.printState != 0) {
            this.printState = 0;
            this.updateUI();
            MineUtil.sendMessage((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_Print_Stopped"));
        }
        if (event.getSlot() == 6 && this.printState == 2) {
            this.printState = 1;
            this.updateUI();
            MineUtil.sendMessage((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_Print_Paused"));
        }
        if (event.getSlot() == 7 && this.printState != 2) {
            if (!this.loadedBluePrint.equals("None")) {
                this.printState = 2;
                this.updateUI();
                MineUtil.sendMessage((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_Print_Started"));
            } else {
                MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_No_Card"));
            }
        }
        if (event.getSlot() == 8) {
            if (TUItems.isValid(event.getCursor())) {
                String schematic = this.getBlueprintCardSchematic(event.getCursor());
                if (schematic != null) {
                    if (Schematic.doesSchematicExist(schematic)) {
                        this.loadedBluePrint = schematic;
                        MineUtil.sendMessage((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_Copied"));
                        this.pasteCache = null;
                        this.updateUI();
                    } else {
                        MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_Doesnt_Exist"));
                    }
                } else {
                    MineUtil.sendWarning((CommandSender)event.getWhoClicked(), LocaleUtil.messageText("BP_No_Blueprint"));
                }
            } else {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.pasteCache = null;
                if (event.isLeftClick() && !event.isShiftClick()) {
                    ++this.distanceAdjustment;
                }
                if (event.isRightClick()) {
                    --this.distanceAdjustment;
                }
                if (this.distanceAdjustment > 10) {
                    this.distanceAdjustment = 10;
                }
                if (this.distanceAdjustment < -10) {
                    this.distanceAdjustment = -10;
                }
                if (event.isLeftClick() && event.isShiftClick()) {
                    this.rotationAdjustment += 90;
                }
                if (this.rotationAdjustment > 270) {
                    this.rotationAdjustment = 0;
                }
                this.forceReveal = 5;
                this.updateUI();
            }
        }
        if (event.getSlot() == 13) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            if (event.isLeftClick()) {
                this.revealArea = !this.revealArea;
            }
            this.updateUI();
        }
    }

    public ItemStack createBlueprintCard(String schematicName) {
        ArrayList<String> cardLore = TUItems.basicLore(String.valueOf(ChatColor.GOLD) + " Industrial Item");
        cardLore.add(MineUtil.colon(" Blueprint", schematicName));
        cardLore.addAll(MineUtil.wrapText("This can be copied into a blueprinter, which can build this blueprint.", 45, ChatColor.GRAY, 1));
        return TUItems.createItem(Material.PAPER, MineItems.goldBold() + "Blueprint Card", cardLore);
    }

    public String getBlueprintCardSchematic(ItemStack stack) {
        if (TUItems.isValid(stack) && stack.getType().equals((Object)Material.PAPER) && TUItems.hasLoreLineNoColor(stack, "Blueprint:")) {
            return ChatColor.stripColor((String)TUItems.getLoreLineNoColor(stack, "Blueprint:").split(": ")[1]);
        }
        return null;
    }

    private int modMeasurement(InventoryClickEvent event, int measurement) {
        int amount = measurement;
        if (event.isLeftClick()) {
            ++amount;
        }
        if (event.isLeftClick() && event.isShiftClick()) {
            amount += 9;
        }
        if (event.isRightClick()) {
            --amount;
        }
        if (event.isRightClick() && event.isShiftClick()) {
            amount -= 9;
        }
        if (amount > 64) {
            amount = 64;
        }
        if (amount < 1) {
            amount = 1;
        }
        return amount;
    }

    public static void addRecipe() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, Blueprinter.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.AUTOMATION, new Blueprinter(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(new ItemStack(Material.QUARTZ_BLOCK));
        ings.add(new ItemStack(Material.OBSERVER));
        ings.add(new ItemStack(Material.SMOOTH_STONE, 6));
        RecipeUtils.addDefaultRecipe(new Blueprinter(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    private static Location adjustByDirection(Location origin, int length, BlockFace direction) {
        switch (direction) {
            case NORTH: {
                return origin.subtract(0.0, 0.0, (double)length);
            }
            case SOUTH: {
                return origin.add(0.0, 0.0, (double)length);
            }
            case EAST: {
                return origin.add((double)length, 0.0, 0.0);
            }
            case WEST: {
                return origin.subtract((double)length, 0.0, 0.0);
            }
            case UP: {
                return origin.add(0.0, (double)length, 0.0);
            }
            case DOWN: {
                return origin.subtract(0.0, (double)length, 0.0);
            }
        }
        throw new IllegalArgumentException("Unsupported BlockFace direction: " + String.valueOf(direction));
    }
}

