/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.xxxtrigger50xxx.Devices.Producers.ElectricFurnace;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class ElectricBlastFurnace
extends ElectricFurnace {
    private static final long serialVersionUID = 4211610198705481795L;
    private static String classSpacedNamed = "Electric Blast Furnace";
    private static HashMap<ItemStack, ItemStack> furnaceSmeltingResults = new HashMap();
    private static HashSet<BlastingRecipe> cachedSmeltingRecipes = new HashSet();
    private static int smeltingCacheSize = 0;

    public ElectricBlastFurnace(Location loc) {
        super(loc);
        this.setMaterial("BLAST_FURNACE");
        this.deviceName = classSpacedNamed;
        this.setIdlePower(3);
        this.setActionPower(20);
        this.setPollutionGen(6);
        this.arrowMax = (short)5;
    }

    @Override
    public int getGridScore() {
        return 4;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(MineItems.descColor) + "- Uses power from the grid to smelt items.");
        lore.add(String.valueOf(MineItems.descColor) + "- Behaves like a normal blast furnace otherwise.");
        lore.add(String.valueOf(MineItems.descColor) + "- Uses more power then the typical Electric Furnace.");
        return lore;
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, ElectricBlastFurnace.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.MANUFACTORING, new ElectricBlastFurnace(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Processing Unit", 3));
        ings.add(MineItems.getIndustrialItem("Electric Engine Unit"));
        ings.add(new ElectricFurnace(null).getDeviceStack());
        RecipeUtils.addDefaultRecipe(new ElectricBlastFurnace(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    private static void buildSmeltingCache() {
        cachedSmeltingRecipes.clear();
        Iterator iter = Bukkit.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = (Recipe)iter.next();
            if (!(recipe instanceof BlastingRecipe)) continue;
            BlastingRecipe fr = (BlastingRecipe)recipe;
            cachedSmeltingRecipes.add(fr);
        }
        smeltingCacheSize = cachedSmeltingRecipes.size();
    }

    @Override
    public ItemStack getSmeltingResult(ItemStack input) {
        if (smeltingCacheSize == 0) {
            ElectricBlastFurnace.buildSmeltingCache();
        }
        if (furnaceSmeltingResults.containsKey(input)) {
            return furnaceSmeltingResults.get(input);
        }
        ItemStack result = null;
        for (BlastingRecipe fr : new HashSet<BlastingRecipe>(cachedSmeltingRecipes)) {
            ItemStack recipeInput = fr.getInput();
            if (!recipeInput.isSimilar(input)) continue;
            result = fr.getResult();
            break;
        }
        if (result != null) {
            furnaceSmeltingResults.put(input, result);
        }
        return result;
    }
}

