/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Furnace;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class ElectricFurnace
extends Device {
    private static final long serialVersionUID = 4286610198705481795L;
    private transient Furnace visualFurnace;
    private transient Furnace furnace;
    private String smeltingString;
    private String resultString;
    private short lastFuel = 0;
    private short arrow = 0;
    public short arrowMax = (short)10;
    private static HashMap<ItemStack, ItemStack> furnaceSmeltingResults = new HashMap();
    private static HashSet<FurnaceRecipe> cachedSmeltingRecipes = new HashSet();
    private static int smeltingCacheSize = 0;
    private static ItemStack haveFuelStack = TUItems.setModelData(TUItems.createItem(Material.GREEN_CONCRETE, String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.BOLD) + "Smelting"), 9537);
    private static ItemStack outFullStack = TUItems.setModelData(TUItems.createItem(Material.RED_CONCRETE, String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No Output Space"), 9538);
    private static ItemStack noPowerStack = TUItems.setModelData(TUItems.createItem(Material.RED_CONCRETE, String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "No Power"), 9538);
    private static ItemStack noOreStack = TUItems.setModelData(TUItems.createItem(Material.RED_CONCRETE, String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Nothing To Smelt"), 9538);
    private static ItemStack notSmeltableStack = TUItems.setModelData(TUItems.createItem(Material.ORANGE_CONCRETE, String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Cannot Smelt This"), 9538);

    public ElectricFurnace(Location loc) {
        super(loc);
        this.setMaterial("FURNACE");
        this.deviceName = "Electric Furnace";
        this.setActionTimer(1);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(15);
        this.setOpenable(true);
        this.setStoreForm(false);
        this.setUseUI(true);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        slots.add(0);
        slots.add(2);
        this.setClickableSlots(slots);
        this.setPollutionGen(3);
    }

    @Override
    public int getGridScore() {
        return 3;
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(MineItems.descColor) + "- Uses power from the grid to smelt items.");
        lore.add(String.valueOf(MineItems.descColor) + "- Behaves like a normal furnace otherwise.");
        return lore;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void cleanup() {
        if (this.getFurnace() != null) {
            if (this.getFurnace().getInventory().getSmelting() != null) {
                this.smeltingString = TUItems.createStackString(this.getFurnace().getInventory().getSmelting());
            }
            if (this.getFurnace().getInventory().getResult() != null) {
                this.resultString = TUItems.createStackString(this.getFurnace().getInventory().getResult());
            }
            this.lastFuel = this.getFurnace().getBurnTime();
        }
    }

    @Override
    public void action() {
        if (this.furnace == null) {
            this.createFurnace(this.materialType);
        }
        if (this.getGrid() != null) {
            boolean reset = false;
            if (this.furnace.getBurnTime() > 0) {
                this.furnace.setBurnTime((short)(this.furnace.getBurnTime() - 1));
                this.updateArrow();
                this.lastFuel = this.getFurnace().getBurnTime();
            }
            if (this.getGrid().hasPower(this.getActionPower())) {
                if (TUItems.isValid(this.furnace.getInventory().getSmelting())) {
                    if (this.getSmeltingResult(this.furnace.getInventory().getSmelting()) != null) {
                        boolean hasSpace;
                        boolean bl = hasSpace = this.furnace.getInventory().getResult() == null;
                        if (!hasSpace) {
                            boolean bl2 = hasSpace = this.furnace.getInventory().getResult().getAmount() < this.furnace.getInventory().getResult().getMaxStackSize();
                        }
                        if (hasSpace) {
                            this.furnace.setBurnTime((short)200);
                            this.getGrid().consumePower(this, this.getActionPower());
                            this.setConsumingPower(true);
                            this.furnace.getInventory().setFuel(haveFuelStack);
                        } else {
                            this.furnace.getInventory().setFuel(outFullStack);
                            reset = true;
                        }
                    } else {
                        this.furnace.getInventory().setFuel(notSmeltableStack);
                        reset = true;
                    }
                } else {
                    this.furnace.getInventory().setFuel(noOreStack);
                    reset = true;
                }
            } else {
                reset = true;
                this.furnace.getInventory().setFuel(noPowerStack);
            }
            if (reset) {
                this.furnace.setBurnTime((short)0);
                this.arrow = 0;
                this.updateArrow();
            }
            this.visualUpdate(TUMaths.isPlayerNearby(this.getLocation(), MineMain.distantDistance));
        } else {
            this.furnace.getInventory().setFuel(noPowerStack);
        }
    }

    @Override
    public Inventory getInventory() {
        if (this.furnace == null) {
            this.createFurnace(this.materialType);
        }
        return this.getFurnace().getInventory();
    }

    @Override
    public void visualUpdate(boolean nearby) {
        if (nearby) {
            if (this.furnace == null) {
                return;
            }
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 32.0)) {
                if (this.visualFurnace == null) {
                    this.visualFurnace = (Furnace)this.getLocation().getBlock().getState();
                }
                this.visualFurnace.setBurnTime(this.furnace.getBurnTime());
                this.visualFurnace.update();
            } else {
                this.visualFurnace = null;
            }
        }
    }

    public void createFurnace(Material furnaceType) {
        this.furnace = (Furnace)Bukkit.createBlockData((Material)furnaceType).createBlockState();
        this.furnace.setCustomName(MineItems.goldBold() + this.deviceName);
        this.furnace.setCookTimeTotal(10);
        this.furnace.setBurnTime(this.lastFuel);
        this.updateArrow();
        if (this.smeltingString != null) {
            this.furnace.getInventory().setSmelting(TUItems.createStackFromString(this.smeltingString));
        }
        if (this.resultString != null) {
            this.furnace.getInventory().setResult(TUItems.createStackFromString(this.resultString));
        }
        this.smeltingString = null;
        this.resultString = null;
        this.furnace.getInventory().setFuel(noPowerStack);
    }

    public Furnace getFurnace() {
        return this.furnace;
    }

    private void updateArrow() {
        FurnaceInventory vFurnace;
        if (this.arrowMax == 0) {
            this.arrowMax = (short)10;
            if (this.materialType.equals((Object)Material.BLAST_FURNACE) || this.materialType.equals((Object)Material.SMOKER)) {
                this.arrowMax = (short)5;
            }
        }
        if ((vFurnace = this.furnace.getInventory()).getSmelting() != null && !vFurnace.getSmelting().getType().equals((Object)Material.AIR)) {
            ItemStack smelted = this.getSmeltingResult(vFurnace.getSmelting());
            this.arrow = smelted != null ? (short)(this.arrow + 1) : (short)0;
            if (this.furnace.getBurnTime() == 0) {
                this.arrow = 0;
            }
            if (this.arrow > this.arrowMax) {
                this.arrow = 0;
                if (vFurnace.getResult() == null || vFurnace.getResult().getAmount() < vFurnace.getResult().getMaxStackSize()) {
                    if (smelted != null) {
                        if (vFurnace.getResult() != null && smelted.isSimilar(vFurnace.getResult()) || vFurnace.getResult() == null) {
                            if (vFurnace.getResult() == null) {
                                vFurnace.setResult(smelted);
                                this.logItem(smelted, 1);
                            } else {
                                vFurnace.getResult().setAmount(vFurnace.getResult().getAmount() + 1);
                                this.logItem(vFurnace.getResult(), 1);
                            }
                            this.logItem(vFurnace.getSmelting(), -1);
                            vFurnace.getSmelting().setAmount(vFurnace.getSmelting().getAmount() - 1);
                        }
                    } else {
                        TUMaths.dm("No smelting result for : " + String.valueOf(vFurnace.getSmelting()));
                    }
                }
            }
        }
        this.furnace.setCookTimeTotal((int)this.arrowMax);
        this.furnace.setCookTime(this.arrow);
    }

    private static void buildSmeltingCache() {
        cachedSmeltingRecipes.clear();
        Iterator iter = Bukkit.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = (Recipe)iter.next();
            if (!(recipe instanceof FurnaceRecipe)) continue;
            FurnaceRecipe fr = (FurnaceRecipe)recipe;
            cachedSmeltingRecipes.add(fr);
        }
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat = materialArray[n2];
            if (Tag.LOGS_THAT_BURN.isTagged((Keyed)mat)) {
                furnaceSmeltingResults.put(new ItemStack(mat), new ItemStack(Material.CHARCOAL));
            }
            ++n2;
        }
        smeltingCacheSize = cachedSmeltingRecipes.size();
    }

    public ItemStack getSmeltingResult(ItemStack input) {
        if (smeltingCacheSize == 0) {
            ElectricFurnace.buildSmeltingCache();
        }
        if (furnaceSmeltingResults.containsKey(input)) {
            return furnaceSmeltingResults.get(input);
        }
        ItemStack result = null;
        for (FurnaceRecipe fr : new HashSet<FurnaceRecipe>(cachedSmeltingRecipes)) {
            ItemStack recipeInput = fr.getInput();
            if (recipeInput.getType().equals((Object)Material.SAND)) {
                recipeInput = new ItemStack(Material.SAND);
            }
            if (!recipeInput.isSimilar(input)) continue;
            result = fr.getResult();
            break;
        }
        if (result != null) {
            furnaceSmeltingResults.put(input, result);
        }
        return result;
    }
}

