/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Producers;

import com.MT.triggersUtility.Events.TUEvents;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.LocaleUtil;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Planets.Planet;
import com.MT.xxxtrigger50xxx.Planets.PlanetHandler;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GasExtractor
extends Device {
    private static final long serialVersionUID = 2989471214567538068L;
    private static String classSpacedNamed = "Gas Extractor";
    private Planet.Gas selectedGas = null;
    private double storedGas = 0.0;
    private transient HashMap<Planet.Gas, Double> gasChoices;

    public GasExtractor(Location loc) {
        super(loc);
        this.setMaterial("CHISELED_STONE_BRICKS");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(1);
        this.setActionPower(2);
        this.setUseUI(true);
        this.useAutoSlots();
        this.useAutoUI();
        this.updateDeviceHeadItem();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Can extract gases from the atmosphere.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
        ItemStack stack = this.createInfoIcon();
        Object gasName = "None";
        if (this.selectedGas != null) {
            gasName = this.selectedGas.toString();
            if (this.gasChoices != null) {
                gasName = (String)gasName + " " + String.valueOf(ChatColor.GRAY) + "(" + String.valueOf(this.gasChoices.get((Object)this.selectedGas)) + ")";
            }
        }
        TUItems.addLore(stack, TUItems.basicLore(MineUtil.colon(" " + LocaleUtil.uiText("General_Click"), "Change Gas"), MineUtil.colon(" Target Gas", (String)gasName), MineUtil.colon(" Stored Gas", "" + this.storedGas)));
        this.getInventory().setItem(13, stack);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 13) {
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.storedGas = 0.0;
            if (this.gasChoices.size() == 0) {
                return;
            }
            boolean changed = false;
            if (this.selectedGas == null) {
                this.selectedGas = new ArrayList<Planet.Gas>(this.gasChoices.keySet()).get(0);
                changed = true;
            }
            if (!changed) {
                Planet.Gas gas;
                boolean next = false;
                Planet.Gas[] gasArray = Planet.Gas.values();
                int n = gasArray.length;
                int n2 = 0;
                while (n2 < n) {
                    gas = gasArray[n2];
                    if (next) {
                        this.selectedGas = gas;
                        next = false;
                        break;
                    }
                    if (gas.equals((Object)this.selectedGas)) {
                        next = true;
                    }
                    ++n2;
                }
                if (next) {
                    gasArray = Planet.Gas.values();
                    n = gasArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        gas = gasArray[n2];
                        if (!gas.equals((Object)this.selectedGas)) {
                            this.selectedGas = gas;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            this.updateUI();
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.BLACK_CANDLE, 1.0);
    }

    @Override
    public void action() {
        if (this.getGrid() == null) {
            return;
        }
        if (this.getOutputSlot() == -1) {
            this.setFailReason("No output space");
            return;
        }
        if (!this.getGrid().hasPower(this.getActionPower())) {
            this.setFailReason("Need more power");
            return;
        }
        if (this.gasChoices == null) {
            Planet planet = PlanetHandler.getPlanetByWorld(this.getLocationREADONLY().getWorld().getName());
            if (planet != null) {
                this.gasChoices = new HashMap();
                Planet.Gas[] gasArray = Planet.Gas.values();
                int n = gasArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object gas = gasArray[n2];
                    if (planet.getGasLevel((Planet.Gas)((Object)gas)) != 0.0) {
                        this.gasChoices.put((Planet.Gas)((Object)gas), planet.getGasLevel((Planet.Gas)((Object)gas)));
                    }
                    ++n2;
                }
            } else {
                this.setFailReason("Must be on a planet");
                return;
            }
        }
        if (this.selectedGas == null) {
            this.setFailReason("No gas selected");
            return;
        }
        boolean tryFill = false;
        if (this.storedGas >= 100.0) {
            tryFill = true;
        } else {
            if (TUMaths.isMultipleOf(TUEvents.serverTimeSeconds, 3)) {
                this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ENTITY_BREEZE_IDLE_AIR, 0.5f, 0.5f);
            }
            this.storedGas += this.gasChoices.get((Object)this.selectedGas) * 20.0;
            this.getGrid().consumePower(this, this.getActionPower());
            this.setConsumingPower(true);
        }
        if (tryFill) {
            boolean tankFill = false;
            ItemStack targetItem = null;
            for (ItemStack stack : this.getInputItems()) {
                if (MineItems.isIndustrialItem(stack, "Empty Gas Canister")) {
                    targetItem = stack;
                    break;
                }
                if (!MineItems.isIndustrialItem(stack, "Oxygen Tank")) continue;
                targetItem = stack;
                tankFill = true;
                break;
            }
            if (targetItem == null) {
                this.setFailReason("Need Empty Gas Canister");
                return;
            }
            this.getGrid().consumePower(this, this.getActionPower());
            this.setConsumingPower(true);
            this.storedGas -= 100.0;
            targetItem.setAmount(targetItem.getAmount() - 1);
            if (!tankFill) {
                this.getInventory().setItem(this.getOutputSlot(), MineItems.getGasCanister(this.selectedGas));
            } else {
                this.getInventory().setItem(this.getOutputSlot(), MineItems.getOxygenTank(100));
            }
            if (MinetorioListener.isPlayerNearbyOPT(this.getLocationREADONLY(), 4.0)) {
                this.getLocationREADONLY().getWorld().playSound(this.getLocationREADONLY(), Sound.ENTITY_BREEZE_IDLE_AIR, 1.0f, 0.75f);
            }
        }
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, GasExtractor.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.MANUFACTORING, new GasExtractor(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(MineItems.getIndustrialItem("Copper Plate", 2));
        ings.add(MineItems.getIndustrialItem("Iron Plate", 3));
        ings.add(MineItems.getIndustrialItem("Copper Cable", 2));
        RecipeUtils.addDefaultRecipe(new GasExtractor(null).getDeviceStack(), ings, MTRecipe.RecipeType.BASIC, true);
    }

    @Override
    public int getGridScore() {
        return 3;
    }
}

