/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Devices.MoverIOCenter;
import com.MT.xxxtrigger50xxx.Devices.Spaceship.CargoPad;
import com.MT.xxxtrigger50xxx.Devices.Transport.RocketSilo;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class CargoEjector
extends Device {
    private static final long serialVersionUID = -1911960147302680686L;
    private static String classSpacedNamed = "Cargo Ejector";
    private String linkedPad;

    public CargoEjector(Location loc) {
        super(loc);
        this.setMaterial("TARGET");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(0);
        this.setActionPower(5);
        this.setUseUI(true);
        this.setupCargoUI();
        this.updateDeviceHeadItem();
    }

    public void setupCargoUI() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int i = 9;
        while (i <= 26) {
            slots.add(i);
            ++i;
        }
        this.setClickableSlots(slots);
        this.setInputSlots(slots);
        this.setOutputSlots(slots);
        i = 0;
        while (i <= 8) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        this.getInventory().setItem(4, this.createInfoIcon());
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Can recieve cargo from space ships and rockets.");
        return lore;
    }

    @Override
    public void updateUI() {
        ItemStack stack = this.createInfoIcon();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(" ");
        lore.add(" " + MineItems.whiteBold() + "Selectable Targets");
        if (this.linkedPad == null) {
            lore.add(String.valueOf(ChatColor.WHITE) + "  >> None");
        } else {
            lore.add(String.valueOf(ChatColor.WHITE) + "  None");
        }
        boolean foundLinkedShip = false;
        ArrayList<CargoPad> cores = CargoPad.getPads(this.getPlacerUUID());
        for (CargoPad pad : cores) {
            if (this.linkedPad == null) {
                lore.add(String.valueOf(ChatColor.WHITE) + "  " + pad.getCargoName());
                continue;
            }
            if (pad.getCargoName().equals(this.linkedPad)) {
                foundLinkedShip = true;
                lore.add(String.valueOf(ChatColor.WHITE) + "  >> " + pad.getCargoName());
                continue;
            }
            lore.add(String.valueOf(ChatColor.WHITE) + "  " + pad.getCargoName());
        }
        if (this.linkedPad != null && !foundLinkedShip) {
            lore.add(String.valueOf(ChatColor.RED) + "  >> " + this.linkedPad + " (Missing Pad)");
        }
        if (cores.size() > 0) {
            lore.add(" ");
            lore.add(String.valueOf(ChatColor.YELLOW) + "  -> Click to change target");
        }
        TUItems.addLore(stack, lore);
        this.getInventory().setItem(4, stack);
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.FIREWORK_ROCKET, 1.0);
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, CargoEjector.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new CargoEjector(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Mover"));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 4));
        RecipeUtils.addDefaultRecipe(new CargoEjector(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.isLeftClick() && event.getSlot() == 4) {
            CargoPad sc = RocketSilo.getNextEntry(CargoPad.getPads(this.getPlacerUUID()), CargoPad.getPadByName(this.linkedPad));
            this.linkedPad = sc != null ? sc.getCargoName() : null;
            this.getLocation().getWorld().playSound(this.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.updateUI();
        }
    }

    @Override
    public void action() {
        if (this.linkedPad == null) {
            this.setFailReason("No linked pad");
            return;
        }
        CargoPad target = CargoPad.getPadByName(this.linkedPad);
        if (this.linkedPad != null && target == null) {
            this.setFailReason("Target pad is missing");
            return;
        }
        if (target.getOutputSlot() == -1) {
            this.setFailReason("Target pad is full!");
            return;
        }
        ArrayList<ItemStack> stacks = this.getInputItems();
        if (stacks.size() == 0) {
            this.setFailReason("Nothing to eject");
            return;
        }
        ItemStack moveStack = null;
        int lastSize = 64;
        for (ItemStack stack : stacks) {
            lastSize = MineUtil.getMoverMaxStackSize(stack.getType(), MoverIOCenter.DeviceIOType.STANDARD);
            if (stack.getAmount() < lastSize) continue;
            moveStack = stack;
            break;
        }
        if (moveStack == null) {
            this.setFailReason("Waiting for stack of " + lastSize);
            return;
        }
        ItemStack sendStack = moveStack.clone();
        moveStack.setAmount(0);
        target.getInventory().setItem(target.getOutputSlot(), sendStack);
        if (MinetorioListener.isPlayerNearbyOPT(this.getLocation(), 6.0)) {
            this.getLocation().getWorld().playSound(this.getLocation(), Sound.BLOCK_VAULT_EJECT_ITEM, 1.0f, 0.8f);
        }
        if (MinetorioListener.isPlayerNearbyOPT(target.getLocation(), 6.0)) {
            target.getLocation().getWorld().playSound(target.getLocation(), Sound.BLOCK_VAULT_INSERT_ITEM, 1.0f, 0.8f);
        }
    }
}

