/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Spaceship;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.Guide.ItemMenu;
import com.MT.xxxtrigger50xxx.Guide.MainMenu;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class CargoPad
extends Device {
    private static final long serialVersionUID = -1911960147302680686L;
    private static String classSpacedNamed = "Cargo Pad";
    private static HashSet<CargoPad> pads = new HashSet();
    private String cargoName;

    public CargoPad(Location loc) {
        super(loc);
        this.setMaterial("TARGET");
        this.deviceName = classSpacedNamed;
        this.setActionTimer(1);
        this.setOpenable(true);
        this.setStoreForm(true);
        this.setIdlePower(0);
        this.setActionPower(0);
        this.setUseUI(true);
        this.setupCargoUI();
        if (loc != null) {
            this.setCargoName("Cargo Pad - " + TUMaths.rollRange(0, 9999));
        }
        this.updateDeviceHeadItem();
    }

    public void setupCargoUI() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int i = 9;
        while (i <= 26) {
            slots.add(i);
            ++i;
        }
        this.setClickableSlots(slots);
        this.setOutputSlots(slots);
        this.setInputSlots(slots);
        i = 0;
        while (i <= 8) {
            this.getInventory().setItem(i, MainMenu.createGoldPane());
            ++i;
        }
        this.getInventory().setItem(4, this.createInfoIcon());
    }

    @Override
    public void postCreate(boolean first) {
        if (this.getLocation() != null) {
            pads.add(this);
        }
    }

    @Override
    public void onDeviceRemove() {
        pads.remove(this);
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Can recieve cargo from space ships and rockets.");
        return lore;
    }

    @Override
    public void updateUI() {
        ItemStack stack = this.createInfoIcon();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(MineUtil.colon(" Pad Name", this.cargoName));
        lore.add(" ");
        lore.add(String.valueOf(ChatColor.YELLOW) + "  -> Click to change name.");
        TUItems.addLore(stack, lore);
        this.getInventory().setItem(4, stack);
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.CHEST, 1.0);
    }

    public static void addDevice() {
        MinetorioListener.deviceClasses.put(classSpacedNamed, CargoPad.class);
        ItemMenu.registerDeviceStack(classSpacedNamed, ItemMenu.Category.LOGISTICS, new CargoPad(null).getDeviceStack(), false);
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(MineItems.getIndustrialItem("Steel Plate", 4));
        RecipeUtils.addDefaultRecipe(new CargoPad(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        if (event.getSlot() == 4) {
            this.getLocation().getWorld().playSound(this.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            Player player = (Player)event.getWhoClicked();
            player.closeInventory();
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    CargoPad.this.setCargoName(message);
                    CargoPad.this.updateUI();
                    this.val$player.openInventory(CargoPad.this.inv);
                }
            }
            ChatInput input = new ChatInput("Enter the desired name in chat now!", false, player);
            input.start(player);
        }
    }

    @Override
    public void action() {
    }

    public String getCargoName() {
        return this.cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public static ArrayList<CargoPad> getPads(UUID placer) {
        ArrayList<CargoPad> scs = new ArrayList<CargoPad>();
        for (CargoPad sc : pads) {
            if (!sc.getPlacerUUID().equals(placer)) continue;
            scs.add(sc);
        }
        return scs;
    }

    public static CargoPad getPadByName(String shipName) {
        if (shipName == null) {
            return null;
        }
        for (CargoPad sc : pads) {
            if (!shipName.equals(sc.getCargoName())) continue;
            return sc;
        }
        return null;
    }
}

