/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineMain;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Elevator
extends Device {
    private static final long serialVersionUID = 7571973330728037017L;
    private static HashSet<Elevator> elevators = new HashSet();
    private transient boolean added = false;
    private String upElevator = null;
    private String downElevator = null;
    private transient Location upLocation = null;
    private transient Location downLocation = null;
    private transient Elevator attachedUp;
    private transient Elevator attachedDown;

    public Elevator(Location loc) {
        super(loc);
        this.setMaterial("TARGET");
        this.deviceName = "Elevator";
        this.setActionTimer(1);
        this.setGridRange(5);
        this.setUseUI(true);
        this.setRefreshInv(false);
        this.setIdlePower(1);
        this.setActionPower(10);
        this.useAutoSlots();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- Swapping items (f) while standing on this activates it.");
        lore.add("- Elevator teleports up or down based on if your looking up or down.");
        lore.add("- No items are required to swap for this to work.");
        lore.add("- Swapping is cancelled when on this device.");
        lore.add("- They can teleport up and down 20 blocks.");
        lore.add("- The above or below elevator must have the same x and z coordinate.");
        return lore;
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
    }

    @Override
    public void action() {
        if (!this.added) {
            elevators.add(this);
            this.added = true;
        }
        if (this.isPowered() && TUMaths.isPlayerNearby(this.getLocation(), MineMain.closeDistance)) {
            Elevator ele;
            Elevator ele2;
            Device device;
            int i;
            Location start;
            if (this.upElevator == null) {
                start = this.getLocation();
                i = 0;
                while (i <= 20) {
                    start.setY(start.getY() + 1.0);
                    if (start.getBlock().getType().equals((Object)Material.TARGET) && Device.isDevice(start.getBlock().getLocation()) && (device = Device.getDevice(start.getBlock().getLocation())) instanceof Elevator) {
                        ele2 = (Elevator)device;
                        this.upElevator = TUMaths.locationString(ele2.getLocation());
                        break;
                    }
                    ++i;
                }
            }
            if (this.downElevator == null) {
                start = this.getLocation();
                i = 0;
                while (i <= 20) {
                    start.setY(start.getY() - 1.0);
                    if (start.getBlock().getType().equals((Object)Material.TARGET) && Device.isDevice(start.getBlock().getLocation()) && (device = Device.getDevice(start.getBlock().getLocation())) instanceof Elevator) {
                        ele2 = (Elevator)device;
                        this.downElevator = TUMaths.locationString(ele2.getLocation());
                        break;
                    }
                    ++i;
                }
            }
            if (this.upElevator != null) {
                Device device2;
                if (this.upLocation == null) {
                    this.upLocation = TUMaths.getStringLocation(this.upElevator);
                }
                if (Device.isDevice(this.upLocation) && (device2 = Device.getDevice(this.upLocation)) instanceof Elevator) {
                    this.attachedUp = ele = (Elevator)device2;
                } else {
                    this.upElevator = null;
                    this.upLocation = null;
                }
            }
            if (this.downElevator != null) {
                Device device3;
                if (this.downLocation == null) {
                    this.downLocation = TUMaths.getStringLocation(this.downElevator);
                }
                if (Device.isDevice(this.downLocation) && (device3 = Device.getDevice(this.downLocation)) instanceof Elevator) {
                    this.attachedDown = ele = (Elevator)device3;
                } else {
                    this.downElevator = null;
                    this.downLocation = null;
                }
            }
        }
    }

    public Elevator getUpElevator() {
        return this.attachedUp;
    }

    public Elevator getDownElevator() {
        return this.attachedDown;
    }

    public static HashSet<Elevator> getAllElevators() {
        return elevators;
    }

    public boolean useTeleporter(final Player player, boolean lookingDown) {
        Location teleLoc = null;
        if (lookingDown) {
            if (this.getDownElevator() != null) {
                teleLoc = TUMaths.centerLocation(this.getDownElevator().getLocation().getBlock().getLocation(), 1.0);
            }
        } else if (this.getUpElevator() != null) {
            teleLoc = TUMaths.centerLocation(this.getUpElevator().getLocation().getBlock().getLocation(), 1.0);
        }
        if (teleLoc != null) {
            teleLoc.setDirection(player.getLocation().getDirection());
            this.setConsumingPower(true);
            this.getGrid().consumePower(this, this.getActionPower());
            player.teleport(teleLoc);
            final Location finalLoc = teleLoc;
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    player.teleport(finalLoc);
                }
            }, 1L);
            player.playSound((Entity)player, Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f, 0.8f);
        }
        return teleLoc != null;
    }
}

