/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.TUItems;
import com.MT.triggersUtility.TUMaths;
import com.MT.xxxtrigger50xxx.Devices.Transport.ProviderChest;
import com.MT.xxxtrigger50xxx.Devices.Transport.RequesterChest;
import com.MT.xxxtrigger50xxx.Devices.Transport.Roboport;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.MineMain;
import com.MT.xxxtrigger50xxx.MineUtil;
import com.MT.xxxtrigger50xxx.MinetorioListener;
import com.MT.xxxtrigger50xxx.PlayerData;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class LogisticBot {
    public static ArrayList<LogisticBot> bots = new ArrayList();
    private Roboport homePort;
    private RequesterChest rc;
    private ProviderChest pc;
    private ItemStack carriedStack;
    private ItemStack targetStack;
    private int pcSlot = -1;
    private Location botLocation;
    private boolean removed = false;
    private boolean returnToPort = false;
    private String action;
    private int power = 100;
    private boolean freePhase = true;
    private int moveSpeed = 1;
    public ArmorStand visualEntity;
    private TravelState travelState = null;
    private Location travelTarget;
    private Location travelCheckpoint;
    private TravelState nextState = null;
    private double travelYLevel = -1.0;

    public LogisticBot(Roboport homePort) {
        PlayerData pd;
        this.homePort = homePort;
        this.setBotLocation(homePort.getLocation().add(0.5, 0.0, 0.5));
        bots.add(this);
        if (MinetorioListener.isPlayerNearbyOPT(this.botLocation, 16.0)) {
            this.botLocation.getWorld().playSound(this.botLocation, Sound.BLOCK_BEEHIVE_EXIT, 0.25f, 0.66f);
        }
        if (homePort.getPlacerUUIDString() != null && (pd = PlayerData.getPlayerData(homePort.getPlacerUUIDString())) != null && pd.hasTech("Logistic Robot Speed")) {
            this.setMoveSpeed(this.getMoveSpeed() + 1);
        }
        new BukkitRunnable(){

            public void run() {
                if (LogisticBot.this.isRemoved()) {
                    this.cancel();
                    return;
                }
                if (LogisticBot.this.travelState == null) {
                    return;
                }
                if (TUMaths.isPlayerNearby(LogisticBot.this.botLocation, MineMain.distantDistance) && LogisticBot.this.botLocation.getBlock().getRelative(BlockFace.UP).getType().isSolid()) {
                    if (LogisticBot.this.freePhase) {
                        LogisticBot.this.freePhase = false;
                        return;
                    }
                    LogisticBot.this.power -= 100;
                } else {
                    --LogisticBot.this.power;
                }
            }
        }.runTaskTimer(MineMain.getPlugin(), 0L, 10L);
        this.tick(0L);
    }

    private void tick(long inTicks) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (LogisticBot.this.isRemoved()) {
                    if (LogisticBot.this.visualEntity != null) {
                        LogisticBot.this.visualEntity.remove();
                    }
                    LogisticBot.this.homePort.dockDrone();
                    return;
                }
                LogisticBot.this.compute();
            }
        }, inTicks);
    }

    public void giveLogisticMoveOrder(RequesterChest rc, ProviderChest pc, int outputSlot, ItemStack target) {
        this.rc = rc;
        this.pc = pc;
        this.pcSlot = outputSlot;
        this.targetStack = target;
        this.action = "Logi Move";
        this.moveToAt(pc.getLocation());
    }

    public void compute() {
        if (TUMaths.isPlayerNearby(this.botLocation, MineMain.distantDistance)) {
            if (this.visualEntity == null) {
                this.visualEntity = (ArmorStand)this.botLocation.getWorld().spawnEntity(this.botLocation, EntityType.ARMOR_STAND);
                this.visualEntity.getEquipment().setHelmet(MineItems.getIndustrialItem("Logistic Robot"));
                this.visualEntity.setGravity(false);
                this.visualEntity.setCollidable(false);
                this.visualEntity.setInvulnerable(true);
                this.visualEntity.setInvisible(true);
                MineUtil.setDisposableEntity((Entity)this.visualEntity);
            }
        } else if (this.visualEntity != null) {
            this.visualEntity.remove();
        }
        if (this.action != null) {
            if (this.travelState != null) {
                if (this.travelState.equals((Object)TravelState.ASCEND) && this.travelCheckpoint == null) {
                    Location loc = this.getBotLocation().clone();
                    loc.setY(this.travelYLevel);
                    this.travelCheckpoint = loc;
                    this.nextState = TravelState.TRAVEL;
                }
                if (this.travelState.equals((Object)TravelState.TRAVEL) && this.travelCheckpoint == null) {
                    this.travelCheckpoint = this.travelTarget.clone();
                    this.travelCheckpoint.setY(this.travelYLevel);
                    this.nextState = TravelState.DESCEND;
                }
                if (this.travelState.equals((Object)TravelState.DESCEND) && this.travelCheckpoint == null) {
                    this.travelCheckpoint = this.travelTarget.clone();
                    this.nextState = TravelState.COMPLETE;
                }
                if (this.travelState.equals((Object)TravelState.COMPLETE)) {
                    this.travelState = null;
                    this.travelTarget = null;
                    this.travelCheckpoint = null;
                }
            }
            if (this.travelCheckpoint != null) {
                this.moveTowards(this.travelCheckpoint);
                if (TUMaths.isLocationNearby(this.travelCheckpoint, this.botLocation, 1.0)) {
                    this.travelCheckpoint = null;
                    this.travelState = this.nextState;
                    this.nextState = null;
                }
                return;
            }
            if (this.returnToPort) {
                if (TUMaths.getManhattanDistance(this.homePort.getLocation(), this.getBotLocation()) <= 2) {
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(MineMain.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            LogisticBot.this.removed = true;
                            if (MinetorioListener.isPlayerNearbyOPT(LogisticBot.this.botLocation, 16.0)) {
                                LogisticBot.this.botLocation.getWorld().playSound(LogisticBot.this.botLocation, Sound.BLOCK_BEEHIVE_ENTER, 0.25f, 0.75f);
                            }
                            LogisticBot.this.tick(0L);
                        }
                    }, 20L);
                    return;
                }
                this.moveToAt(this.homePort.getLocation());
                this.tick(0L);
                return;
            }
            if (this.action.equals("Logi Move")) {
                if (this.carriedStack == null) {
                    if (TUMaths.getManhattanDistance(this.botLocation, this.pc.getLocation()) <= 1) {
                        this.loadRequested();
                    } else {
                        this.moveToAt(this.pc.getLocation());
                    }
                } else if (TUMaths.getManhattanDistance(this.botLocation, this.rc.getLocation()) <= 1) {
                    this.dropOffRequested();
                    if (MinetorioListener.isPlayerNearbyOPT(this.botLocation, 16.0)) {
                        this.botLocation.getWorld().playSound(this.botLocation, Sound.BLOCK_CHISELED_BOOKSHELF_PICKUP, 0.25f, 0.66f);
                    }
                } else {
                    this.moveToAt(this.rc.getLocation());
                }
                this.tick(5L);
                return;
            }
        }
        this.tick(20L);
    }

    private void moveToAt(Location target) {
        this.travelState = TravelState.ASCEND;
        this.travelTarget = target.clone();
        this.travelTarget.add(0.5, 0.0, 0.5);
        this.travelYLevel = target.getY();
        this.travelYLevel += 5.0;
    }

    private void moveTowards(final Location target) {
        Vector disViect = target.toVector().subtract(this.botLocation.toVector());
        double speed = 8.0;
        if (this.power <= 0) {
            speed = 2.0;
        }
        Vector direction = disViect.clone().normalize().multiply(speed);
        int stepCount = 1;
        double spacing = 1.0;
        long intervel = 20L;
        if (TUMaths.isPlayerNearby(this.getBotLocation(), MineMain.distantDistance)) {
            stepCount = 5;
            spacing = 0.2;
            intervel = 4L;
            if (TUMaths.isPlayerNearby(this.getBotLocation(), MineMain.farDistance)) {
                stepCount = 10;
                spacing = 0.1;
                intervel = 2L;
            }
        }
        Vector scaledDirection = direction.multiply(spacing);
        int fStepCount = stepCount;
        new BukkitRunnable(disViect, fStepCount, scaledDirection){
            double travelDistance;
            int runCount;
            Vector adjustedDirection;
            {
                this.travelDistance = vector.length();
                this.runCount = n;
                this.adjustedDirection = vector2;
            }

            public void run() {
                if (this.runCount <= 0 || this.travelDistance <= 0.1) {
                    this.cancel();
                    LogisticBot.this.tick(0L);
                    return;
                }
                LogisticBot.this.botLocation = this.adjustedDirection.length() > (double)TUMaths.getManhattanDistance(LogisticBot.this.botLocation, target) ? target : LogisticBot.this.botLocation.add(this.adjustedDirection);
                this.travelDistance -= this.adjustedDirection.length();
                if (LogisticBot.this.visualEntity != null) {
                    LogisticBot.this.botLocation.setDirection(this.adjustedDirection);
                    LogisticBot.this.visualEntity.teleport(LogisticBot.this.botLocation);
                }
                --this.runCount;
            }
        }.runTaskTimer(MineMain.getPlugin(), 0L, intervel);
    }

    public void loadRequested() {
        if (this.carriedStack == null && this.pc != null && !this.pc.isRemoved()) {
            ItemStack stackInSlot = this.pc.getInventory().getItem(this.pcSlot);
            if (TUItems.isValid(stackInSlot) && stackInSlot.equals((Object)this.targetStack)) {
                this.carriedStack = stackInSlot.clone();
                stackInSlot.setAmount(0);
            } else {
                this.returnToPort = true;
            }
        }
    }

    public void dropOffRequested() {
        if (this.carriedStack != null) {
            for (int outSlot : this.rc.getOutSlots()) {
                ItemStack outItem = this.rc.getInventory().getItem(outSlot);
                if (outItem != null) {
                    int space = outItem.getMaxStackSize() - outItem.getAmount();
                    if (this.carriedStack.getAmount() <= space) {
                        outItem.setAmount(outItem.getAmount() + this.carriedStack.getAmount());
                        this.carriedStack.setAmount(0);
                    } else {
                        outItem.setAmount(outItem.getAmount() + space);
                        this.carriedStack.setAmount(this.carriedStack.getAmount() - space);
                    }
                } else {
                    this.rc.getInventory().setItem(outSlot, this.carriedStack);
                    this.carriedStack.setAmount(0);
                }
                if (this.carriedStack.getAmount() > 0) continue;
                this.rc.removeIncomingItem(this, true);
                this.returnToPort = true;
                return;
            }
        }
    }

    public Roboport getHomePort() {
        return this.homePort;
    }

    public RequesterChest getRc() {
        return this.rc;
    }

    public void setRc(RequesterChest rc) {
        this.rc = rc;
    }

    public ProviderChest getPc() {
        return this.pc;
    }

    public ItemStack getCarriedStack() {
        return this.carriedStack;
    }

    public void setCarriedStack(ItemStack carriedStack) {
        this.carriedStack = carriedStack;
    }

    public int getPcSlot() {
        return this.pcSlot;
    }

    public ItemStack getTargetStack() {
        return this.targetStack;
    }

    public Location getBotLocation() {
        return this.botLocation;
    }

    public void setBotLocation(Location botLocation) {
        this.botLocation = botLocation;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public int getMoveSpeed() {
        return this.moveSpeed;
    }

    public void setMoveSpeed(int moveSpeed) {
        this.moveSpeed = moveSpeed;
    }

    static enum TravelState {
        ASCEND,
        DESCEND,
        TRAVEL,
        COMPLETE;

    }
}

