/*
 * Decompiled with CFR 0.152.
 */
package com.MT.xxxtrigger50xxx.Devices.Transport;

import com.MT.triggersUtility.ChatInput;
import com.MT.triggersUtility.TUItems;
import com.MT.xxxtrigger50xxx.Devices.Device;
import com.MT.xxxtrigger50xxx.MineItems;
import com.MT.xxxtrigger50xxx.Recipes.MTRecipe;
import com.MT.xxxtrigger50xxx.Recipes.RecipeUtils;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class ProviderChest
extends Device {
    private static final long serialVersionUID = -3339401111254451315L;
    private int channel = 0;

    public ProviderChest(Location loc) {
        super(loc);
        this.setMaterial("CHEST");
        this.deviceName = "Provider Chest";
        this.setActionTimer(5);
        this.setActionPower(0);
        this.setIdlePower(1);
        this.setOpenable(true);
        this.setGridRange(0);
        this.setUseUI(true);
        this.useAutoSlots();
    }

    @Override
    public ArrayList<String> stackDescription() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("- This provides items to the logistic network.");
        return lore;
    }

    @Override
    public void onUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 13) {
            class ChatInput
            extends com.MT.triggersUtility.ChatInput {
                private final /* synthetic */ Player val$player;

                public ChatInput(String startMessage, boolean numbersonly, Player player) {
                    this.val$player = player;
                    super(startMessage, numbersonly);
                }

                @Override
                public void inputAction(String message) {
                    ProviderChest.this.setChannel(Integer.valueOf(message));
                    ProviderChest.this.updateUI();
                    this.val$player.openInventory(ProviderChest.this.getInventory());
                }
            }
            ChatInput input = new ChatInput("Enter the new channel number in chat now!", true, player);
            input.start(player);
            player.closeInventory();
            player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    @Override
    public void action() {
    }

    @Override
    public void cleanup() {
        for (ItemStack outStack : this.getOutputItems()) {
            for (int inSlot : this.getInSlots()) {
                ItemStack inStack = this.getInventory().getItem(inSlot);
                if (TUItems.isValid(inStack)) {
                    if (!inStack.isSimilar(outStack)) continue;
                    int space = inStack.getMaxStackSize() - inStack.getAmount();
                    if (space >= outStack.getAmount()) {
                        inStack.setAmount(inStack.getAmount() + outStack.getAmount());
                        outStack.setAmount(0);
                        continue;
                    }
                    inStack.setAmount(inStack.getAmount() + space);
                    outStack.setAmount(outStack.getAmount() - space);
                    continue;
                }
                this.getInventory().setItem(inSlot, outStack.clone());
                outStack.setAmount(0);
            }
        }
    }

    public ArrayList<ItemStack> getStoredStacks(ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stored : this.getInputItems()) {
            if (!stack.isSimilar(stored)) continue;
            stacks.add(stored);
        }
        return stacks;
    }

    public void removeInputAmount(ItemStack stack) {
        int amount = stack.getAmount();
        for (ItemStack item : this.getInputItems()) {
            if (!item.isSimilar(stack)) continue;
            if (amount > item.getAmount()) {
                item.setAmount(0);
                amount -= item.getAmount();
            } else {
                item.setAmount(item.getAmount() - amount);
                amount = 0;
            }
            if (amount <= 0) break;
        }
    }

    @Override
    public void visualUpdate(boolean nearbyPlayer) {
        this.visualIconUpdate(nearbyPlayer, Material.YELLOW_DYE, 1.0);
    }

    public static void addRecipe() {
        ArrayList<ItemStack> ings = new ArrayList<ItemStack>();
        ings.add(MineItems.getIndustrialItem("Electronic Circuit"));
        ings.add(new ItemStack(Material.CHEST));
        RecipeUtils.addDefaultRecipe(new ProviderChest(null).getDeviceStack(), ings, MTRecipe.RecipeType.ADVANCED, true);
    }

    @Override
    public void updateUI() {
        this.useAutoUI();
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }
}

